/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.barbados.resultimport.impl;

import com.sap.sailing.resultimport.CompetitorRow;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.impl.CompetitorRowImpl;
import com.sap.sailing.resultimport.impl.DefaultCompetitorEntryImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class BarbadosResultSpreadsheet {
    private static final int COLUMN_NUMBER_OF_FIRST_RACE_RANK = 5;
    private static final String RACE_SCORE_COLUMN_NAME = "TOTAL SCORE";
    private static final String OVERALL_RESULTS_SHEET_NAME = "OVERALL RESULTS";
    private Sheet overallResultsSheet;

    public BarbadosResultSpreadsheet(InputStream is) throws Exception {
        Workbook wb = WorkbookFactory.create((InputStream)is);
        this.overallResultsSheet = wb.getSheet(OVERALL_RESULTS_SHEET_NAME);
    }

    public RegattaResults getRegattaResults() {
        String iocCountryCode;
        Row row;
        final ArrayList<CompetitorRowImpl> competitorRows = new ArrayList<CompetitorRowImpl>();
        Row header = this.overallResultsSheet.getRow(0);
        int i = 5;
        while (i <= header.getLastCellNum() && !header.getCell(i).getStringCellValue().equals(RACE_SCORE_COLUMN_NAME)) {
            ++i;
        }
        if (i > header.getLastCellNum() || !header.getCell(i).getStringCellValue().equals(RACE_SCORE_COLUMN_NAME)) {
            throw new IllegalArgumentException("Didn't find TOTAL SCORE column");
        }
        int numberOfRaces = i - 5;
        int columnNumberOfTotalScore = i;
        int columnNumberOfNetScore = columnNumberOfTotalScore + 1;
        int columnNumberOfFirstRaceScore = columnNumberOfNetScore + 2;
        int rowIndex = 1;
        while ((row = this.overallResultsSheet.getRow(rowIndex)) != null && (iocCountryCode = row.getCell(1).getStringCellValue()) != null && !iocCountryCode.isEmpty()) {
            Integer totalRank = row.getCell(0) == null ? null : Integer.valueOf((int)row.getCell(0).getNumericCellValue());
            String sailID = String.valueOf(iocCountryCode.trim()) + " " + (int)row.getCell(2).getNumericCellValue();
            String helm = row.getCell(3).getStringCellValue();
            String crew = row.getCell(4).getStringCellValue();
            List<String> names = Arrays.asList(helm, crew);
            double scoreAfterDiscarding = row.getCell(columnNumberOfNetScore).getNumericCellValue();
            Cell cellValue = row.getCell(columnNumberOfTotalScore);
            double totalPointsBeforeDiscarding = cellValue == null ? null : Double.valueOf(cellValue.getNumericCellValue());
            ArrayList<DefaultCompetitorEntryImpl> rankAndMaxPointsReasonAndPointsAndDiscarded = new ArrayList<DefaultCompetitorEntryImpl>();
            int raceNumber = 0;
            while (raceNumber < numberOfRaces) {
                double score;
                String maxPointsReason;
                Integer rank;
                Cell rankOrMaxPointReasonCell = row.getCell(5 + raceNumber);
                try {
                    rank = (int)rankOrMaxPointReasonCell.getNumericCellValue();
                    maxPointsReason = null;
                }
                catch (IllegalStateException e) {
                    rank = null;
                    maxPointsReason = rankOrMaxPointReasonCell.getStringCellValue();
                }
                Cell scoreCellContents = row.getCell(columnNumberOfFirstRaceScore + raceNumber);
                double d = score = scoreCellContents == null ? 0.0 : scoreCellContents.getNumericCellValue();
                if (score != 0.0) {
                    DefaultCompetitorEntryImpl entry = new DefaultCompetitorEntryImpl(rank, maxPointsReason, Double.valueOf(score), false);
                    rankAndMaxPointsReasonAndPointsAndDiscarded.add(entry);
                } else {
                    rankAndMaxPointsReasonAndPointsAndDiscarded.add(null);
                }
                ++raceNumber;
            }
            CompetitorRowImpl competitorRow = new CompetitorRowImpl(totalRank, sailID, names, Double.valueOf(scoreAfterDiscarding), Double.valueOf(totalPointsBeforeDiscarding), rankAndMaxPointsReasonAndPointsAndDiscarded);
            competitorRows.add(competitorRow);
            ++rowIndex;
        }
        return new RegattaResults(){

            public Map<String, String> getMetadata() {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("boatclassName", "505");
                return result;
            }

            public List<CompetitorRow> getCompetitorResults() {
                return competitorRows;
            }
        };
    }
}

