/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.data;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.annotations.Dimension;
import com.sap.sse.datamining.annotations.Statistic;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.impl.User;
import java.util.Collection;
import java.util.Date;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;

public interface HasUserContext {
    public User getUser();

    public SecurityService getSecurityService();

    @Dimension(messageKey="Name")
    default public String getName() {
        return this.getUser().getName();
    }

    @Dimension(messageKey="Locale")
    default public String getLocale() {
        return this.getUser().getLocale() != null ? this.getUser().getLocale().getDisplayName() : "";
    }

    @Dimension(messageKey="HasFullName")
    default public boolean hasFullName() {
        return Util.hasLength((String)this.getUser().getFullName());
    }

    @Dimension(messageKey="FullName")
    default public String getFullName() {
        return this.getUser().getFullName();
    }

    @Dimension(messageKey="EMail")
    default public String getEMail() {
        return this.getUser().getEmail();
    }

    @Dimension(messageKey="HasCompany")
    default public boolean hasCompany() {
        return Util.hasLength((String)this.getUser().getCompany());
    }

    @Dimension(messageKey="Company")
    default public String getCompany() {
        return this.getUser().getCompany();
    }

    @Dimension(messageKey="HasEmail")
    default public boolean hasEmail() {
        return Util.hasLength((String)this.getUser().getEmail());
    }

    @Dimension(messageKey="IsEmailValidated")
    default public boolean isEmailValidated() {
        return this.getUser().isEmailValidated();
    }

    @Statistic(messageKey="NumberOfPermissions")
    default public int getNumberOfPermissions() {
        return Util.size((Iterable)this.getUser().getPermissions());
    }

    @Statistic(messageKey="NumberOfPreferences")
    default public int getNumberOfPreferences() {
        return this.getSecurityService().getAllPreferences(this.getUser().getName()).size();
    }

    default public Session getSession() {
        CacheManager cacheManager = this.getSecurityService().getCacheManager();
        Cache activeSessionCache = cacheManager.getCache("shiro-activeSessionCache");
        for (Object i : activeSessionCache.values()) {
            if (!(i instanceof Session)) continue;
            Session session = (Session)i;
            for (Object attributeKey : session.getAttributeKeys()) {
                PrincipalCollection pc;
                Collection principalList;
                Object attributeValue = session.getAttribute(attributeKey);
                if (!(attributeValue instanceof PrincipalCollection) || (principalList = (pc = (PrincipalCollection)attributeValue).fromRealm(this.getUser().getName())) == null || principalList.isEmpty()) continue;
                return session;
            }
        }
        return null;
    }

    @Statistic(messageKey="DurationSinceLastAccess")
    default public Duration getDurationSinceLastAccess() {
        Session session = this.getSession();
        return session == null ? null : TimePoint.of((Date)session.getLastAccessTime()).until(TimePoint.now());
    }

    @Statistic(messageKey="DurationUntilSessionExpiry")
    default public Duration getDurationUntilSessionExpiry() {
        Session session = this.getSession();
        return session == null ? null : TimePoint.now().until(TimePoint.of((Date)session.getLastAccessTime()).plus(Duration.ofMillis((long)session.getTimeout())));
    }
}

