/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.components;

import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.datamining.data.HasUserContext;
import com.sap.sse.security.datamining.data.impl.UserWithContext;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.User;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;

public class SecurityUsersRetrievalProcessor
extends AbstractRetrievalProcessor<SecurityService, HasUserContext> {
    public SecurityUsersRetrievalProcessor(ExecutorService executor, Collection<Processor<HasUserContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(SecurityService.class, HasUserContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasUserContext> retrieveData(SecurityService securityService) {
        HashSet<HasUserContext> data = new HashSet<HasUserContext>();
        for (User user : securityService.getUserList()) {
            if (this.isAborted()) break;
            if (!securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)user)) continue;
            data.add(new UserWithContext(user, securityService));
        }
        return data;
    }
}

