/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.components;

import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.datamining.data.HasUserGroupContext;
import com.sap.sse.security.datamining.data.HasUserInUserGroupContext;
import com.sap.sse.security.datamining.data.impl.UserInUserGroupWithContext;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.User;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;

public class SecurityUsersInUserGroupRetrievalProcessor
extends AbstractRetrievalProcessor<HasUserGroupContext, HasUserInUserGroupContext> {
    public SecurityUsersInUserGroupRetrievalProcessor(ExecutorService executor, Collection<Processor<HasUserInUserGroupContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasUserGroupContext.class, HasUserInUserGroupContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasUserInUserGroupContext> retrieveData(HasUserGroupContext element) {
        HashSet<HasUserInUserGroupContext> data = new HashSet<HasUserInUserGroupContext>();
        for (User user : element.getUserGroup().getUsers()) {
            if (this.isAborted()) break;
            if (!element.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)user)) continue;
            data.add(new UserInUserGroupWithContext(element, user));
        }
        return data;
    }
}

