/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.components;

import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.datamining.data.HasRoleContext;
import com.sap.sse.security.datamining.data.HasUserContext;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.PermissionAndRoleAssociation;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.User;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;

public abstract class AbstractSecurityRolesOfUserRetrievalProcessor<HUG extends HasUserContext, HRC extends HasRoleContext>
extends AbstractRetrievalProcessor<HUG, HRC> {
    public AbstractSecurityRolesOfUserRetrievalProcessor(ExecutorService executor, Class<HUG> hasUserContextSpecialization, Class<HRC> permissionWithContextSpecialization, Collection<Processor<HRC, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(hasUserContextSpecialization, permissionWithContextSpecialization, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HRC> retrieveData(HUG element) {
        HashSet<HRC> data = new HashSet<HRC>();
        for (Role role : element.getUser().getRoles()) {
            if (this.isAborted()) break;
            WithQualifiedObjectIdentifier roleAssociation = PermissionAndRoleAssociation.getWithQualifiedObjectIdentifier((Role)role, (User)element.getUser());
            if (!element.getSecurityService().hasCurrentUserReadPermission(roleAssociation)) continue;
            data.add(this.createRoleWithContext(element, role));
        }
        return data;
    }

    protected abstract HRC createRoleWithContext(HUG var1, Role var2);
}

