/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.branding.sap;

import com.sap.sse.branding.shared.BrandingConfiguration;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;

public class SAPBrandingConfiguration
implements BrandingConfiguration {
    public static final String ID = "SAP";
    private String defaultBrandingLogoURL;
    private String greyTransparentLogoURL;
    private final ResourceBundleStringMessages sailingServerStringMessages = ResourceBundleStringMessages.create((String)"stringmessages/SAPBrandingStringMessages", (ClassLoader)this.getClass().getClassLoader(), (String)StandardCharsets.UTF_8.name());
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/SAPBrandingStringMessages";
    private static final String IMAGES_ROOT = "/sap-branding/images";

    private static String image(String fileName) {
        return "/sap-branding/images/" + fileName;
    }

    public String getId() {
        return ID;
    }

    public String getDefaultBrandingLogoURL(Optional<String> locale) {
        return this.defaultBrandingLogoURL;
    }

    public String getGreyTransparentLogoURL(Optional<String> locale) {
        return this.greyTransparentLogoURL;
    }

    public String getBrandTitle(Optional<String> locale) {
        return ID;
    }

    public String getSolutionsInSailingImageURL() {
        return SAPBrandingConfiguration.image("solutions-sap-in-sailing.jpg");
    }

    public String getSoutionsInSailingTrimmedImageURL() {
        return SAPBrandingConfiguration.image("solutions-sap-trimmed.png");
    }

    public String getSailingRaceManagerAppImageURL() {
        return SAPBrandingConfiguration.image("solutions-sap-sailing-race-manager.png");
    }

    public String getSailingRaceManagerAppTrimmedImageURL() {
        return SAPBrandingConfiguration.image("solutions-race.png");
    }

    public String getSailInSightAppImageURL() {
        return SAPBrandingConfiguration.image("solutions-sap-sailing-insight.png");
    }

    public String getSailingSimulatorImageURL() {
        return SAPBrandingConfiguration.image("solutions-simulator.png");
    }

    public String getSailingSimulatorTrimmedImageURL() {
        return SAPBrandingConfiguration.image("solutions-simulator-trimmed.png");
    }

    public String getBuoyPingerAppImageURL() {
        return SAPBrandingConfiguration.image("solutions-sap-sailing-buoy-pinger.png");
    }

    public String getSailingAnalyticsImageURL() {
        return SAPBrandingConfiguration.image("solutions-sap.png");
    }

    public String getSailingAnalyticsReadMoreText(Optional<String> locale) {
        return this.sailingServerStringMessages.get(locale.map(l -> Locale.forLanguageTag(l)).orElse(Locale.ENGLISH), "sailingAnalyticsReadMore");
    }

    public String getSailingAnalyticsSailing(Optional<String> locale) {
        return this.sailingServerStringMessages.get(locale.map(l -> Locale.forLanguageTag(l)).orElse(Locale.ENGLISH), "sailingAnalyticsSailing");
    }

    public String getFooterCopyright() {
        return "\u00a9 2011-2026 SAP Sailing Analytics";
    }

    public String getFooterPrivacyLink() {
        return "https://www.sap.com/about/legal/privacy.html?campaigncode=CRM-XH21-OSP-Sailing";
    }

    public String getFooterJobsLink() {
        return "https://jobs.sapsailing.com";
    }

    public String getFooterSupportLink() {
        return "https://support.sapsailing.com";
    }

    public String getSportsOn(Optional<String> locale) {
        return this.sailingServerStringMessages.get(locale.map(l -> Locale.forLanguageTag(l)).orElse(Locale.ENGLISH), "sportsOn");
    }

    public String getFollowSports(Optional<String> locale) {
        return this.sailingServerStringMessages.get(locale.map(l -> Locale.forLanguageTag(l)).orElse(Locale.ENGLISH), "followSports");
    }

    public String getFacebookLink() {
        return "https://www.facebook.com/SAP";
    }

    public String getxLink() {
        return "https://x.com/sap";
    }

    public String getInstagramLink() {
        return "https://www.instagram.com/sap/";
    }

    public String getWelcomeToSailingAnalytics(Optional<String> locale) {
        return this.sailingServerStringMessages.get(locale.map(l -> Locale.forLanguageTag(l)).orElse(Locale.ENGLISH), "welcomeToSailingAnalytics");
    }

    public String getWelcomeToSailingAnalyticsBody(Optional<String> locale) {
        return this.sailingServerStringMessages.get(locale.map(l -> Locale.forLanguageTag(l)).orElse(Locale.ENGLISH), "welcomeToSailingAnalyticsBody");
    }

    public String getMoreLoginInformationNotificationsURL() {
        return SAPBrandingConfiguration.image("notifications.png");
    }

    public String getMoreLoginInformationSettingsURL() {
        return SAPBrandingConfiguration.image("settings.png");
    }

    public String getMoreLoginInformationSailorProfilesURL() {
        return SAPBrandingConfiguration.image("sailorprofiles.png");
    }

    public String getMoreLoginInformationSimulatorURL() {
        return SAPBrandingConfiguration.image("simulator.png");
    }

    public String getInSailingContent(Optional<String> locale) {
        return this.sailingServerStringMessages.get(locale.map(l -> Locale.forLanguageTag(l)).orElse(Locale.ENGLISH), "inSailingContent");
    }

    public String getFollowGitHub(Optional<String> locale) {
        return this.sailingServerStringMessages.get(locale.map(l -> Locale.forLanguageTag(l)).orElse(Locale.ENGLISH), "followGitHub");
    }

    public String getGitHubLink() {
        return "https://github.com/SAP/sailing-analytics";
    }
}

