/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SubmitButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.fileupload.FileUploadUtil;
import com.sap.sse.gwt.adminconsole.EndUploadEvent;
import com.sap.sse.gwt.adminconsole.StartUploadEvent;
import com.sap.sse.gwt.adminconsole.StringMessages;
import com.sap.sse.gwt.adminconsole.URLFieldWithFileUploadResources;
import com.sap.sse.gwt.client.Notification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLFieldWithFileUpload
extends Composite
implements HasValue<Map<String, String>> {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final URLFieldWithFileUploadResources RESOURCES = URLFieldWithFileUploadResources.INSTANCE;
    private static final String UPLOAD_URL = "/sailingserver/fileupload";
    private static final String URI_DELIMITER = " ";
    private final TextBox urlTextBox;
    private final FileUpload fileUploadField;
    private Map<String, String> uriList;
    private String name;
    private boolean valueChangeHandlerInitialized = false;
    private StartUploadEvent startUploadEvent;
    private EndUploadEvent endUploadEvent;
    private final Button removeButton;
    private final FormPanel uploadFormPanel;
    private final FlowPanel uploadPanel;

    public URLFieldWithFileUpload(StringMessages stringMessages, String acceptedFileTypes) {
        this(stringMessages, false, true, true, acceptedFileTypes);
    }

    public URLFieldWithFileUpload(final StringMessages stringMessages, boolean multiFileUpload, boolean initiallyEnableUpload, final boolean showUrlAfterUpload, String acceptedFileTypes) {
        RESOURCES.urlFieldWithFileUploadStyle().ensureInjected();
        this.uriList = new LinkedHashMap<String, String>();
        this.startUploadEvent = new StartUploadEvent(){

            @Override
            public void startUpload() {
                URLFieldWithFileUpload.this.logger.log(Level.FINE, "start upload of file.");
            }
        };
        this.endUploadEvent = new EndUploadEvent(){

            @Override
            public void endUpload() {
                URLFieldWithFileUpload.this.logger.log(Level.FINE, "end upload of file,");
            }
        };
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.ensureDebugId("URLFieldWithFileUpload");
        FlowPanel imageUrlPanel = new FlowPanel();
        imageUrlPanel.addStyleName(RESOURCES.urlFieldWithFileUploadStyle().spaceDirectChildrenClass());
        mainPanel.add((Widget)new Label(stringMessages.pleaseOnlyUploadContentYouHaveAllUsageRightsFor()));
        mainPanel.add((Widget)imageUrlPanel);
        this.removeButton = new Button();
        this.removeButton.setStyleName(RESOURCES.urlFieldWithFileUploadStyle().deleteButtonClass(), true);
        this.removeButton.addStyleName("btn-primary");
        this.removeButton.setEnabled(false);
        this.removeButton.ensureDebugId("RemoveButton");
        this.removeButton.setTitle(stringMessages.resetToDefault());
        this.removeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                for (String uri : URLFieldWithFileUpload.this.uriList.keySet()) {
                    URLFieldWithFileUpload.this.deleteFileOnServer(uri);
                }
                URLFieldWithFileUpload.this.setUri(null, true);
                URLFieldWithFileUpload.this.urlTextBox.setEnabled(true);
            }
        });
        this.urlTextBox = new TextBox();
        this.urlTextBox.ensureDebugId("urlTextBox");
        this.urlTextBox.getElement().addClassName("url-textbox");
        this.urlTextBox.addStyleName(RESOURCES.urlFieldWithFileUploadStyle().urlTextboxClass());
        this.urlTextBox.addValueChangeHandler(valueChangedEvent -> this.setUri((String)valueChangedEvent.getValue(), true));
        imageUrlPanel.add((Widget)this.urlTextBox);
        final Button selectUploadButton = new Button();
        selectUploadButton.setStyleName(RESOURCES.urlFieldWithFileUploadStyle().uploadButtonClass(), true);
        selectUploadButton.addStyleName("btn-primary");
        imageUrlPanel.add((Widget)selectUploadButton);
        imageUrlPanel.add((Widget)this.removeButton);
        this.uploadFormPanel = new FormPanel();
        this.uploadPanel = new FlowPanel();
        this.uploadPanel.setStylePrimaryName(RESOURCES.urlFieldWithFileUploadStyle().spaceDirectChildrenClass());
        this.uploadFormPanel.setAction(UPLOAD_URL);
        this.uploadFormPanel.setEncoding("multipart/form-data");
        this.uploadFormPanel.setMethod("post");
        this.fileUploadField = new FileUpload();
        if (multiFileUpload) {
            this.fileUploadField.getElement().setAttribute("multiple", "multiple");
        }
        if (acceptedFileTypes != null) {
            this.fileUploadField.getElement().setAttribute("accept", acceptedFileTypes);
        }
        this.fileUploadField.setStylePrimaryName(RESOURCES.urlFieldWithFileUploadStyle().fileInputClass());
        InputElement inputElement = (InputElement)this.fileUploadField.getElement().cast();
        inputElement.setName("file");
        this.uploadPanel.add((Widget)this.fileUploadField);
        selectUploadButton.addClickHandler(click -> this.fileUploadField.click());
        final SubmitButton submitButton = new SubmitButton(stringMessages.send());
        submitButton.setVisible(false);
        submitButton.setEnabled(false);
        this.fileUploadField.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (URLFieldWithFileUpload.this.fileUploadField.getFilename() != null && !URLFieldWithFileUpload.this.fileUploadField.getFilename().isEmpty()) {
                    submitButton.setEnabled(true);
                    submitButton.click();
                }
            }
        });
        this.uploadPanel.add((Widget)submitButton);
        this.uploadFormPanel.addSubmitHandler(submitEvent -> {
            this.startUploadEvent.startUpload();
            this.urlTextBox.setValue((Object)stringMessages.upload());
            selectUploadButton.addStyleName(RESOURCES.urlFieldWithFileUploadStyle().loadingClass());
        });
        this.uploadFormPanel.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                for (String localUri : URLFieldWithFileUpload.this.uriList.keySet()) {
                    if (localUri == null || "".equals(localUri)) continue;
                    GWT.log((String)("(1) remove uploaded file " + localUri));
                    URLFieldWithFileUpload.this.deleteFileOnServer(localUri);
                }
                selectUploadButton.removeStyleName(RESOURCES.urlFieldWithFileUploadStyle().loadingClass());
                URLFieldWithFileUpload.this.endUploadEvent.endUpload();
                JSONArray resultJson = JSONParser.parseStrict((String)FileUploadUtil.getApplicationJsonContentFromHtml((String)event.getResults())).isArray();
                if (resultJson != null) {
                    HashMap<String, String> uris = new HashMap<String, String>(resultJson.size());
                    ArrayList<String> titleStrings = new ArrayList<String>(resultJson.size());
                    ArrayList<String> valueStrings = new ArrayList<String>(resultJson.size());
                    int i = 0;
                    while (i < resultJson.size()) {
                        if (resultJson.get(i).isObject() != null) {
                            if (resultJson.get(i).isObject().get("file_uri") != null) {
                                String uri = resultJson.get(i).isObject().get("file_uri").isString().stringValue();
                                String fileNameUnderscoreEncoded = resultJson.get(i).isObject().get("file_name").isString().stringValue();
                                String fileName = fileNameUnderscoreEncoded.replace("%5f%5f", "__");
                                uris.put(uri, fileName);
                                titleStrings.add(fileName);
                                if (showUrlAfterUpload) {
                                    valueStrings.add(uri);
                                } else {
                                    String textShown = "";
                                    int dotPos = fileName.lastIndexOf(46);
                                    if (dotPos >= 0) {
                                        String fileEnding;
                                        textShown = fileEnding = fileName.substring(dotPos + 1);
                                    }
                                    valueStrings.add(textShown);
                                }
                                URLFieldWithFileUpload.this.name = URLFieldWithFileUpload.this.getFileNameWithoutEnding(fileName);
                            } else {
                                URLFieldWithFileUpload.this.urlTextBox.setValue((Object)stringMessages.error());
                                Notification.notify((String)stringMessages.fileUploadResult(resultJson.get(0).isObject().get("status").isString().stringValue(), resultJson.get(0).isObject().get("message").isString().stringValue()), (Notification.NotificationType)Notification.NotificationType.ERROR);
                            }
                        }
                        ++i;
                    }
                    if (!showUrlAfterUpload) {
                        valueStrings.add("- " + stringMessages.uploadSuccessful());
                    }
                    URLFieldWithFileUpload.this.setUris(uris, true);
                    URLFieldWithFileUpload.this.urlTextBox.setTitle(String.join((CharSequence)URLFieldWithFileUpload.URI_DELIMITER, titleStrings));
                    URLFieldWithFileUpload.this.urlTextBox.setValue((Object)String.join((CharSequence)URLFieldWithFileUpload.URI_DELIMITER, valueStrings));
                    URLFieldWithFileUpload.this.urlTextBox.setEnabled(showUrlAfterUpload);
                    URLFieldWithFileUpload.this.removeButton.setEnabled(true);
                } else {
                    URLFieldWithFileUpload.this.urlTextBox.setValue((Object)stringMessages.error());
                }
            }
        });
        if (initiallyEnableUpload) {
            this.uploadFormPanel.add((Widget)this.uploadPanel);
        }
        mainPanel.add((Widget)this.uploadFormPanel);
        this.initWidget((Widget)mainPanel);
    }

    private String getFileNameWithoutEnding(String fileName) {
        String result = fileName;
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos >= 0) {
            String fileEnding = fileName.substring(dotPos);
            result = fileName.replace(fileEnding, "");
        }
        result = result.replaceAll("(?=[-_][^\\\\S])(\\-)", URI_DELIMITER);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getUris() {
        return new ArrayList<String>(this.uriList.keySet());
    }

    private void setUris(Map<String, String> uris, boolean fireEvent) {
        if (uris != null) {
            this.uriList = uris;
        } else {
            this.uriList.clear();
        }
        if (uris == null || uris.size() == 0) {
            this.urlTextBox.setValue((Object)"");
            this.urlTextBox.setTitle("");
        } else {
            this.urlTextBox.setValue((Object)String.join((CharSequence)URI_DELIMITER, this.uriList.keySet()));
        }
        this.removeButton.setEnabled(this.uriList != null);
        if (fireEvent) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, this.uriList);
        }
    }

    public String getUri() {
        String result = null;
        if (this.uriList != null && this.uriList.size() > 0 && this.uriList.keySet().iterator().next() != null) {
            result = this.uriList.keySet().iterator().next().trim();
        }
        return result;
    }

    public void setUri(String uri) {
        this.setUri(uri, false);
    }

    public void setUri(String uri, boolean fireEvent) {
        this.uriList.clear();
        if (uri == null) {
            this.urlTextBox.setValue((Object)"");
            this.urlTextBox.setTitle("");
        } else {
            this.uriList.put(uri, this.extractFileName(uri));
            this.urlTextBox.setValue((Object)uri);
        }
        this.removeButton.setEnabled(uri != null);
        if (fireEvent) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, this.uriList);
        }
    }

    private String extractFileName(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    public FocusWidget getInitialFocusWidget() {
        return this.urlTextBox;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Map<String, String>> handler) {
        if (!this.valueChangeHandlerInitialized) {
            this.valueChangeHandlerInitialized = true;
            this.addDomHandler((EventHandler)new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ValueChangeEvent.fire((HasValueChangeHandlers)URLFieldWithFileUpload.this, (Object)URLFieldWithFileUpload.this.getValue());
                }
            }, ChangeEvent.getType());
        }
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Map<String, String> getValue() {
        return this.uriList;
    }

    public void setValue(Map<String, String> value) {
        this.setUris(value, false);
    }

    public void setValue(Map<String, String> value, boolean fireEvents) {
        this.setUris(value, fireEvents);
    }

    public void setStartUploadEvent(StartUploadEvent startUploadEvent) {
        this.startUploadEvent = startUploadEvent;
    }

    public void setEndUploadEvent(EndUploadEvent endUploadEvent) {
        this.endUploadEvent = endUploadEvent;
    }

    public void setUploadEnabled(boolean uploadEnabled) {
        this.uploadFormPanel.remove((Widget)this.uploadPanel);
        if (uploadEnabled) {
            this.uploadFormPanel.add((Widget)this.uploadPanel);
        } else {
            this.uploadFormPanel.remove((Widget)this.uploadPanel);
        }
    }

    public void fireClickToFileUploadField() {
        this.fileUploadField.click();
    }

    public void deleteCurrentFile() {
        for (String localUri : this.uriList.keySet()) {
            this.deleteFileOnServer(localUri);
        }
    }

    private void deleteFileOnServer(final String localUri) {
        if (localUri == null || "".equals(localUri)) {
            return;
        }
        RequestBuilder request = new RequestBuilder(RequestBuilder.DELETE, "/sailingserver/api/v1/file?uri=" + localUri);
        try {
            request.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    GWT.log((String)("successfully deleted " + localUri + URLFieldWithFileUpload.URI_DELIMITER + response.getText()));
                }

                public void onError(Request request, Throwable exception) {
                    GWT.log((String)("delete failed" + localUri), (Throwable)exception);
                }
            });
        }
        catch (RequestException e) {
            GWT.log((String)("request exception when deleting file" + localUri), (Throwable)e);
        }
    }
}

