/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.replication.RemoteReplicationServiceAsync;
import com.sap.sse.gwt.shared.replication.ReplicaDTO;
import com.sap.sse.gwt.shared.replication.ReplicationMasterDTO;
import com.sap.sse.gwt.shared.replication.ReplicationStateDTO;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReplicationPanel
extends FlowPanel {
    private final Grid registeredReplicas;
    private final Grid registeredMasters;
    private final RemoteReplicationServiceAsync replicationServiceAsync;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final Button addButton;
    private final Button stopReplicationButton;
    private final Button removeAllReplicas;
    private final Set<String> replicableIdsAsStringThatShallLeadToWarningAboutInstanceBeingReplica;

    public ReplicationPanel(RemoteReplicationServiceAsync replicationService, UserService userService, ErrorReporter errorReporter, final StringMessages stringMessages) {
        this.replicationServiceAsync = replicationService;
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        this.replicableIdsAsStringThatShallLeadToWarningAboutInstanceBeingReplica = new HashSet<String>();
        replicationService.getReplicableIdsAsStringThatShallLeadToWarningAboutInstanceBeingReplica((AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                GWT.log((String)stringMessages.errorFetchingReplicaData(caught.getMessage()));
            }

            public void onSuccess(String[] result) {
                String[] stringArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    String replicableIdAsStringThatShallLeadToWarningAboutInstanceBeingReplica = stringArray[n2];
                    ReplicationPanel.this.replicableIdsAsStringThatShallLeadToWarningAboutInstanceBeingReplica.add(replicableIdAsStringThatShallLeadToWarningAboutInstanceBeingReplica);
                    ++n2;
                }
            }
        }));
        Button refreshButton = new Button(stringMessages.refresh());
        refreshButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReplicationPanel.this.updateReplicaList();
            }
        });
        this.add((Widget)refreshButton);
        CaptionPanel mastergroup = new CaptionPanel(stringMessages.explainReplicasRegistered());
        VerticalPanel masterpanel = new VerticalPanel();
        AccessControlledButtonPanel masterPanelButtons = new AccessControlledButtonPanel(userService, SecuredSecurityTypes.SERVER);
        this.registeredReplicas = new Grid();
        this.registeredReplicas.resizeColumns(3);
        masterpanel.add((Widget)this.registeredReplicas);
        this.removeAllReplicas = masterPanelButtons.addAction(stringMessages.stopAllReplicas(), () -> userService.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.REPLICATE), this::stopAllReplicas);
        this.removeAllReplicas.setEnabled(false);
        masterpanel.add((Widget)masterPanelButtons);
        mastergroup.add((Widget)masterpanel);
        this.add((Widget)mastergroup);
        CaptionPanel replicagroup = new CaptionPanel(stringMessages.explainConnectionsToMaster());
        VerticalPanel replicapanel = new VerticalPanel();
        AccessControlledButtonPanel replicapanelbuttons = new AccessControlledButtonPanel(userService, SecuredSecurityTypes.SERVER);
        this.registeredMasters = new Grid();
        this.registeredMasters.resizeColumns(3);
        replicapanel.add((Widget)this.registeredMasters);
        this.addButton = replicapanelbuttons.addAction(stringMessages.connectToMaster(), () -> userService.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.START_REPLICATION), this::addReplication);
        this.stopReplicationButton = replicapanelbuttons.addAction(stringMessages.stopConnectionToMaster(), () -> userService.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.START_REPLICATION), this::stopReplication);
        this.stopReplicationButton.setEnabled(false);
        replicapanel.add((Widget)replicapanelbuttons);
        replicagroup.add((Widget)replicapanel);
        this.add((Widget)replicagroup);
        if (userService.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.READ_REPLICATOR)) {
            this.updateReplicaList();
        }
    }

    protected void stopAllReplicas() {
        this.replicationServiceAsync.stopAllReplicas((AsyncCallback)new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                ReplicationPanel.this.errorReporter.reportError(caught.getMessage());
                ReplicationPanel.this.updateReplicaList();
            }

            public void onSuccess(Void result) {
                ReplicationPanel.this.removeAllReplicas.setEnabled(false);
                ReplicationPanel.this.updateReplicaList();
            }
        });
    }

    private void stopReplication() {
        this.stopReplicationButton.setEnabled(false);
        this.replicationServiceAsync.stopReplicatingFromMaster((AsyncCallback)new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                ReplicationPanel.this.errorReporter.reportError(caught.getMessage());
                ReplicationPanel.this.stopReplicationButton.setEnabled(true);
            }

            public void onSuccess(Void result) {
                ReplicationPanel.this.addButton.setEnabled(true);
                ReplicationPanel.this.stopReplicationButton.setEnabled(false);
                ReplicationPanel.this.updateReplicaList();
            }
        });
    }

    private void addReplication() {
        AddReplicationDialog dialog = new AddReplicationDialog(new DataEntryDialog.Validator<ReplicationData>(){

            public String getErrorMessage(ReplicationData valueToValidate) {
                boolean userNameUnset = valueToValidate.getUserName() == null || valueToValidate.getUserName().isEmpty();
                boolean passWordUnset = valueToValidate.getPassword() == null || valueToValidate.getPassword().isEmpty();
                return userNameUnset == passWordUnset ? null : ReplicationPanel.this.stringMessages.usernameAndPasswordMustBothBeSet();
            }
        }, new DataEntryDialog.DialogCallback<ReplicationData>(){

            public void ok(final ReplicationData state) {
                ReplicationPanel.this.registeredMasters.removeRow(0);
                ReplicationPanel.this.registeredMasters.insertRow(0);
                ReplicationPanel.this.registeredMasters.setWidget(0, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.loading()));
                ReplicationPanel.this.addButton.setEnabled(false);
                ReplicationPanel.this.stopReplicationButton.setEnabled(false);
                ReplicationPanel.this.replicationServiceAsync.startReplicatingFromMaster(state.getMessagingHost(), state.getMasterHostName(), state.getExchangeName(), state.getServletPort(), state.getMessagingPort(), state.getUserName(), state.getPassword(), (AsyncCallback)new AsyncCallback<Void>(){

                    public void onFailure(Throwable e) {
                        ReplicationPanel.this.addButton.setEnabled(true);
                        ReplicationPanel.this.errorReporter.reportError(ReplicationPanel.this.stringMessages.errorStartingReplication(state.getMasterHostName(), state.getExchangeName(), e.getMessage()));
                        ReplicationPanel.this.updateReplicaList();
                    }

                    public void onSuccess(Void arg0) {
                        ReplicationPanel.this.addButton.setEnabled(false);
                        ReplicationPanel.this.stopReplicationButton.setEnabled(true);
                        ReplicationPanel.this.updateReplicaList();
                    }
                });
            }

            public void cancel() {
            }
        });
        dialog.show();
    }

    public void updateReplicaList() {
        this.replicationServiceAsync.getReplicaInfo((AsyncCallback)new AsyncCallback<ReplicationStateDTO>(){

            public void onSuccess(ReplicationStateDTO replicas) {
                int i = 0;
                int replicaCount = 0;
                ReplicationPanel.this.registeredReplicas.clear();
                boolean replicaRegistered = false;
                for (final ReplicaDTO replica : replicas.getReplicas()) {
                    ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, i);
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 0, (Widget)new Label(String.valueOf(++replicaCount) + ". " + replica.getHostname() + " (" + replica.getIdentifier() + ")"));
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 1, (Widget)new Label(ReplicationPanel.this.stringMessages.registeredAt(replica.getRegistrationTime().toString())));
                    Button removeReplicaButton = new Button(ReplicationPanel.this.stringMessages.dropReplicaConnection());
                    removeReplicaButton.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            ReplicationPanel.this.replicationServiceAsync.stopSingleReplicaInstance(replica.getIdentifier(), (AsyncCallback)new AsyncCallback<Void>(){

                                public void onFailure(Throwable caught) {
                                    ReplicationPanel.this.errorReporter.reportError(caught.getMessage());
                                    ReplicationPanel.this.updateReplicaList();
                                }

                                public void onSuccess(Void result) {
                                    ReplicationPanel.this.updateReplicaList();
                                }
                            });
                        }
                    });
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 2, (Widget)removeReplicaButton);
                    ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, ++i);
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 1, (Widget)new Label(ReplicationPanel.this.stringMessages.replicables()));
                    HTML replicablesLabel = new HTML(new SafeHtmlBuilder().appendEscapedLines(Arrays.toString(replica.getReplicableIdsAsStrings()).replaceAll(",", "\n")).toSafeHtml());
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 2, (Widget)replicablesLabel);
                    ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, ++i);
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 1, (Widget)new Label(ReplicationPanel.this.stringMessages.averageNumberOfOperationsPerMessage()));
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 2, (Widget)new Label("" + replica.getAverageNumberOfOperationsPerMessage()));
                    ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, ++i);
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 1, (Widget)new Label(ReplicationPanel.this.stringMessages.additionalInformation()));
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 2, (Widget)new Label(replica.getAdditionalInformation()));
                    ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, ++i);
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 1, (Widget)new Label(ReplicationPanel.this.stringMessages.numberOfQueueMessagesSent()));
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 2, (Widget)new Label("" + replica.getNumberOfMessagesSent()));
                    ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, ++i);
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 1, (Widget)new Label(ReplicationPanel.this.stringMessages.averageMessageSize()));
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 2, (Widget)new Label("" + replica.getAverageMessageSizeInBytes()));
                    ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, ++i);
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 1, (Widget)new Label(ReplicationPanel.this.stringMessages.totalSize()));
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 2, (Widget)new Label(replica.getNumberOfBytesSent() + "B (" + (double)replica.getNumberOfBytesSent() / 1024.0 / 1024.0 + "MB)"));
                    ++i;
                    long totalNumberOfOperations = 0L;
                    for (Map.Entry e : replica.getOperationCountByOperationClassName().entrySet()) {
                        ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, i);
                        ReplicationPanel.this.registeredReplicas.setWidget(i, 1, (Widget)new Label((String)e.getKey()));
                        ReplicationPanel.this.registeredReplicas.setWidget(i, 2, (Widget)new Label(((Integer)e.getValue()).toString()));
                        totalNumberOfOperations += (long)((Integer)e.getValue()).intValue();
                        ++i;
                    }
                    ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, i);
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 1, (Widget)new Label(ReplicationPanel.this.stringMessages.totalNumberOfOperations()));
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 2, (Widget)new Label("" + totalNumberOfOperations));
                    ++i;
                    replicaRegistered = true;
                }
                if (!replicaRegistered) {
                    ReplicationPanel.this.insertRowIfNeeded(ReplicationPanel.this.registeredReplicas, i);
                    ReplicationPanel.this.registeredReplicas.setWidget(i, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.explainNoConnectionsFromReplicas()));
                    ReplicationPanel.this.removeAllReplicas.setEnabled(false);
                    ++i;
                } else {
                    ReplicationPanel.this.removeAllReplicas.setEnabled(true);
                }
                while (ReplicationPanel.this.registeredReplicas.getRowCount() > i) {
                    ReplicationPanel.this.registeredReplicas.removeRow(ReplicationPanel.this.registeredReplicas.getRowCount() - 1);
                }
                while (ReplicationPanel.this.registeredMasters.getRowCount() > 0) {
                    ReplicationPanel.this.registeredMasters.removeRow(0);
                }
                i = 0;
                ReplicationPanel.this.registeredMasters.insertRow(i);
                ReplicationPanel.this.registeredMasters.setWidget(i, 0, (Widget)new Label("Client UUID: " + replicas.getServerIdentifier()));
                ++i;
                ReplicationMasterDTO replicatingFromMaster = replicas.getReplicatingFromMaster();
                if (replicatingFromMaster != null) {
                    String[] stringArray = replicatingFromMaster.getReplicableIdsAsString();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String replicableIdAsStringOfReplicableThatWeAreReplicatingCurrently = stringArray[n2];
                        if (Util.contains((Iterable)ReplicationPanel.this.replicableIdsAsStringThatShallLeadToWarningAboutInstanceBeingReplica, (Object)replicableIdAsStringOfReplicableThatWeAreReplicatingCurrently)) {
                            ReplicationPanel.this.errorReporter.reportPersistentInformation(ReplicationPanel.this.stringMessages.warningServerIsReplica());
                            break;
                        }
                        ++n2;
                    }
                    ReplicationPanel.this.registeredMasters.insertRow(i);
                    ReplicationPanel.this.registeredMasters.setWidget(i, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.replicatingFromMaster(replicatingFromMaster.getHostname(), replicatingFromMaster.getMessagingPort(), replicatingFromMaster.getServletPort(), replicatingFromMaster.getMessagingHostname(), replicatingFromMaster.getExchangeName(), Arrays.toString(replicatingFromMaster.getReplicableIdsAsString()))));
                    ++i;
                    ReplicationPanel.this.addButton.setEnabled(false);
                    ReplicationPanel.this.stopReplicationButton.setEnabled(true);
                } else {
                    ReplicationPanel.this.errorReporter.reportPersistentInformation("");
                    ReplicationPanel.this.registeredMasters.insertRow(i);
                    ReplicationPanel.this.registeredMasters.setWidget(i, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.explainNoConnectionsToMaster()));
                    ReplicationPanel.this.addButton.setEnabled(true);
                    ReplicationPanel.this.stopReplicationButton.setEnabled(false);
                }
            }

            public void onFailure(Throwable e) {
                ReplicationPanel.this.errorReporter.reportError(ReplicationPanel.this.stringMessages.errorFetchingReplicaData(e.getMessage()));
            }
        });
    }

    private void insertRowIfNeeded(Grid grid, int zeroBasedRowNumber) {
        if (grid.getRowCount() <= zeroBasedRowNumber) {
            grid.insertRow(zeroBasedRowNumber);
        }
    }

    private class AddReplicationDialog
    extends DataEntryDialog<ReplicationData> {
        private final TextBox hostnameEntryField;
        private final TextBox exchangeHostnameEntryField;
        private final TextBox exchangenameEntryField;
        private final IntegerBox messagingPortField;
        private final IntegerBox servletPortField;
        private final TextBox usernameEntryField;
        private final PasswordTextBox passwordEntryField;

        public AddReplicationDialog(DataEntryDialog.Validator<ReplicationData> validator, DataEntryDialog.DialogCallback<ReplicationData> callback) {
            super(ReplicationPanel.this.stringMessages.connect(), ReplicationPanel.this.stringMessages.enterMaster(), ReplicationPanel.this.stringMessages.ok(), ReplicationPanel.this.stringMessages.cancel(), validator, callback);
            this.hostnameEntryField = this.createTextBox("localhost");
            this.exchangeHostnameEntryField = this.createTextBox("localhost");
            this.exchangenameEntryField = this.createTextBox("sapsailinganalytics");
            this.messagingPortField = this.createIntegerBox(0, 5);
            this.servletPortField = this.createIntegerBox(8888, 5);
            this.usernameEntryField = this.createTextBox("admin");
            this.passwordEntryField = this.createPasswordTextBox("admin");
        }

        protected Widget getAdditionalWidget() {
            Grid grid = new Grid(14, 2);
            grid.setWidget(0, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.hostname()));
            grid.setWidget(0, 1, (Widget)this.hostnameEntryField);
            grid.setWidget(1, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.explainReplicationHostname()));
            grid.setWidget(2, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.exchangeHost()));
            grid.setWidget(2, 1, (Widget)this.exchangeHostnameEntryField);
            grid.setWidget(3, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.explainExchangeHostName()));
            grid.setWidget(4, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.exchangeName()));
            grid.setWidget(4, 1, (Widget)this.exchangenameEntryField);
            grid.setWidget(5, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.explainReplicationExchangeName()));
            grid.setWidget(6, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.messagingPortNumber()));
            grid.setWidget(6, 1, (Widget)this.messagingPortField);
            grid.setWidget(7, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.explainReplicationExchangePort()));
            grid.setWidget(8, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.servletPortNumber()));
            grid.setWidget(8, 1, (Widget)this.servletPortField);
            grid.setWidget(9, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.explainReplicationServletPort()));
            grid.setWidget(10, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.username()));
            grid.setWidget(10, 1, (Widget)this.usernameEntryField);
            grid.setWidget(11, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.explainUserName()));
            grid.setWidget(12, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.password()));
            grid.setWidget(12, 1, (Widget)this.passwordEntryField);
            grid.setWidget(13, 0, (Widget)new Label(ReplicationPanel.this.stringMessages.explainPassword()));
            return grid;
        }

        protected Focusable getInitialFocusWidget() {
            return this.hostnameEntryField;
        }

        protected ReplicationData getResult() {
            return new ReplicationData(this.exchangeHostnameEntryField.getValue(), this.hostnameEntryField.getValue(), this.exchangenameEntryField.getValue(), (Integer)this.messagingPortField.getValue(), (Integer)this.servletPortField.getValue(), this.usernameEntryField.getValue(), this.passwordEntryField.getValue());
        }
    }

    private static class ReplicationData {
        private final String messagingHost;
        private final String masterHostName;
        private final String exchangeName;
        private final int messagingPort;
        private final int servletPort;
        private final String userName;
        private final String password;

        public ReplicationData(String messagingHost, String masterHostName, String exchangeName, int messagingPort, int servletPort, String userName, String password) {
            this.messagingHost = messagingHost;
            this.masterHostName = masterHostName;
            this.exchangeName = exchangeName;
            this.messagingPort = messagingPort;
            this.servletPort = servletPort;
            this.userName = userName;
            this.password = password;
        }

        public String getMessagingHost() {
            return this.messagingHost;
        }

        public String getMasterHostName() {
            return this.masterHostName;
        }

        public String getExchangeName() {
            return this.exchangeName;
        }

        public int getMessagingPort() {
            return this.messagingPort;
        }

        public int getServletPort() {
            return this.servletPort;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

