/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingreplayadapter.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.shared.tracking.impl.TrackingConnectorInfoImpl;
import com.sap.sailing.domain.swisstimingadapter.DomainFactory;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingAdapter;
import com.sap.sailing.domain.swisstimingreplayadapter.CompetitorStatus;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.BoatType;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.MarkType;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.RaceStatus;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.SwissTimingReplayAdapter;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.SwissTimingReplayConnectivityParameters;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.Weather;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.TrackingDataLoader;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.impl.EmptyWindStore;
import com.sap.sailing.domain.tracking.impl.MarkPassingImpl;
import com.sap.sailing.domain.tracking.impl.TrackedRaceStatusImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import difflib.PatchFailedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SwissTimingReplayToDomainAdapter
extends SwissTimingReplayAdapter
implements TrackingDataLoader {
    private static final int THRESHOLD_FOR_EARLIEST_MARK_PASSING_BEFORE_START_IN_MILLIS = 30000;
    private static final Logger logger = Logger.getLogger(SwissTimingReplayToDomainAdapter.class.getName());
    private final DomainFactory domainFactory;
    private final Map<String, RaceDefinition> racePerRaceIdForRaceDefinition;
    private final Map<String, DynamicTrackedRace> trackedRacePerRaceID;
    private String currentRaceID;
    private TimePoint referenceTimePoint;
    private Position referenceLocation;
    private final Map<String, Map<Competitor, Boat>> competitorsAndBoatsPerRaceID;
    private final Map<String, Map<String, Mark>> marksPerRaceIDPerMarkID;
    private final Map<String, TimePoint> bestStartTimePerRaceID;
    private final Map<String, TimePoint> raceTimePerRaceID;
    private List<ControlPoint> currentCourseDefinition;
    private final Regatta regatta;
    private final TrackedRegattaRegistry trackedRegattaRegistry;
    private final Map<Integer, Mark> markByHashValue;
    private final Map<Integer, Competitor> competitorByHashValue;
    private final Map<ControlPoint, SpeedWithBearing> windAtControlPoint;
    private final Map<Competitor, Short> lastNextMark;
    private RaceStatus lastRaceStatus;
    private final boolean useInternalMarkPassingAlgorithm;
    private final RaceLogAndTrackedRaceResolver raceLogResolver;
    private final MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry;
    private final String raceName;
    private final String raceIdForRaceDefinition;
    private final DynamicRaceDefinitionSet dynamicRaceDefinitionSet;
    private final SwissTimingReplayConnectivityParameters.SwissTimingReplayRaceTracker tracker;
    private final RaceTrackingHandler raceTrackingHandler;

    public SwissTimingReplayToDomainAdapter(Regatta regatta, String raceName, String raceIdForRaceDefinition, BoatClass boatClass, DomainFactory domainFactory, TrackedRegattaRegistry trackedRegattaRegistry, boolean useInternalMarkPassingAlgorithm, RaceLogAndTrackedRaceResolver raceLogResolver, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, TrackerConstructor trackerConstructor, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        this.tracker = trackerConstructor == null ? null : trackerConstructor.createTracker(this);
        this.raceLogResolver = raceLogResolver;
        this.markPassingRaceFingerprintRegistry = markPassingRaceFingerprintRegistry;
        this.dynamicRaceDefinitionSet = trackerConstructor == null ? null : (race, trackedRace) -> this.tracker.notifyRaceCreationListeners();
        this.raceName = raceName;
        this.raceIdForRaceDefinition = raceIdForRaceDefinition;
        Regatta effectiveRegatta = regatta == null ? trackedRegattaRegistry.getRememberedRegattaForRace((Serializable)((Object)raceIdForRaceDefinition)) : regatta;
        this.regatta = effectiveRegatta == null ? domainFactory.getOrCreateDefaultRegatta(raceLogStore, regattaLogStore, raceIdForRaceDefinition, boatClass, trackedRegattaRegistry) : effectiveRegatta;
        this.regatta.setControlTrackingFromStartAndFinishTimes(true);
        this.trackedRegattaRegistry = trackedRegattaRegistry;
        this.racePerRaceIdForRaceDefinition = new HashMap<String, RaceDefinition>();
        this.trackedRacePerRaceID = new HashMap<String, DynamicTrackedRace>();
        this.bestStartTimePerRaceID = new HashMap<String, TimePoint>();
        this.raceTimePerRaceID = new HashMap<String, TimePoint>();
        this.competitorsAndBoatsPerRaceID = new HashMap<String, Map<Competitor, Boat>>();
        this.marksPerRaceIDPerMarkID = new HashMap<String, Map<String, Mark>>();
        this.markByHashValue = new HashMap<Integer, Mark>();
        this.competitorByHashValue = new HashMap<Integer, Competitor>();
        this.windAtControlPoint = new HashMap<ControlPoint, SpeedWithBearing>();
        this.lastNextMark = new HashMap<Competitor, Short>();
        this.domainFactory = domainFactory;
        this.useInternalMarkPassingAlgorithm = useInternalMarkPassingAlgorithm;
        this.raceTrackingHandler = raceTrackingHandler;
    }

    public RaceTracker getTracker() {
        return this.tracker;
    }

    public Regatta getRegatta() {
        return this.regatta;
    }

    public Iterable<DynamicTrackedRace> getTrackedRaces() {
        return this.trackedRacePerRaceID.values();
    }

    @Override
    public void referenceTimestamp(long referenceTimestampMillis) {
        this.referenceTimePoint = new MillisecondsTimePoint(referenceTimestampMillis);
    }

    @Override
    public void referenceLocation(int latitude, int longitude) {
        this.referenceLocation = new DegreePosition((double)latitude / 1.0E7, (double)longitude / 1.0E7);
    }

    @Override
    public void raceID(String raceID) {
        this.currentRaceID = raceID;
    }

    private boolean isValid(int threeByteValue) {
        return threeByteValue != 0xFFFFFF;
    }

    @Override
    public void frameMetaData(byte cid, int raceTime, int startTime, int estimatedStartTime, RaceStatus raceStatus, short distanceToNextMark, Weather weather, short humidity, short temperature, String messageText, byte cFlag, byte rFlag, byte duration, short nextMark) {
        if (raceStatus != this.lastRaceStatus) {
            DynamicTrackedRace trackedRace;
            this.lastRaceStatus = raceStatus;
            if (raceStatus == RaceStatus.running && (trackedRace = this.trackedRacePerRaceID.get(this.currentRaceID)) != null) {
                List noMarkPassings = Collections.emptyList();
                for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
                    trackedRace.updateMarkPassings(competitor, noMarkPassings);
                }
            }
        }
        if (this.isValid(startTime)) {
            TimePoint startTimeReceived = this.getTimePoint(startTime);
            this.bestStartTimePerRaceID.put(this.currentRaceID, startTimeReceived);
            DynamicTrackedRace trackedRace = this.trackedRacePerRaceID.get(this.currentRaceID);
            if (trackedRace != null) {
                trackedRace.setStartTimeReceived(startTimeReceived);
            }
        } else if (this.isValid(estimatedStartTime)) {
            this.bestStartTimePerRaceID.put(this.currentRaceID, this.getTimePoint(estimatedStartTime));
        }
        if (this.isValid(raceTime) && this.bestStartTimePerRaceID.containsKey(this.currentRaceID)) {
            this.raceTimePerRaceID.put(this.currentRaceID, this.bestStartTimePerRaceID.get(this.currentRaceID).plus((long)(1000 * raceTime)));
        }
    }

    private TimePoint getTimePoint(int threeByteTimeSpecInSecondsSinceMidnight) {
        assert (this.isValid(threeByteTimeSpecInSecondsSinceMidnight));
        return this.getMidnight(this.referenceTimePoint).plus((long)(1000 * threeByteTimeSpecInSecondsSinceMidnight));
    }

    private TimePoint getMidnight(TimePoint referenceTimePoint) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(referenceTimePoint.asMillis());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new MillisecondsTimePoint(cal.getTimeInMillis());
    }

    @Override
    public void competitor(int hashValue, String threeLetterIOCCode, String sailNumberOrTrackerID, String name, CompetitorStatus competitorStatus, BoatType boatType, short cRank_Bracket, short cnPoints_x10_Bracket, short ctPoints_x10_Winner) {
        if (boatType == BoatType.Competitor) {
            Util.Pair competitorAndBoat = this.domainFactory.createCompetitorWithoutID(sailNumberOrTrackerID, threeLetterIOCCode.trim(), name.trim(), this.currentRaceID, this.domainFactory.getRaceTypeFromRaceID(this.currentRaceID).getBoatClass(), this.raceTrackingHandler);
            Map<Competitor, Boat> competitorAndBoatsOfCurrentRace = this.competitorsAndBoatsPerRaceID.get(this.currentRaceID);
            if (competitorAndBoatsOfCurrentRace == null) {
                competitorAndBoatsOfCurrentRace = new HashMap<Competitor, Boat>();
                this.competitorsAndBoatsPerRaceID.put(this.currentRaceID, competitorAndBoatsOfCurrentRace);
            }
            competitorAndBoatsOfCurrentRace.put((Competitor)competitorAndBoat.getA(), (Boat)competitorAndBoat.getB());
            this.competitorByHashValue.put(hashValue, (Competitor)competitorAndBoat.getA());
        } else {
            Mark mark = this.domainFactory.getOrCreateMark((Serializable)((Object)sailNumberOrTrackerID.trim()), name);
            Map<String, Mark> marksOfCurrentRace = this.marksPerRaceIDPerMarkID.get(this.currentRaceID);
            if (marksOfCurrentRace == null) {
                marksOfCurrentRace = new HashMap<String, Mark>();
                this.marksPerRaceIDPerMarkID.put(this.currentRaceID, marksOfCurrentRace);
            }
            marksOfCurrentRace.put(sailNumberOrTrackerID.trim(), mark);
            this.markByHashValue.put(hashValue, mark);
        }
    }

    @Override
    public void mark(MarkType markType, String name, byte index, String id1, String id2, short windSpeedInKnots, short trueWindDirectionInDegrees) {
        ArrayList<String> markNamesAsIds = new ArrayList<String>();
        markNamesAsIds.add(id1.trim());
        if (id2 != null && !id2.trim().isEmpty()) {
            markNamesAsIds.add(id2.trim());
        }
        ControlPoint controlPoint = this.domainFactory.getOrCreateControlPoint(name, markNamesAsIds, this.getMarkType(markType), name);
        if (index == 0) {
            this.currentCourseDefinition = new ArrayList<ControlPoint>();
        }
        while (this.currentCourseDefinition.size() < index + 1) {
            this.currentCourseDefinition.add(null);
        }
        this.currentCourseDefinition.set(index, controlPoint);
        if (windSpeedInKnots != -1 && trueWindDirectionInDegrees != -1) {
            KnotSpeedWithBearingImpl windSpeedWithBearing = new KnotSpeedWithBearingImpl((double)windSpeedInKnots, new DegreeBearingImpl((double)trueWindDirectionInDegrees).reverse());
            this.windAtControlPoint.put(controlPoint, (SpeedWithBearing)windSpeedWithBearing);
        } else {
            this.windAtControlPoint.remove(controlPoint);
        }
    }

    private com.sap.sailing.domain.common.MarkType getMarkType(MarkType markType) {
        com.sap.sailing.domain.common.MarkType result = markType == null ? null : (markType.isBoat() ? (markType.isStart() ? com.sap.sailing.domain.common.MarkType.STARTBOAT : (markType.isFinish() ? com.sap.sailing.domain.common.MarkType.FINISHBOAT : com.sap.sailing.domain.common.MarkType.BUOY)) : com.sap.sailing.domain.common.MarkType.BUOY);
        return result;
    }

    @Override
    public void trackersCount(short trackersCount) {
        RaceDefinition race = this.racePerRaceIdForRaceDefinition.get(this.raceIdForRaceDefinition);
        if (race == null) {
            this.createRace();
        } else {
            Course course = race.getCourse();
            try {
                ArrayList<Util.Pair> courseToUpdate = new ArrayList<Util.Pair>();
                for (ControlPoint cp : this.currentCourseDefinition) {
                    courseToUpdate.add(new Util.Pair((Object)cp, (Object)PassingInstruction.None));
                }
                course.update(courseToUpdate, course.getAssociatedRoles(), course.getOriginatingCourseTemplateIdOrNull(), this.domainFactory.getBaseDomainFactory());
            }
            catch (PatchFailedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRace() {
        try {
            RaceDefinition race = this.domainFactory.createRaceDefinition(this.regatta, this.currentRaceID, this.competitorsAndBoatsPerRaceID.get(this.currentRaceID), this.currentCourseDefinition, this.raceName, this.raceIdForRaceDefinition, this.raceTrackingHandler);
            Map<String, RaceDefinition> map = this.racePerRaceIdForRaceDefinition;
            synchronized (map) {
                this.racePerRaceIdForRaceDefinition.put(this.raceIdForRaceDefinition, race);
                this.racePerRaceIdForRaceDefinition.notifyAll();
            }
            DynamicTrackedRace trackedRace = this.raceTrackingHandler.createTrackedRace((TrackedRegatta)this.getTrackedRegatta(), race, Collections.emptyList(), (WindStore)EmptyWindStore.INSTANCE, 5000L, 30000L, race.getBoatClass().getApproximateManeuverDurationInMilliseconds(), null, this.useInternalMarkPassingAlgorithm, this.raceLogResolver, Optional.empty(), (TrackingConnectorInfo)new TrackingConnectorInfoImpl("SwissTiming", SwissTimingAdapter.DEFAULT_URL, null), this.markPassingRaceFingerprintRegistry);
            trackedRace.onStatusChanged((TrackingDataLoader)this, (TrackedRaceStatus)new TrackedRaceStatusImpl(TrackedRaceStatusEnum.LOADING, 0.0));
            TimePoint bestStartTimeKnownSoFar = this.bestStartTimePerRaceID.get(this.currentRaceID);
            if (bestStartTimeKnownSoFar != null) {
                trackedRace.setStartTimeReceived(bestStartTimeKnownSoFar);
            }
            this.trackedRacePerRaceID.put(this.currentRaceID, trackedRace);
            if (this.dynamicRaceDefinitionSet != null) {
                this.dynamicRaceDefinitionSet.addRaceDefinition(race, trackedRace);
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error while creating race " + this.raceName + " for regatta " + this.regatta, exception);
            try {
                if (this.tracker != null) {
                    this.trackedRegattaRegistry.stopTracker(this.regatta, this.getTracker());
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Something else went wrong while trying to notify the TrackedRegattaRegistry that the race  could not be added to the the regatta " + this.regatta, e);
            }
        }
    }

    public DynamicTrackedRegatta getTrackedRegatta() {
        return this.trackedRegattaRegistry.getOrCreateTrackedRegatta(this.regatta);
    }

    public RaceDefinition getRaceDefinition(String raceID) throws InterruptedException {
        return this.getRaceDefinition(raceID, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaceDefinition getRaceDefinition(String raceIdForRaceDefinition, long timeoutInMillis) throws InterruptedException {
        RaceDefinition result;
        long targetTime = 0L;
        if (timeoutInMillis != 0L) {
            targetTime = System.currentTimeMillis() + timeoutInMillis;
        }
        Map<String, RaceDefinition> map = this.racePerRaceIdForRaceDefinition;
        synchronized (map) {
            while (!this.racePerRaceIdForRaceDefinition.containsKey(raceIdForRaceDefinition)) {
                this.racePerRaceIdForRaceDefinition.wait(timeoutInMillis == 0L ? 0L : Math.max(1L, targetTime - System.currentTimeMillis()));
                if (timeoutInMillis != 0L && System.currentTimeMillis() > targetTime) break;
            }
            result = this.racePerRaceIdForRaceDefinition.get(raceIdForRaceDefinition);
        }
        return result;
    }

    @Override
    public void trackers(int hashValue, int latitude, int longitude, short cog, short sog_Knots_x10, short average_sog, short vmg_Knots_x10, CompetitorStatus competitorStatus, short rank, short distanceToLeader_meters, short distanceToNextMark_meters, short nextMark, short pRank, short ptPoints, short pnPoints) {
        DynamicTrackedRace trackedRace = this.trackedRacePerRaceID.get(this.currentRaceID);
        DegreePosition position = new DegreePosition(this.referenceLocation.getLatDeg() - (double)latitude / 1.0E7, this.referenceLocation.getLngDeg() - (double)longitude / 1.0E7);
        TimePoint raceTimePoint = this.raceTimePerRaceID.containsKey(this.currentRaceID) ? this.raceTimePerRaceID.get(this.currentRaceID) : this.referenceTimePoint;
        DegreeBearingImpl bearing = new DegreeBearingImpl((double)cog);
        KnotSpeedWithBearingImpl speed = new KnotSpeedWithBearingImpl((double)sog_Knots_x10 / 10.0, (Bearing)bearing);
        GPSFixMovingImpl fix = new GPSFixMovingImpl((Position)position, raceTimePoint, (SpeedWithBearing)speed, null);
        Mark mark = this.markByHashValue.get(hashValue);
        if (mark != null) {
            Iterator<Map.Entry<ControlPoint, SpeedWithBearing>> i = this.windAtControlPoint.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<ControlPoint, SpeedWithBearing> controlPointWithWind = i.next();
                if (!Util.contains((Iterable)controlPointWithWind.getKey().getMarks(), (Object)mark)) continue;
                trackedRace.recordWind((Wind)new WindImpl((Position)position, raceTimePoint, controlPointWithWind.getValue()), (WindSource)new WindSourceWithAdditionalID(WindSourceType.EXPEDITION, mark.getName()));
                i.remove();
            }
            trackedRace.recordFix(mark, (GPSFix)fix);
        } else {
            Competitor competitor = this.competitorByHashValue.get(hashValue);
            if (competitor != null) {
                trackedRace.recordFix(competitor, (GPSFixMoving)fix);
                Course course = trackedRace.getRace().getCourse();
                if (!(this.useInternalMarkPassingAlgorithm || this.bestStartTimePerRaceID.get(this.currentRaceID) == null || this.bestStartTimePerRaceID.get(this.currentRaceID).after(raceTimePoint.plus(30000L)) || this.lastNextMark.containsKey(competitor) && this.lastNextMark.get(competitor) == nextMark || nextMark <= 0)) {
                    Waypoint waypointPassed = nextMark == 255 ? course.getLastWaypoint() : (Waypoint)Util.get((Iterable)course.getWaypoints(), (int)(nextMark - 1));
                    ArrayList<MarkPassingImpl> newMarkPassings = new ArrayList<MarkPassingImpl>();
                    NavigableSet markPassings = trackedRace.getMarkPassings(competitor);
                    trackedRace.lockForRead((Iterable)markPassings);
                    try {
                        Util.addAll((Iterable)markPassings, newMarkPassings);
                    }
                    finally {
                        trackedRace.unlockAfterRead((Iterable)markPassings);
                    }
                    newMarkPassings.add(new MarkPassingImpl(raceTimePoint, waypointPassed, competitor));
                    trackedRace.updateMarkPassings(competitor, newMarkPassings);
                    this.lastNextMark.put(competitor, nextMark);
                }
            } else {
                logger.warning("Couldn't find hash value " + hashValue + " in either the mark or the competitor map");
            }
        }
    }

    @Override
    public void progress(double progress) {
        DynamicTrackedRace trackedRace = this.trackedRacePerRaceID.get(this.currentRaceID);
        if (trackedRace != null) {
            TrackedRaceStatusEnum newStatus = progress == 1.0 ? TrackedRaceStatusEnum.FINISHED : TrackedRaceStatusEnum.LOADING;
            trackedRace.onStatusChanged((TrackingDataLoader)this, (TrackedRaceStatus)new TrackedRaceStatusImpl(newStatus, progress));
        }
    }

    @FunctionalInterface
    public static interface TrackerConstructor {
        public SwissTimingReplayConnectivityParameters.SwissTimingReplayRaceTracker createTracker(SwissTimingReplayToDomainAdapter var1);
    }
}

