/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.util;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.impl.RaceColumnListenerWithDefaultAction;
import com.sap.sailing.domain.tracking.TrackedRace;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class WaitForTrackedRaceUtil {
    private WaitForTrackedRaceUtil() {
    }

    public static <T extends TrackedRace> T waitForTrackedRace(RaceColumn raceColumn, Fleet fleet, int secondsToWait) {
        CompletableFuture<TrackedRace> future = new CompletableFuture<TrackedRace>();
        WaitForTrackedRaceListener raceColumnListener = new WaitForTrackedRaceListener(fleet, future);
        raceColumn.addRaceColumnListener((RaceColumnListener)raceColumnListener);
        TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
        if (trackedRace != null) {
            raceColumn.removeRaceColumnListener((RaceColumnListener)raceColumnListener);
            return (T)trackedRace;
        }
        try {
            return (T)future.get(secondsToWait, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            raceColumn.removeRaceColumnListener((RaceColumnListener)raceColumnListener);
            return null;
        }
    }

    private static class WaitForTrackedRaceListener
    implements RaceColumnListenerWithDefaultAction {
        private static final long serialVersionUID = 1L;
        private final Fleet fleet;
        private final CompletableFuture<TrackedRace> future;

        public WaitForTrackedRaceListener(Fleet fleet, CompletableFuture<TrackedRace> future) {
            this.fleet = fleet;
            this.future = future;
        }

        public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleetOfLinkedRace, TrackedRace trackedRace) {
            if (this.fleet == fleetOfLinkedRace) {
                raceColumn.removeRaceColumnListener((RaceColumnListener)this);
                this.future.complete(trackedRace);
            }
        }

        public void defaultAction() {
        }

        public boolean isTransient() {
            return true;
        }
    }
}

