/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.util;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.common.dto.EventType;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sse.common.Util;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Iterator;

public interface EventUtil {
    public static Integer getYearOfEvent(EventBase event) {
        return event.getStartDate() == null ? null : Integer.valueOf(Instant.ofEpochMilli(event.getStartDate().asMillis()).atOffset(ZoneOffset.UTC).getYear());
    }

    public static boolean isFakeSeries(EventBase event) {
        Iterator lgIter = event.getLeaderboardGroups().iterator();
        if (!lgIter.hasNext()) {
            return false;
        }
        LeaderboardGroupBase lg = (LeaderboardGroupBase)lgIter.next();
        if (lgIter.hasNext()) {
            return false;
        }
        return lg.hasOverallLeaderboard();
    }

    public static EventType getEventType(Event event) {
        EventType eventType;
        if (EventUtil.isFakeSeries((EventBase)event)) {
            eventType = EventType.SERIES;
        } else {
            Iterator leaderboardGroups = event.getLeaderboardGroups().iterator();
            if (leaderboardGroups.hasNext()) {
                LeaderboardGroup leaderboardGroup = (LeaderboardGroup)leaderboardGroups.next();
                eventType = !leaderboardGroups.hasNext() && Util.size((Iterable)leaderboardGroup.getLeaderboards()) == 1 ? EventType.SINGLE_REGATTA : EventType.MULTI_REGATTA;
            } else {
                eventType = EventType.MULTI_REGATTA;
            }
        }
        return eventType;
    }
}

