/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.statistics;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.domain.statistics.impl.StatisticsImpl;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.statistics.TrackedRaceStatistics;
import com.sap.sailing.server.statistics.TrackedRaceStatisticsCache;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.HashSet;
import java.util.Set;

public class StatisticsCalculator {
    private final TimePoint now = MillisecondsTimePoint.now();
    private Set<Competitor> competitors = new HashSet<Competitor>();
    private Set<Util.Pair<RaceColumn, Fleet>> races = new HashSet<Util.Pair<RaceColumn, Fleet>>();
    private Set<TrackedRace> trackedRaces = new HashSet<TrackedRace>();
    private Set<String> regattas = new HashSet<String>();
    private long numberOfGPSFixes;
    private long numberOfWindFixes;
    private Distance totalDistanceTraveled = Distance.NULL;
    private Util.Triple<Competitor, Speed, TimePoint> maxSpeed = null;
    private final TrackedRaceStatisticsCache trackedRaceStatisticsCache;

    public StatisticsCalculator(TrackedRaceStatisticsCache trackedRaceStatisticsCache) {
        this.trackedRaceStatisticsCache = trackedRaceStatisticsCache;
    }

    private Set<Util.Pair<RaceColumn, Fleet>> calculateRaces(Leaderboard sl) {
        HashSet<Util.Pair<RaceColumn, Fleet>> result = new HashSet<Util.Pair<RaceColumn, Fleet>>();
        for (RaceColumn column : sl.getRaceColumns()) {
            if (column.isCarryForward()) continue;
            column.getFleets().forEach(fleet -> {
                boolean bl = result.add(new Util.Pair((Object)column, fleet));
            });
        }
        return result;
    }

    public void addLeaderboard(Leaderboard leaderboard) {
        if (this.regattas.add(leaderboard.getName())) {
            this.races.addAll(this.calculateRaces(leaderboard));
            Util.addAll((Iterable)leaderboard.getCompetitors(), this.competitors);
            for (RaceColumn column : leaderboard.getRaceColumns()) {
                for (Fleet fleet : column.getFleets()) {
                    TimePoint startOfRace;
                    TrackedRace trackedRace = column.getTrackedRace(fleet);
                    if (trackedRace == null || this.trackedRaces.contains(trackedRace) || !trackedRace.hasGPSData() || (startOfRace = trackedRace.getStartOfRace()) == null || !startOfRace.before(this.now)) continue;
                    this.trackedRaces.add(trackedRace);
                    this.doForTrackedRace(trackedRace);
                }
            }
        }
    }

    private void doForTrackedRace(TrackedRace trackedRace) {
        TrackedRaceStatistics trackedRaceStatistics;
        if (this.trackedRaceStatisticsCache != null && (trackedRaceStatistics = this.trackedRaceStatisticsCache.getStatistics(trackedRace)) != null) {
            this.numberOfGPSFixes += trackedRaceStatistics.getNumberOfGPSFixes();
            this.numberOfWindFixes += trackedRaceStatistics.getNumberOfWindFixes();
            this.totalDistanceTraveled = this.totalDistanceTraveled.add(trackedRaceStatistics.getDistanceTraveled());
            Util.Triple<Competitor, Speed, TimePoint> maxSpeedForRace = trackedRaceStatistics.getMaxSpeed();
            if (maxSpeedForRace != null && (this.maxSpeed == null || ((Speed)maxSpeedForRace.getB()).compareTo((Object)((Speed)this.maxSpeed.getB())) > 0) && ((Speed)maxSpeedForRace.getB()).compareTo((Object)GPSFixTrack.DEFAULT_MAX_SPEED_FOR_SMOOTHING) <= 0) {
                this.maxSpeed = maxSpeedForRace;
            }
        }
    }

    public int getNumberOfRaces() {
        return this.races.size();
    }

    public int getNumberOfTrackedRaces() {
        return this.trackedRaces.size();
    }

    public int getNumberOfRegattas() {
        return this.regattas.size();
    }

    public long getNumberOfGPSFixes() {
        return this.numberOfGPSFixes;
    }

    public long getNumberOfWindFixes() {
        return this.numberOfWindFixes;
    }

    public Distance getTotalDistanceTraveled() {
        return this.totalDistanceTraveled;
    }

    public Util.Triple<Competitor, Speed, TimePoint> getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getNumberOfCompetitors() {
        return this.competitors.size();
    }

    public Statistics getStatistics() {
        return new StatisticsImpl(this.getNumberOfCompetitors(), this.getNumberOfRegattas(), this.getNumberOfRaces(), this.getNumberOfTrackedRaces(), this.getNumberOfGPSFixes(), this.getNumberOfWindFixes(), this.getTotalDistanceTraveled(), this.getMaxSpeed());
    }
}

