/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.LeaderboardSearchResult;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.impl.LeaderboardSearchResultImpl;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.domain.common.tagging.RaceLogNotFoundException;
import com.sap.sailing.domain.common.tagging.ServiceNotFoundException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.server.impl.LeaderboardSearchResultRanker;
import com.sap.sailing.server.interfaces.KeywordQueryWithOptionalEventQualification;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.TaggingService;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.AbstractListFilter;
import com.sap.sse.common.search.Hit;
import com.sap.sse.common.search.Query;
import com.sap.sse.common.search.Result;
import com.sap.sse.common.search.ResultImpl;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class RegattaByKeywordSearchService {
    private static final Logger logger = Logger.getLogger(RegattaByKeywordSearchService.class.getName());

    Result<LeaderboardSearchResult> search(RacingEventService racingEventService, KeywordQueryWithOptionalEventQualification query) {
        SecurityService securityService = racingEventService.getSecurityService();
        ResultImpl result = new ResultImpl((Query)query, (Comparator)new LeaderboardSearchResultRanker(racingEventService));
        final HashMap<LeaderboardGroup, Set<Event>> eventsForLeaderboardGroup = new HashMap<LeaderboardGroup, Set<Event>>();
        final HashMap<Leaderboard, Set<LeaderboardGroup>> leaderboardGroupsForLeaderboard = new HashMap<Leaderboard, Set<LeaderboardGroup>>();
        final HashMap<CourseArea, Event> eventForCourseArea = new HashMap<CourseArea, Event>();
        final HashMap stringsForEvent = new HashMap();
        final HashMap stringsForLeaderboardGroup = new HashMap();
        for (Event event : racingEventService.getEventsSelectively(query.isInclude(), query.getEventUUIDs())) {
            if (!securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event)) continue;
            HashSet<String> s4e = new HashSet<String>();
            s4e.add(event.getName());
            s4e.add(event.getVenue().getName());
            stringsForEvent.put(event, s4e);
            for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
                Util.add(eventsForLeaderboardGroup, (Object)leaderboardGroup, (Object)event);
            }
            for (CourseArea courseArea : event.getVenue().getCourseAreas()) {
                eventForCourseArea.put(courseArea, event);
            }
        }
        for (LeaderboardGroup leaderboardGroup : racingEventService.getLeaderboardGroups().values()) {
            if (!securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroup)) continue;
            HashSet<String> s4lg = new HashSet<String>();
            s4lg.add(leaderboardGroup.getName());
            s4lg.add(leaderboardGroup.getDescription());
            stringsForLeaderboardGroup.put(leaderboardGroup, s4lg);
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                Util.add(leaderboardGroupsForLeaderboard, (Object)leaderboard, (Object)leaderboardGroup);
            }
        }
        final TaggingService taggingService = racingEventService.getTaggingService();
        AbstractListFilter<Leaderboard> leaderboardFilter = new AbstractListFilter<Leaderboard>(){

            public Iterable<String> getStrings(Leaderboard leaderboard) {
                ArrayList<String> leaderboardStrings = new ArrayList<String>();
                leaderboardStrings.add(leaderboard.getName());
                leaderboardStrings.add(leaderboard.getDisplayName());
                for (Competitor competitor : leaderboard.getCompetitors()) {
                    String competitorDisplayName;
                    leaderboardStrings.add(competitor.getName());
                    if (competitor.getShortName() != null) {
                        leaderboardStrings.add(competitor.getShortName());
                    }
                    if (competitor.getSearchTag() != null) {
                        leaderboardStrings.add(competitor.getSearchTag());
                    }
                    if (competitor.hasBoat() && ((CompetitorWithBoat)competitor).getBoat().getSailID() != null) {
                        leaderboardStrings.add(((CompetitorWithBoat)competitor).getBoat().getSailID());
                    }
                    if ((competitorDisplayName = leaderboard.getDisplayName(competitor)) == null) continue;
                    leaderboardStrings.add(competitorDisplayName);
                }
                for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                    for (Fleet fleet : raceColumn.getFleets()) {
                        try {
                            for (TagDTO tag : taggingService.getTags(leaderboard, raceColumn, fleet, null, false)) {
                                if (tag.getTag() != null) {
                                    leaderboardStrings.add(tag.getTag());
                                }
                                if (tag.getComment() == null) continue;
                                leaderboardStrings.add(tag.getComment());
                            }
                        }
                        catch (RaceLogNotFoundException | ServiceNotFoundException e2) {
                            logger.log(Level.WARNING, "Problem obtaining tags for leaderboard " + leaderboard.getName() + ", race column " + raceColumn.getName() + " and fleet " + fleet.getName(), e2);
                        }
                    }
                }
                Iterable leaderboardGroupsHostingLeaderboard = (Iterable)leaderboardGroupsForLeaderboard.get(leaderboard);
                if (leaderboardGroupsHostingLeaderboard != null) {
                    for (LeaderboardGroup leaderboardGroup : leaderboardGroupsHostingLeaderboard) {
                        leaderboardStrings.addAll((Collection)stringsForLeaderboardGroup.get(leaderboardGroup));
                        Set eventsForLG = RegattaByKeywordSearchService.this.filterEventsForLeaderboard(leaderboard, leaderboardGroup, (Set)eventsForLeaderboardGroup.get(leaderboardGroup));
                        if (eventsForLG == null) continue;
                        for (Event event : eventsForLG) {
                            leaderboardStrings.addAll((Collection)stringsForEvent.get(event));
                        }
                    }
                }
                Optional<Event> eventByDefaultCourseArea = StreamSupport.stream(leaderboard.getCourseAreas().spliterator(), false).filter(ca -> eventForCourseArea.containsKey(ca)).findFirst().map(ca -> (Event)eventForCourseArea.get(ca));
                eventByDefaultCourseArea.ifPresent(e -> {
                    boolean bl = leaderboardStrings.addAll((Collection)stringsForEvent.get(e));
                });
                return leaderboardStrings;
            }
        };
        Set leaderboardsToConsider = StreamSupport.stream(racingEventService.getAllEvents().spliterator(), false).filter(e -> e.isPublic() && securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)e)).flatMap(e -> StreamSupport.stream(e.getLeaderboardGroups().spliterator(), false).filter(lg -> securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)lg))).flatMap(lg -> StreamSupport.stream(lg.getLeaderboards().spliterator(), false).filter(l -> securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)l))).collect(Collectors.toSet());
        for (Leaderboard matchingLeaderboard : leaderboardFilter.applyFilter(query.getKeywords(), leaderboardsToConsider)) {
            result.addHit((Hit)new LeaderboardSearchResultImpl(matchingLeaderboard, this.getEventsForLeaderboard(matchingLeaderboard, leaderboardGroupsForLeaderboard, eventsForLeaderboardGroup, eventForCourseArea), (Set)leaderboardGroupsForLeaderboard.get(matchingLeaderboard)));
        }
        return result;
    }

    private Set<Event> filterEventsForLeaderboard(Leaderboard leaderboard, LeaderboardGroup leaderboardGroup, Set<Event> events) {
        Set<Event> result;
        if (events != null && leaderboardGroup.hasOverallLeaderboard()) {
            Set<Event> preResult = null;
            for (Event event : events) {
                if (!Util.containsAny((Iterable)event.getVenue().getCourseAreas(), (Iterable)leaderboard.getCourseAreas())) continue;
                preResult = Collections.singleton(event);
                break;
            }
            result = preResult;
        } else {
            result = events;
        }
        return result;
    }

    private Set<Event> getEventsForLeaderboard(Leaderboard matchingLeaderboard, Map<Leaderboard, Set<LeaderboardGroup>> leaderboardGroupsForLeaderboard, Map<LeaderboardGroup, Set<Event>> eventsForLeaderboardGroup, Map<CourseArea, Event> eventForCourseArea) {
        HashSet<Event> result = new HashSet<Event>();
        Set<LeaderboardGroup> lgs = leaderboardGroupsForLeaderboard.get(matchingLeaderboard);
        if (lgs != null) {
            for (LeaderboardGroup lg : lgs) {
                Set<Event> eventsForLG = this.filterEventsForLeaderboard(matchingLeaderboard, lg, eventsForLeaderboardGroup.get(lg));
                if (eventsForLG == null) continue;
                result.addAll(eventsForLG);
            }
        }
        Optional<Event> eventByDefaultCourseArea = StreamSupport.stream(matchingLeaderboard.getCourseAreas().spliterator(), false).filter(ca -> eventForCourseArea.containsKey(ca)).findFirst().map(ca -> (Event)eventForCourseArea.get(ca));
        eventByDefaultCourseArea.ifPresent(e -> {
            boolean bl = result.add((Event)e);
        });
        return result;
    }
}

