/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.LeaderboardMXBean;
import com.sap.sailing.server.RacingEventServiceMXBean;
import com.sap.sailing.server.impl.LeaderboardMXBeanImpl;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class RacingEventServiceMXBeanImpl
implements RacingEventServiceMXBean {
    private final RacingEventService racingEventService;

    protected RacingEventServiceMXBeanImpl(RacingEventService racingEventService) {
        this.racingEventService = racingEventService;
    }

    private RacingEventService getRacingEventService() {
        return this.racingEventService;
    }

    @Override
    public int getNumberOfLeaderboards() {
        return this.getRacingEventService().getLeaderboards().size();
    }

    @Override
    public long getNumberOfTrackedRacesToRestore() {
        return this.getRacingEventService().getNumberOfTrackedRacesToRestore();
    }

    @Override
    public int getNumberOfTrackedRacesRestored() {
        return this.getRacingEventService().getNumberOfTrackedRacesRestored();
    }

    @Override
    public ObjectName[] getLeaderboards() throws MalformedObjectNameException {
        ObjectName[] result = new ObjectName[this.getRacingEventService().getLeaderboards().size()];
        int i = 0;
        for (Map.Entry entry : this.getRacingEventService().getLeaderboards().entrySet()) {
            result[i++] = new LeaderboardMXBeanImpl((Leaderboard)entry.getValue()).getObjectName();
        }
        return result;
    }

    @Override
    public LeaderboardMXBean.ComputationTimeAverage getLeaderboardComputationStatisticsYoung() {
        return this.getLeaderboardComputationStatistics(0);
    }

    @Override
    public LeaderboardMXBean.ComputationTimeAverage getLeaderboardComputationStatisticsMedium() {
        return this.getLeaderboardComputationStatistics(1);
    }

    @Override
    public LeaderboardMXBean.ComputationTimeAverage getLeaderboardComputationStatisticsOld() {
        return this.getLeaderboardComputationStatistics(2);
    }

    private LeaderboardMXBean.ComputationTimeAverage getLeaderboardComputationStatistics(int indexInStatsSortedByAscendingSampleDuration) {
        TreeMap<Duration, Util.Pair> computationDurationSumsInMillisPerSamplingDuration = new TreeMap<Duration, Util.Pair>();
        for (Leaderboard leaderboard : this.getRacingEventService().getLeaderboards().values()) {
            for (Map.Entry leaderboardStats : leaderboard.getComputationTimeStatistics().entrySet()) {
                if (((Util.Pair)leaderboardStats.getValue()).getA() == null) continue;
                long computationTimeForLeaderboardInRangeInMillis = ((Duration)((Util.Pair)leaderboardStats.getValue()).getA()).asMillis() * (long)((Integer)((Util.Pair)leaderboardStats.getValue()).getB()).intValue();
                computationDurationSumsInMillisPerSamplingDuration.compute((Duration)leaderboardStats.getKey(), (key, oldComputationDurationSumAndCount) -> {
                    Util.Pair newValue;
                    if (oldComputationDurationSumAndCount == null) {
                        newValue = new Util.Pair((Object)new AtomicLong(computationTimeForLeaderboardInRangeInMillis), (Object)new AtomicInteger((Integer)((Util.Pair)leaderboardStats.getValue()).getB()));
                    } else {
                        ((AtomicLong)oldComputationDurationSumAndCount.getA()).addAndGet(computationTimeForLeaderboardInRangeInMillis);
                        ((AtomicInteger)oldComputationDurationSumAndCount.getB()).addAndGet((Integer)((Util.Pair)leaderboardStats.getValue()).getB());
                        newValue = oldComputationDurationSumAndCount;
                    }
                    return newValue;
                });
            }
        }
        Map.Entry relevantEntry = (Map.Entry)Util.get(computationDurationSumsInMillisPerSamplingDuration.entrySet(), (int)indexInStatsSortedByAscendingSampleDuration);
        return new LeaderboardMXBeanImpl.ComputationTimeAverageImpl(((Duration)relevantEntry.getKey()).asMillis(), ((AtomicLong)((Util.Pair)relevantEntry.getValue()).getA()).get() / (long)((AtomicInteger)((Util.Pair)relevantEntry.getValue()).getB()).get(), ((AtomicInteger)((Util.Pair)relevantEntry.getValue()).getB()).get());
    }
}

