/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.impl.BoatImpl;
import com.sap.sailing.domain.base.impl.CompetitorWithBoatImpl;
import com.sap.sailing.domain.base.impl.DomainFactoryImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.TransientCompetitorAndBoatStoreImpl;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.PersistenceFactory;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.mongodb.MongoDBService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistentCompetitorAndBoatStore
extends TransientCompetitorAndBoatStoreImpl
implements CompetitorAndBoatStore {
    private static final long serialVersionUID = 9205956018421790908L;
    private transient MongoObjectFactory storeTo;
    private transient DomainObjectFactory loadFrom;
    private static final Logger logger = Logger.getLogger(PersistentCompetitorAndBoatStore.class.getName());

    public PersistentCompetitorAndBoatStore(MongoObjectFactory storeTo, boolean clearCompetitorsAndBoats, TypeBasedServiceFinderFactory serviceFinderFactory, RaceLogAndTrackedRaceResolver raceLogResolver) {
        DomainFactoryImpl baseDomainFactory = new DomainFactoryImpl((CompetitorAndBoatStore)this, raceLogResolver);
        this.loadFrom = PersistenceFactory.INSTANCE.getDomainObjectFactory(MongoDBService.INSTANCE, (DomainFactory)baseDomainFactory, serviceFinderFactory);
        this.storeTo = storeTo;
        this.migrateCompetitorsIfRequired();
        if (clearCompetitorsAndBoats) {
            storeTo.removeAllBoats();
            storeTo.removeAllCompetitors();
        } else {
            Collection allBoats = this.loadFrom.loadAllBoats();
            for (DynamicBoat boat : allBoats) {
                super.addNewBoat(boat, false);
            }
            Collection allCompetitors = this.loadFrom.loadAllCompetitors();
            for (DynamicCompetitor competitor : allCompetitors) {
                super.addNewCompetitor(competitor, false);
            }
        }
    }

    private void migrateCompetitorsIfRequired() {
        Iterable allLegacyCompetitorsWithBoat = this.loadFrom.migrateLegacyCompetitorsIfRequired();
        if (allLegacyCompetitorsWithBoat != null) {
            ArrayList<CompetitorWithBoatImpl> newCompetitors = new ArrayList<CompetitorWithBoatImpl>();
            ArrayList<BoatImpl> newBoats = new ArrayList<BoatImpl>();
            for (CompetitorWithBoat competitorWithBoat : allLegacyCompetitorsWithBoat) {
                Boat containedBoat = competitorWithBoat.getBoat();
                UUID boatUUID = UUID.randomUUID();
                BoatImpl newBoat = new BoatImpl((Serializable)boatUUID, null, containedBoat.getBoatClass(), containedBoat.getSailID());
                newBoats.add(newBoat);
                CompetitorWithBoatImpl newCompetitorWithBoat = new CompetitorWithBoatImpl((Competitor)competitorWithBoat, (DynamicBoat)newBoat);
                newCompetitors.add(newCompetitorWithBoat);
            }
            logger.log(Level.INFO, "Bug2822 DB-Migration: Store migrated competitors and boats.");
            this.storeTo.storeCompetitors(newCompetitors);
            this.storeTo.storeBoats(newBoats);
        }
    }

    DomainObjectFactory getDomainObjectFactory() {
        return this.loadFrom;
    }

    MongoObjectFactory getMongoObjectFactory() {
        return this.storeTo;
    }

    DomainFactory getBaseDomainFactory() {
        return this.loadFrom.getBaseDomainFactory();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.storeTo = PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory();
    }

    public synchronized Competitor migrateToCompetitorWithoutBoat(CompetitorWithBoat competitorWithBoat) {
        assert (competitorWithBoat.hasBoat());
        logger.log(Level.INFO, "Bug2822 DB-Migration: Migrate competitor " + competitorWithBoat.getName() + " with ID " + competitorWithBoat.getId().toString() + " to have a separate boat");
        Competitor migratedCompetitor = super.migrateToCompetitorWithoutBoat(competitorWithBoat);
        this.storeTo.storeCompetitor(migratedCompetitor);
        return migratedCompetitor;
    }

    protected void addNewCompetitor(DynamicCompetitor competitor, boolean storePersistently) {
        if (storePersistently) {
            this.storeTo.storeCompetitor((Competitor)competitor);
        }
        super.addNewCompetitor(competitor, storePersistently);
    }

    public void clearCompetitors() {
        this.storeTo.removeAllCompetitors();
        super.clearCompetitors();
    }

    protected void removeCompetitor(Competitor competitor) {
        this.storeTo.removeCompetitor(competitor);
        super.removeCompetitor(competitor);
    }

    public Competitor updateCompetitor(String idAsString, String newName, String newShortName, Color newRgbDisplayColor, String newEmail, Nationality newNationality, URI newTeamImageUri, URI newFlagImageUri, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, boolean storePersistently) {
        Competitor result = super.updateCompetitor(idAsString, newName, newShortName, newRgbDisplayColor, newEmail, newNationality, newTeamImageUri, newFlagImageUri, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, storePersistently);
        if (storePersistently) {
            this.storeTo.storeCompetitor(result);
        }
        return result;
    }

    public void addNewCompetitors(Iterable<DynamicCompetitor> competitors) {
        this.storeTo.storeCompetitors(competitors);
        super.addNewCompetitors(competitors);
    }

    protected void addNewBoat(DynamicBoat boat, boolean storePersistently) {
        if (storePersistently) {
            this.storeTo.storeBoat((Boat)boat);
        }
        super.addNewBoat(boat, storePersistently);
    }

    public void clearBoats() {
        this.storeTo.removeAllBoats();
        super.clearBoats();
    }

    protected void removeBoat(Boat boat) {
        this.storeTo.removeBoat(boat);
        super.removeBoat(boat);
    }

    public Boat updateBoat(String idAsString, String newName, Color newColor, String newSailId) {
        Boat result = super.updateBoat(idAsString, newName, newColor, newSailId);
        this.storeTo.storeBoat(result);
        return result;
    }

    public void addNewBoats(Iterable<DynamicBoat> boats) {
        this.storeTo.storeBoats(boats);
        super.addNewBoats(boats);
    }
}

