/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.server.Replicator;
import com.sap.sailing.server.operationaltransformation.AddWaypoint;
import com.sap.sailing.server.operationaltransformation.RemoveWaypoint;
import com.sap.sse.replication.OperationWithResult;

public class CourseChangeReplicator
implements CourseListener {
    private final RegattaAndRaceIdentifier raceIdentifier;
    private final Replicator replicator;
    private final Course course;

    public CourseChangeReplicator(Replicator replicator, Regatta regatta, RaceDefinition raceDefinition) {
        this.raceIdentifier = new RegattaNameAndRaceName(regatta.getName(), raceDefinition.getName());
        this.course = raceDefinition.getCourse();
        this.replicator = replicator;
    }

    public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
        AddWaypoint op = new AddWaypoint(this.raceIdentifier, zeroBasedIndex, waypointThatGotAdded, this.course.getWaypoints());
        this.replicator.replicate((OperationWithResult)op);
    }

    public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
        RemoveWaypoint op = new RemoveWaypoint(this.raceIdentifier, zeroBasedIndex, waypointThatGotRemoved);
        this.replicator.replicate((OperationWithResult)op);
    }
}

