/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.hierarchy;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.hierarchy.EventHierarchyVisitor;
import com.sap.sailing.server.hierarchy.LeaderboardGroupHierarchyVisitor;
import com.sap.sailing.server.hierarchy.LeaderboardHierarchyVisitor;
import com.sap.sailing.server.hierarchy.SailingHierarchyWalker;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.ShiroWildcardPermissionFromParts;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.UserGroupManagementException;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.PermissionAndRoleAssociation;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.impl.UserGroupImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;

public class SailingHierarchyOwnershipUpdater {
    private final RacingEventService service;
    private final SecurityService securityService;
    private final GroupOwnerUpdateStrategy updateStrategy;
    private final boolean updateCompetitors;
    private final boolean updateBoats;
    private final Set<QualifiedObjectIdentifier> objectsToUpdateOwnershipsFor;

    public static SailingHierarchyOwnershipUpdater createOwnershipUpdater(boolean createNewGroup, UUID existingGroupIdOrNull, String newGroupName, boolean migrateCompetitors, boolean migrateBoats, boolean copyMembersAndRoles, RacingEventService service) {
        SecurityService securityService = service.getSecurityService();
        UserGroup sourceGroup = securityService.getUserGroup(existingGroupIdOrNull);
        GroupOwnerUpdateStrategy updateStrategy = !createNewGroup ? SailingHierarchyOwnershipUpdater.createExitingGroupModifyingUpdate(sourceGroup) : (copyMembersAndRoles ? SailingHierarchyOwnershipUpdater.createNewGroupUsingUpdate(newGroupName, securityService, sourceGroup, service) : SailingHierarchyOwnershipUpdater.createNewGroupWithoutCopying(newGroupName, securityService));
        return new SailingHierarchyOwnershipUpdater(service, securityService, updateStrategy, migrateCompetitors, migrateBoats);
    }

    private SailingHierarchyOwnershipUpdater(RacingEventService service, SecurityService securityService, GroupOwnerUpdateStrategy updateStrategy, boolean updateCompetitors, boolean updateBoats) {
        this.service = service;
        this.securityService = securityService;
        this.updateStrategy = updateStrategy;
        this.updateCompetitors = updateCompetitors;
        this.updateBoats = updateBoats;
        this.objectsToUpdateOwnershipsFor = new HashSet<QualifiedObjectIdentifier>();
    }

    public void updateGroupOwnershipForEventHierarchy(Event event) {
        this.updateGroupOwnershipForEventHierarchyInternal(event);
        this.commitChanges();
    }

    private void updateGroupOwnershipForEventHierarchyInternal(final Event event) {
        this.updateGroupOwner(event.getIdentifier());
        SailingHierarchyWalker.walkFromEvent(event, false, new EventHierarchyVisitor(){

            @Override
            public void visit(Leaderboard leaderboard, Set<LeaderboardGroup> leaderboardGroups) {
                SailingHierarchyOwnershipUpdater.this.updateGroupOwnershipForLeaderboardHierarchyInternal(leaderboard);
            }

            @Override
            public void visit(LeaderboardGroup leaderboardGroup) {
                SailingHierarchyOwnershipUpdater.this.updateGroupOwnershipForLeaderboardGroupHierarchyInternal(leaderboardGroup, event);
            }
        });
    }

    public void updateGroupOwnershipForLeaderboardGroupHierarchy(LeaderboardGroup leaderboardGroup) {
        this.updateGroupOwnershipForLeaderboardGroupHierarchyInternal(leaderboardGroup, null);
        this.commitChanges();
    }

    private void updateGroupOwnershipForLeaderboardGroupHierarchyInternal(LeaderboardGroup leaderboardGroup, final Event eventToExclude) {
        this.updateGroupOwner(leaderboardGroup.getIdentifier());
        SailingHierarchyWalker.walkFromLeaderboardGroup(this.service, leaderboardGroup, true, new LeaderboardGroupHierarchyVisitor(){

            @Override
            public void visit(Leaderboard leaderboard) {
                SailingHierarchyOwnershipUpdater.this.updateGroupOwnershipForLeaderboardHierarchyInternal(leaderboard);
            }

            @Override
            public void visit(Event event) {
                if (event != eventToExclude) {
                    SailingHierarchyOwnershipUpdater.this.updateGroupOwnershipForEventHierarchyInternal(event);
                }
            }
        });
    }

    public void updateGroupOwnershipForLeaderboardHierarchy(Leaderboard leaderboard) {
        this.updateGroupOwnershipForLeaderboardHierarchyInternal(leaderboard);
        this.commitChanges();
    }

    private void updateGroupOwnershipForLeaderboardHierarchyInternal(Leaderboard leaderboard) {
        this.updateGroupOwner(leaderboard.getIdentifier());
        if (leaderboard instanceof RegattaLeaderboard) {
            RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
            this.updateGroupOwner(regattaLeaderboard.getRegatta().getIdentifier());
        }
        SailingHierarchyWalker.walkFromLeaderboard(leaderboard, new LeaderboardHierarchyVisitor(){

            @Override
            public void visit(TrackedRace race) {
                SailingHierarchyOwnershipUpdater.this.updateGroupOwner(race.getIdentifier());
            }

            @Override
            public void visit(Boat boat) {
                if (SailingHierarchyOwnershipUpdater.this.updateBoats) {
                    SailingHierarchyOwnershipUpdater.this.updateGroupOwner(boat.getIdentifier());
                }
            }

            @Override
            public void visit(Competitor competitor) {
                if (SailingHierarchyOwnershipUpdater.this.updateCompetitors) {
                    SailingHierarchyOwnershipUpdater.this.updateGroupOwner(competitor.getIdentifier());
                }
            }
        });
    }

    private void updateGroupOwner(QualifiedObjectIdentifier id) {
        OwnershipAnnotation ownership = this.securityService.getOwnership(id);
        if (this.updateStrategy.needsUpdate(id, ownership)) {
            WildcardPermission permission = id.getPermission((HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP);
            SecurityUtils.getSubject().checkPermission((Permission)new ShiroWildcardPermissionFromParts(permission));
            this.objectsToUpdateOwnershipsFor.add(id);
        }
    }

    private void commitChanges() {
        UserGroup groupOwnerToSet = this.updateStrategy.getNewGroupOwner();
        Iterator<QualifiedObjectIdentifier> iterator = this.objectsToUpdateOwnershipsFor.iterator();
        while (iterator.hasNext()) {
            QualifiedObjectIdentifier id;
            OwnershipAnnotation ownership = this.securityService.getOwnership(id = iterator.next());
            this.securityService.setOwnership(id, ownership == null ? null : (User)((Ownership)ownership.getAnnotation()).getUserOwner(), groupOwnerToSet);
        }
    }

    private static GroupOwnerUpdateStrategy createExitingGroupModifyingUpdate(final UserGroup sourceGroup) {
        if (sourceGroup == null) {
            throw new RuntimeException("User group does not exist");
        }
        GroupOwnerUpdateStrategy updateStrategy = new GroupOwnerUpdateStrategy(){

            @Override
            public boolean needsUpdate(QualifiedObjectIdentifier identifier, OwnershipAnnotation currentOwnership) {
                return currentOwnership == null || !sourceGroup.equals(((Ownership)currentOwnership.getAnnotation()).getTenantOwner());
            }

            @Override
            public UserGroup getNewGroupOwner() {
                return sourceGroup;
            }
        };
        return updateStrategy;
    }

    private static GroupOwnerUpdateStrategy createNewGroupWithoutCopying(final String newGroupName, final SecurityService securityService) {
        if (newGroupName == null || newGroupName.isEmpty()) {
            throw new RuntimeException("No name for new Group given");
        }
        GroupOwnerUpdateStrategy updateStrategy = new GroupOwnerUpdateStrategy(){
            private UserGroup groupOwnerToSet;

            @Override
            public boolean needsUpdate(QualifiedObjectIdentifier identifier, OwnershipAnnotation currentOwnership) {
                return true;
            }

            @Override
            public UserGroup getNewGroupOwner() {
                if (this.groupOwnerToSet == null) {
                    try {
                        this.groupOwnerToSet = securityService.createUserGroup(UUID.randomUUID(), newGroupName);
                        QualifiedObjectIdentifier identifier = this.groupOwnerToSet.getIdentifier();
                        securityService.setDefaultOwnership(identifier, identifier.toString());
                        securityService.addUserToUserGroup(this.groupOwnerToSet, securityService.getCurrentUser());
                    }
                    catch (UserGroupManagementException e) {
                        throw new RuntimeException("Could not create user group");
                    }
                }
                return this.groupOwnerToSet;
            }
        };
        return updateStrategy;
    }

    private static GroupOwnerUpdateStrategy createNewGroupUsingUpdate(final String newGroupName, final SecurityService securityService, final UserGroup sourceGroup, final RacingEventService service) {
        if (newGroupName == null || newGroupName.isEmpty()) {
            throw new RuntimeException("No name for new Group given");
        }
        GroupOwnerUpdateStrategy updateStrategy = new GroupOwnerUpdateStrategy(){
            private UserGroup groupOwnerToSet;

            @Override
            public boolean needsUpdate(QualifiedObjectIdentifier identifier, OwnershipAnnotation currentOwnership) {
                return true;
            }

            @Override
            public UserGroup getNewGroupOwner() {
                if (this.groupOwnerToSet == null) {
                    try {
                        if (sourceGroup != null) {
                            this.groupOwnerToSet = SailingHierarchyOwnershipUpdater.copyUserGroup(sourceGroup, newGroupName, securityService, service);
                        } else {
                            this.groupOwnerToSet = securityService.createUserGroup(UUID.randomUUID(), newGroupName);
                            QualifiedObjectIdentifier identifier = this.groupOwnerToSet.getIdentifier();
                            securityService.setDefaultOwnership(identifier, identifier.toString());
                        }
                    }
                    catch (UserGroupManagementException e) {
                        throw new RuntimeException("Could not create user group");
                    }
                }
                return this.groupOwnerToSet;
            }
        };
        return updateStrategy;
    }

    private static UserGroup copyUserGroup(UserGroup userGroupToCopy, String name, final SecurityService securitySerice, RacingEventService service) throws UserGroupManagementException {
        UUID newGroupId = UUID.randomUUID();
        return (UserGroup)securitySerice.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredSecurityTypes.USER_GROUP, UserGroupImpl.getTypeRelativeObjectIdentifier((UUID)newGroupId), name, () -> {
            UserGroup createdUserGroup = securitySerice.createUserGroup(newGroupId, name);
            securitySerice.copyUsersAndRoleAssociations(userGroupToCopy, createdUserGroup, new SecurityService.RoleCopyListener(){

                public void onRoleCopy(User user, Role existingRole, Role copyRole) {
                    TypeRelativeObjectIdentifier existingAssociationTypeIdentifier = PermissionAndRoleAssociation.get((Role)existingRole, (User)user);
                    TypeRelativeObjectIdentifier copyAssociationTypeIdentifier = PermissionAndRoleAssociation.get((Role)copyRole, (User)user);
                    QualifiedObjectIdentifier existingQualifiedTypeIdentifier = SecuredSecurityTypes.ROLE_ASSOCIATION.getQualifiedObjectIdentifier(existingAssociationTypeIdentifier);
                    QualifiedObjectIdentifier copyQualifiedTypeIdentifier = SecuredSecurityTypes.ROLE_ASSOCIATION.getQualifiedObjectIdentifier(copyAssociationTypeIdentifier);
                    OwnershipAnnotation existingOwner = securitySerice.getOwnership(existingQualifiedTypeIdentifier);
                    securitySerice.setOwnership(copyQualifiedTypeIdentifier, (User)((Ownership)existingOwner.getAnnotation()).getUserOwner(), (UserGroup)((Ownership)existingOwner.getAnnotation()).getTenantOwner(), existingOwner.getDisplayNameOfAnnotatedObject());
                }
            });
            return createdUserGroup;
        });
    }

    public static interface GroupOwnerUpdateStrategy {
        public boolean needsUpdate(QualifiedObjectIdentifier var1, OwnershipAnnotation var2);

        public UserGroup getNewGroupOwner();
    }
}

