/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.anniversary.checker;

import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.server.interfaces.AnniversaryRaceDeterminator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class QuarterChecker
implements AnniversaryRaceDeterminator.AnniversaryChecker {
    private static final int[] ANNIVERSARIES = new int[]{10000, 25000, 50000, 75000};
    private final CopyOnWriteArrayList<Integer> pastAnniversaries = new CopyOnWriteArrayList();
    private int nextAnniversary;

    public void update(int raceCount) {
        if (raceCount < 0) {
            throw new IllegalStateException("Negative Raceamount " + raceCount);
        }
        this.pastAnniversaries.clear();
        int factor = 1;
        while (true) {
            int[] nArray = ANNIVERSARIES;
            int n = ANNIVERSARIES.length;
            int n2 = 0;
            while (n2 < n) {
                int anniversary = nArray[n2];
                int anniversaryToCheck = anniversary * factor;
                if (anniversaryToCheck < 0) {
                    throw new IllegalStateException("overflow safeguard " + anniversary + " " + factor + " " + anniversaryToCheck);
                }
                if (anniversaryToCheck > raceCount) {
                    this.nextAnniversary = anniversaryToCheck;
                    return;
                }
                if (raceCount >= anniversaryToCheck) {
                    this.pastAnniversaries.add(anniversaryToCheck);
                }
                ++n2;
            }
            factor *= 10;
        }
    }

    public List<Integer> getAnniversaries() {
        return this.pastAnniversaries;
    }

    public Integer getNextAnniversary() {
        return this.nextAnniversary;
    }

    public AnniversaryType getType() {
        return AnniversaryType.QUARTER;
    }
}

