/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.windfield.impl;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.simulator.Grid;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.windfield.WindControlParameters;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sailing.simulator.windfield.impl.WindFieldGeneratorBlastImpl;
import com.sap.sailing.simulator.windfield.impl.WindFieldGeneratorImpl;
import com.sap.sailing.simulator.windfield.impl.WindFieldGeneratorOscillationImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;

public class WindFieldGeneratorCombined
extends WindFieldGeneratorImpl
implements WindFieldGenerator {
    private static final long serialVersionUID = 2283750025355590301L;
    private WindFieldGeneratorBlastImpl blastGen;
    private WindFieldGeneratorOscillationImpl oscillationGen;

    public WindFieldGeneratorCombined(Grid boundary, WindControlParameters windParameters) {
        super(boundary, windParameters);
        this.blastGen = new WindFieldGeneratorBlastImpl(boundary, windParameters);
        this.oscillationGen = new WindFieldGeneratorOscillationImpl(boundary, windParameters);
    }

    @Override
    public void setBoundary(Grid boundary) {
        super.setBoundary(boundary);
        this.blastGen.setBoundary(boundary);
        this.oscillationGen.setBoundary(boundary);
    }

    @Override
    public void generate(TimePoint start, TimePoint end, Duration step) {
        super.generate(start, end, step);
        this.blastGen.setPositionGrid(this.positions);
        this.blastGen.generate(start, end, step, 0.0, 0.0);
        this.oscillationGen.setPositionGrid(this.positions);
        this.oscillationGen.generate(start, end, step);
    }

    @Override
    public Wind getWind(TimedPosition timedPosition) {
        Wind blastWind = this.blastGen.getWind(timedPosition);
        Wind oscillationWind = this.oscillationGen.getWind(timedPosition);
        KnotSpeedWithBearingImpl speedWithBearing = new KnotSpeedWithBearingImpl(blastWind.getKnots() + oscillationWind.getKnots(), blastWind.getBearing().add(oscillationWind.getBearing()));
        return new WindImpl(timedPosition.getPosition(), timedPosition.getTimePoint(), (SpeedWithBearing)speedWithBearing);
    }
}

