/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.ConfigurationManager;
import com.sap.sailing.simulator.impl.PathCandidate;
import com.sap.sailing.simulator.impl.PathGeneratorOpportunistEuclidian;
import com.sap.sailing.simulator.impl.PathGeneratorTreeGrow;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sailing.simulator.windfield.impl.WindFieldGeneratorMeasured;
import com.sap.sse.common.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.FrameworkUtil;

public class SimulatorUtils {
    private static final Logger LOGGER = Logger.getLogger("com.sap.sailing.simulator");
    public static final String LEGSNAMES_DAT = "legsNames.dat";
    public static final String RACECOURSE_DAT = "racecourse.dat";
    public static final String COMPETITORSNAMES_DAT = "competitorsNames.dat";
    public static final String[] PATH_NAMES = new String[]{"1#Omniscient", "2#Opportunistic", "3#1-Turner Left", "4#1-Turner Right", "6#GPS Poly", "7#GPS Track"};
    public static String pathPrefix = null;

    public static String getPathPrefix() {
        String bundleName = null;
        try {
            bundleName = FrameworkUtil.getBundle(Class.forName("com.sap.sailing.simulator.impl.SimulatorUtils")).getSymbolicName();
        }
        catch (ClassNotFoundException e) {
            System.err.println("[ERROR][SerializationUtils][getPathPrefix][ClassNotFoundException]  " + e.getMessage());
            LOGGER.severe("[ERROR][SerializationUtils][getPathPrefix][ClassNotFoundException]  " + e.getMessage());
            return null;
        }
        String bundlesProperty = System.getProperty("osgi.bundles");
        int bundleNameStart = bundlesProperty.indexOf(bundleName);
        int bundleNameEnd = bundleNameStart + bundleName.length();
        String prependedBundlePath = bundlesProperty.substring(0, bundleNameEnd);
        int prefixPos = prependedBundlePath.lastIndexOf("reference:file:");
        if (prefixPos >= 0) {
            prependedBundlePath = prependedBundlePath.substring(prefixPos + 15, prependedBundlePath.length());
        }
        return prependedBundlePath;
    }

    public static Util.Pair<Map<String, Path>, Path> readLegPathsFromResources(int selectedRaceIndex, int selectedCompetitorIndex, int selectedLegIndex) {
        HashMap<String, Path> paths = new HashMap<String, Path>();
        Path path = null;
        String filePath = "";
        String fileName = "";
        String[] stringArray = PATH_NAMES;
        int n = PATH_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String pathName = stringArray[n2];
            fileName = SimulatorUtils.getFileName(selectedRaceIndex, selectedCompetitorIndex, selectedLegIndex, pathName);
            filePath = fileName;
            path = (Path)SimulatorUtils.readObjectFromResources(filePath);
            if (path == null) {
                System.err.println("[ERROR][SerializationUtils][readPathsFromResources] Cannot de-serialize path from" + pathName);
                LOGGER.severe("[ERROR][SerializationUtils][readPathsFromResources] Cannot de-serialize path from" + pathName);
            } else {
                paths.put(pathName, path);
            }
            ++n2;
        }
        Path raceCourse = (Path)SimulatorUtils.readObjectFromResources("resources/" + SimulatorUtils.getFileName(selectedRaceIndex, selectedCompetitorIndex, selectedLegIndex, "racecourse"));
        return new Util.Pair(paths, (Object)raceCourse);
    }

    public static Util.Pair<Map<String, Path>, Path> readPathsFromResources() {
        HashMap<String, Path> paths = new HashMap<String, Path>();
        Path path = null;
        String filePath = "";
        String[] stringArray = PATH_NAMES;
        int n = PATH_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String pathName = stringArray[n2];
            filePath = "resources/" + pathName + ".dat";
            path = (Path)SimulatorUtils.readObjectFromResources(filePath);
            if (path == null) {
                System.err.println("[ERROR][SerializationUtils][readPathsFromResources] Cannot de-serialize path from" + pathName);
                LOGGER.severe("[ERROR][SerializationUtils][readPathsFromResources] Cannot de-serialize path from" + pathName);
            } else {
                paths.put(pathName, path);
            }
            ++n2;
        }
        Path raceCourse = (Path)SimulatorUtils.readObjectFromResources("resources/racecourse.dat");
        return new Util.Pair(paths, (Object)raceCourse);
    }

    public static Object readObjectExternalFile(String fileName) {
        Object result = null;
        try {
            FileInputStream file = new FileInputStream(fileName);
            BufferedInputStream buffer = new BufferedInputStream(file);
            ObjectInputStream input = new ObjectInputStream(buffer);
            try {
                result = input.readObject();
            }
            finally {
                input.close();
                ((InputStream)buffer).close();
                ((InputStream)file).close();
            }
        }
        catch (ClassNotFoundException ex) {
            System.err.println("[ERROR][SerializationUtils][readFromExternalFile][ClassNotFoundException] " + ex.getMessage());
            LOGGER.severe("[ERROR][SerializationUtils][readFromExternalFile][ClassNotFoundException] " + ex.getMessage());
            result = null;
        }
        catch (IOException ex) {
            System.err.println("[ERROR][SerializationUtils][readFromExternalFile][IOException]  " + ex.getMessage());
            LOGGER.severe("[ERROR][SerializationUtils][readFromExternalFile][IOException]  " + ex.getMessage());
            result = null;
        }
        return result;
    }

    public static Object readObjectFromResources(String fileName) {
        Object result = null;
        try {
            ClassLoader classLoader = Class.forName("com.sap.sailing.simulator.impl.SimulatorUtils").getClassLoader();
            InputStream file = classLoader.getResourceAsStream(fileName);
            BufferedInputStream buffer = new BufferedInputStream(file);
            ObjectInputStream input = new ObjectInputStream(buffer);
            try {
                result = input.readObject();
            }
            finally {
                input.close();
                ((InputStream)buffer).close();
                file.close();
            }
        }
        catch (ClassNotFoundException ex) {
            System.err.println("[ERROR][SerializationUtils][readFromResourcesFile][ClassNotFoundException] " + ex.getMessage());
            LOGGER.severe("[ERROR][SerializationUtils][readFromResourcesFile][ClassNotFoundException] " + ex.getMessage());
            result = null;
        }
        catch (IOException ex) {
            System.err.println("[ERROR][SerializationUtils][readFromResourcesFile][IOException]  " + ex.getMessage());
            LOGGER.severe("[ERROR][SerializationUtils][readFromResourcesFile][IOException]  " + ex.getMessage());
            result = null;
        }
        return result;
    }

    public static boolean saveStringListToFiles(List<String> legsNames, String fileName) {
        if (legsNames == null) {
            return false;
        }
        if (legsNames.isEmpty()) {
            return true;
        }
        if (pathPrefix == null) {
            pathPrefix = SimulatorUtils.getPathPrefix();
        }
        String filePath = String.valueOf(pathPrefix) + "\\resources\\" + fileName;
        boolean result = true;
        try {
            FileOutputStream file = new FileOutputStream(filePath);
            BufferedOutputStream buffer = new BufferedOutputStream(file);
            ObjectOutputStream output = new ObjectOutputStream(buffer);
            try {
                output.writeObject(legsNames);
            }
            finally {
                output.close();
                ((OutputStream)buffer).close();
                ((OutputStream)file).close();
            }
        }
        catch (IOException ex) {
            System.err.println("[ERROR][SerializationUtils][saveLegsNamesToFiles][IOException]  " + ex.getMessage());
            LOGGER.severe("[ERROR][SerializationUtils][saveLegsNamesToFiles][IOException]  " + ex.getMessage());
            result = false;
        }
        return result;
    }

    public static String getRaceID(String raceURL) {
        String result;
        block5: {
            String[] parts;
            block4: {
                String[] parts2;
                result = null;
                if (!raceURL.contains("&race=")) break block4;
                String[] stringArray = parts2 = raceURL.split("&");
                int n = parts2.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (part.startsWith("race=")) {
                        result = part.replace("race=", "");
                    }
                    ++n2;
                }
                break block5;
            }
            if (!raceURL.contains("?race=")) break block5;
            String[] stringArray = parts = raceURL.split("?");
            int n = parts.length;
            int n3 = 0;
            while (n3 < n) {
                String part = stringArray[n3];
                if (part.startsWith("race=")) {
                    result = part.replace("race=", "");
                }
                ++n3;
            }
        }
        return result;
    }

    public static String getFileName(int selectedRaceIndex, int selectedCompetitorIndex, int selectedLegIndex, String pathName) {
        return String.valueOf(SimulatorUtils.getRaceID(ConfigurationManager.INSTANCE.getRaceURL(selectedRaceIndex))) + "_" + selectedCompetitorIndex + "_" + selectedLegIndex + "_" + pathName + ".dat";
    }

    public static Map<String, Path> getSimulationPaths(SimulationParameters parameters, Path gpsPath, Path raceCourse) {
        WindFieldGenerator wf = parameters.getWindField();
        Position[] gridArea = wf.getGridAreaGps();
        if (parameters.getMode() == 'm') {
            ((WindFieldGeneratorMeasured)wf).setGPSWind(gpsPath);
            gridArea = new Position[]{raceCourse.getPathPoints().get(0).getPosition(), raceCourse.getPathPoints().get(1).getPosition()};
            ArrayList<Position> course = new ArrayList<Position>();
            course.add(gridArea[0]);
            course.add(gridArea[1]);
            parameters.setCourse(course);
        }
        HashMap<String, Path> paths = new HashMap<String, Path>();
        PathGeneratorTreeGrow genTreeGrow = new PathGeneratorTreeGrow(parameters);
        genTreeGrow.setEvaluationParameters("L", 1, null);
        Path leftPath = genTreeGrow.getPath();
        PathCandidate leftBestCand = genTreeGrow.getBestCand();
        int left1TurnMiddle = 1000;
        if (leftBestCand != null) {
            left1TurnMiddle = leftBestCand.getIndexOfTurnLR();
        }
        genTreeGrow.setEvaluationParameters("R", 1, null);
        Path rightPath = genTreeGrow.getPath();
        PathCandidate rightBestCand = genTreeGrow.getBestCand();
        int right1TurnMiddle = 1000;
        if (rightBestCand != null) {
            right1TurnMiddle = rightBestCand.getIndexOfTurnRL();
        }
        genTreeGrow.setEvaluationParameters(null, 0, null);
        Path optPath = genTreeGrow.getPath();
        PathGeneratorOpportunistEuclidian genOpportunistic = new PathGeneratorOpportunistEuclidian(parameters);
        genOpportunistic.setEvaluationParameters(left1TurnMiddle, right1TurnMiddle, true);
        Path oppPathL = genOpportunistic.getPath();
        genOpportunistic.setEvaluationParameters(left1TurnMiddle, right1TurnMiddle, false);
        Path oppPathR = genOpportunistic.getPath();
        Path oppPath = null;
        TimedPositionWithSpeed lastPathLPoint = oppPathL.getPathPoints().get(oppPathL.getPathPoints().size() - 1);
        TimedPositionWithSpeed lastPathRPoint = oppPathR.getPathPoints().get(oppPathR.getPathPoints().size() - 1);
        oppPath = lastPathLPoint.getTimePoint().asMillis() <= lastPathRPoint.getTimePoint().asMillis() ? oppPathL : oppPathR;
        paths.put("4#1-Turner Right", rightPath);
        paths.put("3#1-Turner Left", leftPath);
        paths.put("2#Opportunistic", oppPath);
        paths.put("1#Omniscient", optPath);
        return paths;
    }
}

