/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindField;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class PathImpl
implements Path,
Serializable {
    private static final long serialVersionUID = -6354445155884413937L;
    private List<TimedPositionWithSpeed> pathPoints;
    private WindField windField;
    private int turnCount;
    private long maxTurnTime;
    private boolean algorithmTimedOut;
    private boolean mixedLeg = false;
    private static final double TRESHOLD_DEGREES = 25.0;
    private static final double THRESHOLD_DISTANCE_METERS = 15.0;

    public PathImpl(List<TimedPositionWithSpeed> pointsList, WindField wf, boolean algorithmTimedOut) {
        this.pathPoints = pointsList;
        this.windField = wf;
        this.turnCount = 0;
        this.maxTurnTime = 0L;
        this.algorithmTimedOut = algorithmTimedOut;
    }

    public PathImpl(List<TimedPositionWithSpeed> pointsList, WindField wf, boolean algorithmTimedOut, boolean mixedLeg) {
        this.pathPoints = pointsList;
        this.windField = wf;
        this.turnCount = 0;
        this.maxTurnTime = 0L;
        this.algorithmTimedOut = algorithmTimedOut;
        this.mixedLeg = mixedLeg;
    }

    public PathImpl(List<TimedPositionWithSpeed> pointsList, WindField wf, long maxTurnTime, boolean algorithmTimedOut, boolean mixedLeg) {
        this.pathPoints = pointsList;
        this.windField = wf;
        this.turnCount = 0;
        this.maxTurnTime = maxTurnTime;
        this.algorithmTimedOut = algorithmTimedOut;
        this.mixedLeg = mixedLeg;
    }

    public PathImpl(List<TimedPositionWithSpeed> pointsList, WindField wf, int turnCount, boolean algorithmTimedOut) {
        this.pathPoints = pointsList;
        this.windField = wf;
        this.turnCount = turnCount;
        this.maxTurnTime = 0L;
        this.algorithmTimedOut = algorithmTimedOut;
    }

    @Override
    public boolean getAlgorithmTimedOut() {
        return this.algorithmTimedOut;
    }

    @Override
    public boolean getMixedLeg() {
        return this.mixedLeg;
    }

    @Override
    public List<TimedPositionWithSpeed> getPathPoints() {
        return this.pathPoints;
    }

    @Override
    public int getTurnCount() {
        return this.turnCount;
    }

    @Override
    public void setPathPoints(List<TimedPositionWithSpeed> pointsList) {
        this.pathPoints = pointsList;
    }

    @Override
    public long getMaxTurnTime() {
        return this.maxTurnTime;
    }

    @Override
    public void setMaxTurnTime(long maxTurnTime) {
        this.maxTurnTime = maxTurnTime;
    }

    @Override
    public Path getEvenTimedPath(long timestep) {
        return new PathImpl(this.getEvenTimedPathAsList(timestep), this.windField, this.algorithmTimedOut, this.mixedLeg);
    }

    private List<TimedPositionWithSpeed> getEvenTimedPathAsList(long timeStep) {
        TimePoint startTime = this.pathPoints.get(0).getTimePoint();
        TimePoint endTime = this.pathPoints.get(this.pathPoints.size() - 1).getTimePoint();
        ArrayList<TimedPositionWithSpeed> path = new ArrayList<TimedPositionWithSpeed>();
        TimedPositionWithSpeed startPoint = this.pathPoints.get(0);
        Wind startWind = null;
        if (this.windField != null) {
            startWind = this.windField.getWind(new TimedPositionImpl(startPoint.getTimePoint(), startPoint.getPosition()));
            startPoint = new TimedPositionWithSpeedImpl(startPoint.getTimePoint(), startPoint.getPosition(), (SpeedWithBearing)startWind);
        }
        path.add(startPoint);
        MillisecondsTimePoint nextTimePoint = new MillisecondsTimePoint(startTime.asMillis() + timeStep);
        ArrayList<TimedPositionWithSpeed> points = new ArrayList<TimedPositionWithSpeed>();
        int idx = 1;
        while (idx < this.pathPoints.size()) {
            if (this.pathPoints.get(idx).getTimePoint().asMillis() >= nextTimePoint.asMillis() || idx == this.pathPoints.size() - 1) {
                if (nextTimePoint.after(endTime)) {
                    nextTimePoint = endTime;
                }
                TimedPositionWithSpeed p1 = this.pathPoints.get(idx - 1);
                TimedPositionWithSpeed p2 = this.pathPoints.get(idx);
                Distance dist = p1.getPosition().getDistance(p2.getPosition());
                double scale1 = nextTimePoint.asMillis() - p1.getTimePoint().asMillis();
                double scale2 = p2.getTimePoint().asMillis() - p1.getTimePoint().asMillis();
                Position nextPosition = p1.getPosition().translateGreatCircle(p1.getPosition().getBearingGreatCircle(p2.getPosition()), dist.scale(scale1 / scale2));
                Wind nextWind = null;
                if (this.windField != null) {
                    nextWind = this.windField.getWind(new TimedPositionImpl((TimePoint)nextTimePoint, nextPosition));
                } else {
                    double nextWindSpeed = p1.getSpeed().getKnots() + (p2.getSpeed().getKnots() - p1.getSpeed().getKnots()) * scale1 / scale2;
                    double nextWindAngle = p1.getSpeed().getBearing().getDegrees() + (p2.getSpeed().getBearing().getDegrees() - p1.getSpeed().getBearing().getDegrees()) * scale1 / scale2;
                    KnotSpeedWithBearingImpl nextWindSpeedWithBearing = new KnotSpeedWithBearingImpl(nextWindSpeed, (Bearing)new DegreeBearingImpl(nextWindAngle));
                    nextWind = new WindImpl(nextPosition, (TimePoint)nextTimePoint, (SpeedWithBearing)nextWindSpeedWithBearing);
                }
                TimedPositionWithSpeedImpl nextPoint = new TimedPositionWithSpeedImpl((TimePoint)nextTimePoint, nextPosition, (SpeedWithBearing)nextWind);
                TimedPositionWithSpeed prevPoint = (TimedPositionWithSpeed)path.get(path.size() - 1);
                double scaleDist = 0.01 * nextPoint.getPosition().getDistance(prevPoint.getPosition()).getMeters();
                double prevSide = 0.0;
                int maxCnt = 0;
                ArrayList<TimedPositionWithSpeed> maxPoint = new ArrayList<TimedPositionWithSpeed>();
                maxPoint.add((TimedPositionWithSpeed)path.get(0));
                ArrayList<Double> maxDist = new ArrayList<Double>();
                maxDist.add(0.0);
                Bearing nextBear = prevPoint.getPosition().getBearingGreatCircle(nextPoint.getPosition());
                int jdx = 0;
                while (jdx < points.size()) {
                    Position pcur = ((TimedPositionWithSpeed)points.get(jdx)).getPosition();
                    Position ptmp = pcur.projectToLineThrough(prevPoint.getPosition(), nextBear);
                    double side = Math.signum(nextBear.getDifferenceTo(prevPoint.getPosition().getBearingGreatCircle(pcur)).getDegrees());
                    boolean sideChange = prevSide != 0.0 && side != prevSide;
                    double lineDist = (double)Math.round(ptmp.getDistance(pcur).getMeters() * 1000.0) / 1000.0;
                    if (sideChange) {
                        ++maxCnt;
                        maxDist.add(0.0);
                        maxPoint.add((TimedPositionWithSpeed)path.get(0));
                    }
                    if (lineDist > (Double)maxDist.get(maxCnt)) {
                        maxPoint.set(maxCnt, (TimedPositionWithSpeed)points.get(jdx));
                        maxDist.set(maxCnt, lineDist);
                    }
                    prevSide = side;
                    ++jdx;
                }
                int cnt = 0;
                while (cnt <= maxCnt) {
                    if ((Double)maxDist.get(cnt) > scaleDist) {
                        Wind maxWind = null;
                        if (this.windField != null) {
                            maxWind = this.windField.getWind(new TimedPositionImpl(((TimedPositionWithSpeed)maxPoint.get(cnt)).getTimePoint(), ((TimedPositionWithSpeed)maxPoint.get(cnt)).getPosition()));
                            maxPoint.set(cnt, new TimedPositionWithSpeedImpl(((TimedPositionWithSpeed)maxPoint.get(cnt)).getTimePoint(), ((TimedPositionWithSpeed)maxPoint.get(cnt)).getPosition(), (SpeedWithBearing)maxWind));
                        }
                        path.add((TimedPositionWithSpeed)maxPoint.get(cnt));
                    }
                    ++cnt;
                }
                path.add(nextPoint);
                points = new ArrayList();
                nextTimePoint = nextTimePoint.plus(timeStep);
            }
            points.add(this.pathPoints.get(idx));
            if (this.pathPoints.get(idx).getTimePoint().asMillis() >= nextTimePoint.asMillis()) continue;
            ++idx;
        }
        if (((TimedPositionWithSpeed)path.get(path.size() - 1)).getTimePoint().asMillis() < endTime.asMillis()) {
            TimedPositionWithSpeed endPoint = this.pathPoints.get(this.pathPoints.size() - 1);
            Wind endWind = null;
            if (this.windField != null) {
                endWind = this.windField.getWind(new TimedPositionImpl(endPoint.getTimePoint(), endPoint.getPosition()));
                endPoint = new TimedPositionWithSpeedImpl(endPoint.getTimePoint(), endPoint.getPosition(), (SpeedWithBearing)endWind);
            }
            path.add(endPoint);
        }
        return path;
    }

    @Override
    public void setWindField(WindField wf) {
        this.windField = wf;
    }

    public TimedPositionWithSpeed getPositionAtTime(TimePoint t) {
        if (t.compareTo((Object)this.pathPoints.get(0).getTimePoint()) == 0) {
            return this.pathPoints.get(0);
        }
        if (t.compareTo((Object)this.pathPoints.get(this.pathPoints.size() - 1).getTimePoint()) >= 0) {
            return this.pathPoints.get(this.pathPoints.size() - 1);
        }
        TimedPositionWithSpeed p1 = null;
        TimedPositionWithSpeed p2 = null;
        for (TimedPositionWithSpeed p : this.pathPoints) {
            if (p.getTimePoint().compareTo((Object)t) < 0) continue;
            p2 = p;
            p1 = this.pathPoints.get(this.pathPoints.indexOf(p) - 1);
            break;
        }
        double t1 = 1000.0 * (double)p1.getTimePoint().asMillis();
        double t2 = 1000.0 * (double)p2.getTimePoint().asMillis();
        double t0 = 1000.0 * (double)t.asMillis();
        Distance dist = p1.getPosition().getDistance(p2.getPosition());
        Position p0 = p1.getPosition().translateGreatCircle(p1.getPosition().getBearingGreatCircle(p2.getPosition()), dist.scale((t0 - t1) / (t2 - t1)));
        Wind windAtPoint = this.windField.getWind(new TimedPositionImpl(t, p0));
        return new TimedPositionWithSpeedImpl(t, p0, (SpeedWithBearing)windAtPoint);
    }

    public List<TimedPositionWithSpeed> getEvenTimedPoints(long milliseconds) {
        if (milliseconds == 0L) {
            return null;
        }
        ArrayList<TimedPositionWithSpeed> lst = new ArrayList<TimedPositionWithSpeed>();
        TimePoint t = this.pathPoints.get(0).getTimePoint();
        TimePoint lastPoint = this.pathPoints.get(this.pathPoints.size() - 1).getTimePoint();
        while (t.compareTo((Object)lastPoint) <= 0 && lst.size() < 200) {
            lst.add(this.getPositionAtTime(t));
            t = new MillisecondsTimePoint(t.asMillis() + milliseconds);
        }
        if (t.compareTo((Object)lastPoint) > 0) {
            lst.add(this.getPositionAtTime(t));
        }
        return lst;
    }

    public List<TimedPositionWithSpeed> getEvenDistancedPoints(Distance dist) {
        return null;
    }

    @Override
    public List<TimedPositionWithSpeed> getTurns() {
        if (this.pathPoints == null) {
            return null;
        }
        ArrayList<TimedPositionWithSpeed> list = new ArrayList<TimedPositionWithSpeed>();
        if (this.pathPoints.isEmpty()) {
            return list;
        }
        int noOfPoints = this.pathPoints.size();
        TimedPositionWithSpeed previousPoint = null;
        TimedPositionWithSpeed currentPoint = null;
        TimedPositionWithSpeed nextPoint = null;
        int index = 0;
        while (index < noOfPoints) {
            currentPoint = this.pathPoints.get(index);
            if (index == 0 || index == noOfPoints - 1) {
                list.add(currentPoint);
            } else {
                previousPoint = this.pathPoints.get(index - 1);
                nextPoint = this.pathPoints.get(index + 1);
                if (PathImpl.isTurn(currentPoint.getPosition(), previousPoint.getPosition(), nextPoint.getPosition())) {
                    list.add(currentPoint);
                }
            }
            ++index;
        }
        return PathImpl.eliminateVeryCloseTurns(list, 15.0);
    }

    public static List<TimedPositionWithSpeed> eliminateVeryCloseTurns(List<TimedPositionWithSpeed> turns, double tresholdDistanceMeters) {
        ArrayList<TimedPositionWithSpeed> goodTurns = new ArrayList<TimedPositionWithSpeed>();
        int noOfTurnsMinus1 = turns.size() - 1;
        boolean clusterFound = false;
        int clusterStart = -1;
        int clusterEnd = -1;
        int index = 0;
        while (index < noOfTurnsMinus1) {
            if (turns.get(index).getPosition().getDistance(turns.get(index + 1).getPosition()).getMeters() < tresholdDistanceMeters) {
                if (!clusterFound) {
                    clusterFound = true;
                    clusterStart = index;
                }
                clusterEnd = index + 1;
            } else if (clusterFound) {
                clusterFound = false;
                goodTurns.add(turns.get((clusterStart + clusterEnd) / 2));
            } else {
                goodTurns.add(turns.get(index));
            }
            ++index;
        }
        goodTurns.add(turns.get(turns.size() - 1));
        return goodTurns;
    }

    public static boolean saveToGpxFile(Path path, String fileName) {
        if (path == null) {
            return false;
        }
        List<TimedPositionWithSpeed> pathPoints = path.getPathPoints();
        if (pathPoints == null || pathPoints.isEmpty()) {
            return false;
        }
        TimedPositionWithSpeed timedPoint = null;
        Position point = null;
        int noOfPoints = pathPoints.size();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>\r\n<gpx xmlns=\"http://www.topografix.com/GPX/1/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">\r\n\t<trk>\r\n\t\t<name>GPSPolyPath</name>\r\n\t\t<trkseg>");
        int index = 0;
        while (index < noOfPoints) {
            timedPoint = pathPoints.get(index);
            point = timedPoint.getPosition();
            buffer.append("\r\n\t\t\t<trkpt lat=\"" + point.getLatDeg() + "\" lon=\"" + point.getLngDeg() + "\">\r\n\t\t\t\t<ele>0</ele>\r\n\t\t\t\t<time>" + formatter.format((Object)timedPoint.getTimePoint().asDate()) + "</time>\r\n\t\t\t</trkpt>");
            ++index;
        }
        buffer.append("\r\n\t\t</trkseg>\r\n\t</trk>\r\n</gpx>\r\n");
        String content = buffer.toString();
        try {
            FileWriter writer = new FileWriter(fileName);
            BufferedWriter output = new BufferedWriter(writer, 32768);
            try {
                output.write(content);
            }
            finally {
                output.close();
                writer.close();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean isTurn(Position currentPosition, Position previousPoint, Position nextPoint) {
        Bearing b2;
        Bearing b1 = previousPoint.getBearingGreatCircle(currentPosition);
        double diff = b1.getDifferenceTo(b2 = currentPosition.getBearingGreatCircle(nextPoint)).getDegrees();
        if (diff < 0.0) {
            diff += 360.0;
        }
        return !(diff >= 0.0 && diff <= 25.0 || diff >= 155.0 && diff <= 205.0 || diff >= 335.0 && diff <= 360.0);
    }

    @Override
    public TimePoint getFinalTime() {
        TimePoint finalTime = null;
        if (this.pathPoints != null && this.pathPoints.size() > 0) {
            finalTime = this.pathPoints.get(this.pathPoints.size() - 1).getTimePoint();
        }
        return finalTime;
    }
}

