/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.PathCandidateBitSet;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class PathGeneratorTreeGrowBitSet
extends PathGeneratorBase {
    private static Logger logger = Logger.getLogger("com.sap.sailing");
    private boolean debugMsgOn = false;
    double oobFact = 2.0;
    int maxTurns = 0;
    boolean upwindLeg = false;
    String initPathStr = "0";
    PathCandidateBitSet bestCand = null;
    long usedTimeStep = 0L;
    boolean gridStore = false;
    ArrayList<List<PathCandidateBitSet>> gridPositions = null;
    ArrayList<List<PathCandidateBitSet>> isocPositions = null;
    String gridFile = null;
    static final boolean LEFT = false;
    static final boolean RIGHT = true;

    public PathGeneratorTreeGrowBitSet(SimulationParameters params) {
        this.parameters = params;
    }

    public void setEvaluationParameters(String startDirection, int maxTurns, String gridFile) {
        this.initPathStr = startDirection != null ? "0" + startDirection : "0";
        this.maxTurns = maxTurns;
        this.gridFile = gridFile;
        if (this.gridFile != null) {
            this.gridStore = true;
            this.gridPositions = new ArrayList();
            this.isocPositions = new ArrayList();
        } else {
            this.gridStore = false;
            this.gridPositions = null;
            this.isocPositions = null;
        }
    }

    PathCandidateBitSet getBestCand() {
        return this.bestCand;
    }

    long getUsedTimeStep() {
        return this.usedTimeStep;
    }

    TimedPosition getStep(TimedPosition pos, long timeStep, long turnLoss, boolean sameBaseDirection, boolean nextDirection) {
        WindFieldGenerator wf = this.parameters.getWindField();
        TimePoint curTime = pos.getTimePoint();
        Position curPosition = pos.getPosition();
        Wind posWind = wf.getWind(new TimedPositionImpl(curTime, curPosition));
        PolarDiagram pd = this.parameters.getBoatPolarDiagram();
        pd.setWind((SpeedWithBearing)posWind);
        Bearing travelBearing = null;
        if (!nextDirection) {
            travelBearing = this.upwindLeg ? pd.optimalDirectionsUpwind()[0] : pd.optimalDirectionsDownwind()[0];
        } else if (nextDirection) {
            travelBearing = this.upwindLeg ? pd.optimalDirectionsUpwind()[1] : pd.optimalDirectionsDownwind()[1];
        }
        SpeedWithBearing travelSpeed = pd.getSpeedAtBearing(travelBearing);
        MillisecondsTimePoint nextTime = new MillisecondsTimePoint(curTime.asMillis() + timeStep);
        MillisecondsTimePoint travelTime = sameBaseDirection ? nextTime : new MillisecondsTimePoint(nextTime.asMillis() - turnLoss);
        Position nextPosition = travelSpeed.travelTo(curPosition, curTime, (TimePoint)travelTime);
        return new TimedPositionImpl((TimePoint)nextTime, nextPosition);
    }

    boolean isSameDirection(int length, boolean prevDirection, boolean nextDirection) {
        return nextDirection == prevDirection || length <= 1;
    }

    PathCandidateBitSet getPathCandWind(PathCandidateBitSet path, boolean nextDirection, long timeStep, long turnLoss, Position posStart, Position posEnd, double tgtHeight) {
        double vrtSide;
        boolean prevDirection = path.path.get(path.length - 1);
        boolean sameBaseDirection = this.isSameDirection(path.length, prevDirection, nextDirection);
        int turnCount = path.trn;
        if (!sameBaseDirection) {
            ++turnCount;
        }
        TimedPosition pathPos = this.getStep(path.pos, timeStep, turnLoss, sameBaseDirection, nextDirection);
        Wind posWind = this.parameters.getWindField().getWind(pathPos);
        PolarDiagram pd = this.parameters.getBoatPolarDiagram();
        pd.setWind((SpeedWithBearing)posWind);
        WindImpl appWind = new WindImpl(posWind.getPosition(), posWind.getTimePoint(), pd.getWind());
        Position posHeight = pathPos.getPosition().projectToLineThrough(posEnd, appWind.getBearing());
        Bearing bearHeight = posEnd.getBearingGreatCircle(posHeight);
        double bearHeightSide = appWind.getBearing().getDifferenceTo(bearHeight).getDegrees();
        double d = vrtSide = this.upwindLeg ? -1.0 : 1.0;
        if (Math.abs(bearHeightSide) > 170.0) {
            vrtSide = this.upwindLeg ? 1.0 : -1.0;
        }
        double vrtDist = vrtSide * (double)Math.round(posHeight.getDistance(posEnd).getMeters() * 1000.0) / 1000.0;
        boolean reachedEnd = false;
        if (!path.reached && vrtDist > 0.0) {
            Position prevPos = path.pos.getPosition();
            TimePoint prevTime = path.pos.getTimePoint();
            double heightFrac = path.vrt / (path.vrt - vrtDist);
            Position newPos = prevPos.translateGreatCircle(prevPos.getBearingGreatCircle(pathPos.getPosition()), prevPos.getDistance(pathPos.getPosition()).scale(heightFrac));
            long newTimeMillis = Math.round(((double)prevTime.asMillis() + (double)(pathPos.getTimePoint().asMillis() - prevTime.asMillis()) * heightFrac) / 1000.0) * 1000L;
            MillisecondsTimePoint newTime = new MillisecondsTimePoint(newTimeMillis);
            pathPos = new TimedPositionImpl((TimePoint)newTime, newPos);
            reachedEnd = true;
        }
        double posSide = 1.0;
        Bearing posBear = posStart.getBearingGreatCircle(pathPos.getPosition());
        Bearing bearVrt = posStart.getBearingGreatCircle(posEnd);
        double posBearDiff = bearVrt.getDifferenceTo(posBear).getDegrees();
        if (posBearDiff < 0.0 || posBearDiff > 180.0) {
            posSide = -1.0;
        } else if (posBearDiff == 0.0 || posBearDiff == 180.0) {
            posSide = 0.0;
        }
        Position posHeightTrgt = pathPos.getPosition().projectToLineThrough(posStart, bearVrt);
        double hrzDist = (double)Math.round(posSide * posHeightTrgt.getDistance(pathPos.getPosition()).getMeters() * 1000.0) / 1000.0;
        BitSet newPath = new BitSet(path.length + 1);
        newPath.or(path.path);
        newPath.set(path.length, nextDirection);
        return new PathCandidateBitSet(pathPos, reachedEnd, vrtDist, hrzDist, turnCount, newPath, path.length + 1, nextDirection, (Wind)appWind);
    }

    List<PathCandidateBitSet> getPathCandsBeatWind(PathCandidateBitSet path, long timeStep, long turnLoss, Position posStart, Position posEnd, double tgtHeight) {
        ArrayList<PathCandidateBitSet> result = new ArrayList<PathCandidateBitSet>();
        if (this.maxTurns > 0) {
            PathCandidateBitSet newPathCand;
            boolean prevDirection = path.path.get(path.length - 1);
            if (path.trn < this.maxTurns || this.isSameDirection(path.length, prevDirection, false)) {
                newPathCand = this.getPathCandWind(path, false, timeStep, turnLoss, posStart, posEnd, tgtHeight);
                result.add(newPathCand);
            }
            if (path.trn < this.maxTurns || this.isSameDirection(path.length, prevDirection, true)) {
                newPathCand = this.getPathCandWind(path, true, timeStep, turnLoss, posStart, posEnd, tgtHeight);
                result.add(newPathCand);
            }
        } else {
            PathCandidateBitSet newPathCand = this.getPathCandWind(path, false, timeStep, turnLoss, posStart, posEnd, tgtHeight);
            result.add(newPathCand);
            newPathCand = this.getPathCandWind(path, true, timeStep, turnLoss, posStart, posEnd, tgtHeight);
            result.add(newPathCand);
        }
        return result;
    }

    Util.Pair<List<PathCandidateBitSet>, List<PathCandidateBitSet>> generateCandidate(List<PathCandidateBitSet> oldPaths, long timeStep, long turnLoss, Position posStart, Position posMiddle, Position posEnd, double tgtHeight) {
        ArrayList<PathCandidateBitSet> leftPaths = new ArrayList<PathCandidateBitSet>();
        ArrayList<PathCandidateBitSet> rightPaths = new ArrayList<PathCandidateBitSet>();
        for (PathCandidateBitSet curPath : oldPaths) {
            if (curPath.reached) continue;
            List<PathCandidateBitSet> newPathCands = this.getPathCandsBeatWind(curPath, timeStep, turnLoss, posStart, posEnd, tgtHeight);
            for (PathCandidateBitSet curNewPath : newPathCands) {
                double distFromMiddleMeters = posMiddle.getDistance(curPath.pos.getPosition()).getMeters();
                if (distFromMiddleMeters > this.oobFact * tgtHeight) continue;
                if (!curNewPath.sid) {
                    leftPaths.add(curNewPath);
                    continue;
                }
                if (!curNewPath.sid) continue;
                rightPaths.add(curNewPath);
            }
        }
        Util.Pair newPaths = new Util.Pair(leftPaths, rightPaths);
        return newPaths;
    }

    List<PathCandidateBitSet> filterCandidates(List<PathCandidateBitSet> allCands, double hrzBinWidth) {
        boolean[] filterMap = new boolean[allCands.size()];
        SortPathCandsHorizontally sortHorizontal = new SortPathCandsHorizontally();
        Collections.sort(allCands, sortHorizontal);
        int idxL = 0;
        int idxR = 0;
        int idx = 0;
        while (idx < allCands.size()) {
            double hrzDist = allCands.get((int)idx).hrz;
            while (Math.abs(hrzDist - allCands.get((int)idxL).hrz) > hrzBinWidth) {
                ++idxL;
            }
            boolean finished = false;
            while (!finished && idxR < allCands.size() - 1) {
                if (Math.abs(hrzDist - allCands.get((int)(idxR + 1)).hrz) <= hrzBinWidth) {
                    ++idxR;
                    continue;
                }
                finished = true;
            }
            int vrtIdx = idxL;
            double vrtMax = allCands.get((int)vrtIdx).vrt;
            filterMap[vrtIdx] = false;
            if (idxL < idxR) {
                int jdx = idxL + 1;
                while (jdx <= idxR) {
                    if (allCands.get((int)jdx).vrt > vrtMax) {
                        filterMap[vrtIdx] = true;
                        vrtMax = allCands.get((int)jdx).vrt;
                        vrtIdx = jdx;
                        filterMap[vrtIdx] = false;
                    } else {
                        filterMap[jdx] = true;
                    }
                    ++jdx;
                }
            }
            ++idx;
        }
        ArrayList<PathCandidateBitSet> filterCands = new ArrayList<PathCandidateBitSet>();
        int idx2 = 0;
        while (idx2 < allCands.size()) {
            if (!filterMap[idx2]) {
                filterCands.add(allCands.get(idx2));
            }
            ++idx2;
        }
        return filterCands;
    }

    List<PathCandidateBitSet> filterIsochrone(List<PathCandidateBitSet> allCands, double hrzBinWidth) {
        boolean[] filterMap = new boolean[allCands.size()];
        int idx = 0;
        while (idx < allCands.size()) {
            filterMap[idx] = true;
            ++idx;
        }
        SortPathCandsHorizontally sortHorizontal = new SortPathCandsHorizontally();
        Collections.sort(allCands, sortHorizontal);
        int idxL = 0;
        int idxR = 0;
        int idx2 = 0;
        while (idx2 < allCands.size()) {
            double hrzDist = allCands.get((int)idx2).hrz;
            while (Math.abs(hrzDist - allCands.get((int)idxL).hrz) > hrzBinWidth) {
                ++idxL;
            }
            boolean finished = false;
            while (!finished && idxR < allCands.size() - 1) {
                if (Math.abs(hrzDist - allCands.get((int)(idxR + 1)).hrz) <= hrzBinWidth) {
                    ++idxR;
                    continue;
                }
                finished = true;
            }
            ArrayList<Integer> vrtIdx = new ArrayList<Integer>();
            vrtIdx.add(idxL);
            double vrtMax = allCands.get((int)idxL).vrt;
            if (idxL < idxR) {
                int jdx = idxL + 1;
                while (jdx <= idxR) {
                    if (allCands.get((int)jdx).vrt > vrtMax) {
                        vrtMax = allCands.get((int)jdx).vrt;
                        vrtIdx = new ArrayList();
                        vrtIdx.add(jdx);
                    } else if (allCands.get((int)jdx).vrt == vrtMax) {
                        vrtIdx.add(jdx);
                    }
                    ++jdx;
                }
            }
            for (Integer jdx : vrtIdx) {
                filterMap[jdx.intValue()] = false;
            }
            ++idx2;
        }
        ArrayList<PathCandidateBitSet> filterCands = new ArrayList<PathCandidateBitSet>();
        int idx3 = 0;
        while (idx3 < allCands.size()) {
            if (!filterMap[idx3]) {
                filterCands.add(allCands.get(idx3));
            }
            ++idx3;
        }
        return filterCands;
    }

    @Override
    public Path getPath() {
        TimedPositionWithSpeedImpl curPosition;
        this.algorithmStartTime = MillisecondsTimePoint.now();
        WindFieldGenerator wf = this.parameters.getWindField();
        PolarDiagram pd = this.parameters.getBoatPolarDiagram();
        Position startPos = this.parameters.getCourse().get(0);
        Position endPos = this.parameters.getCourse().get(1);
        TimePoint startTime = wf.getStartTime();
        ArrayList<TimedPositionWithSpeed> path = new ArrayList<TimedPositionWithSpeed>();
        Position currentPosition = startPos;
        TimePoint currentTime = startTime;
        Distance distStartEnd = startPos.getDistance(endPos);
        double distStartEndMeters = distStartEnd.getMeters();
        Wind wndStart = wf.getWind(new TimedPositionWithSpeedImpl(startTime, startPos, null));
        logger.fine("wndStart speed:" + wndStart.getKnots() + " angle:" + wndStart.getBearing().getDegrees());
        pd.setWind((SpeedWithBearing)wndStart);
        Bearing bearVrt = startPos.getBearingGreatCircle(endPos);
        Position middlePos = startPos.translateGreatCircle(bearVrt, distStartEnd.scale(0.5));
        Bearing bearRCWind = wndStart.getBearing().getDifferenceTo(bearVrt);
        String legType = "downwind";
        this.upwindLeg = false;
        if (Math.abs(bearRCWind.getDegrees()) > 90.0 && Math.abs(bearRCWind.getDegrees()) < 270.0) {
            legType = "upwind";
            this.upwindLeg = true;
        }
        if (this.debugMsgOn) {
            System.out.println("start : " + startPos.getLatDeg() + ", " + startPos.getLngDeg());
            System.out.println("middle: " + middlePos.getLatDeg() + ", " + middlePos.getLngDeg());
            System.out.println("end   : " + endPos.getLatDeg() + ", " + endPos.getLngDeg());
        }
        logger.info("Leg Direction: " + legType);
        long turnLoss = pd.getTurnLoss();
        if (!this.upwindLeg) {
            turnLoss /= 2L;
        }
        logger.info("Turnloss :" + turnLoss);
        this.usedTimeStep = turnLoss + 1000L;
        logger.info("Time step :" + this.usedTimeStep);
        PathCandidateBitSet initPath = new PathCandidateBitSet(new TimedPositionImpl(currentTime, currentPosition), false, 0.0, 0.0, 0, new BitSet(1), 1, false, wndStart);
        if (this.initPathStr.length() > 1) {
            int nextDirectionChar = 48;
            int idx = 1;
            while (idx < this.initPathStr.length()) {
                PathCandidateBitSet newPathCand;
                nextDirectionChar = this.initPathStr.charAt(idx);
                boolean nextDirection = nextDirectionChar != 76;
                initPath = newPathCand = this.getPathCandWind(initPath, nextDirection, this.usedTimeStep, turnLoss, startPos, endPos, distStartEndMeters);
                ++idx;
            }
        }
        ArrayList<PathCandidateBitSet> allPaths = new ArrayList<PathCandidateBitSet>();
        ArrayList<PathCandidateBitSet> trgPaths = new ArrayList<PathCandidateBitSet>();
        allPaths.add(initPath);
        TimedPosition tstPosition = this.getStep(new TimedPositionImpl(startTime, startPos), this.usedTimeStep, turnLoss, true, false);
        double tstDist1 = startPos.getDistance(tstPosition.getPosition()).getMeters();
        tstPosition = this.getStep(new TimedPositionImpl(startTime, startPos), this.usedTimeStep, turnLoss, true, true);
        double tstDist2 = startPos.getDistance(tstPosition.getPosition()).getMeters();
        double hrzBinSize = (tstDist1 + tstDist2) / 6.0;
        if (this.debugMsgOn) {
            System.out.println("Horizontal Bin Size: " + hrzBinSize);
        }
        boolean reachedEnd = false;
        int addSteps = 0;
        int finalSteps = 0;
        while (!reachedEnd || addSteps < finalSteps) {
            if (reachedEnd) {
                ++addSteps;
            }
            Util.Pair<List<PathCandidateBitSet>, List<PathCandidateBitSet>> newPaths = this.generateCandidate(allPaths, this.usedTimeStep, turnLoss, startPos, middlePos, endPos, distStartEndMeters);
            List<PathCandidateBitSet> leftPaths = this.filterCandidates((List)newPaths.getA(), hrzBinSize / 2.0);
            List<PathCandidateBitSet> rightPaths = this.filterCandidates((List)newPaths.getB(), hrzBinSize / 2.0);
            ArrayList<PathCandidateBitSet> nextPaths = new ArrayList<PathCandidateBitSet>();
            nextPaths.addAll(leftPaths);
            nextPaths.addAll(rightPaths);
            allPaths = nextPaths;
            if (this.gridStore) {
                this.gridPositions.add(allPaths);
                List<PathCandidateBitSet> list = this.filterIsochrone(allPaths, hrzBinSize);
                this.isocPositions.add(list);
            }
            if (allPaths.size() > 0) {
                for (PathCandidateBitSet pathCandidateBitSet : allPaths) {
                    int curBin;
                    if (!pathCandidateBitSet.reached || Math.abs(curBin = (int)Math.round(Math.floor((pathCandidateBitSet.hrz + hrzBinSize / 2.0) / hrzBinSize))) > 4) continue;
                    reachedEnd = true;
                    trgPaths.add(pathCandidateBitSet);
                }
            } else {
                reachedEnd = true;
            }
            if (!this.isTimedOut()) continue;
            reachedEnd = true;
        }
        if (this.gridStore) {
            String outStr;
            BufferedWriter outputCSV;
            double distResolution = distStartEndMeters * 0.01;
            try {
                outputCSV = new BufferedWriter(new FileWriter(String.valueOf(this.gridFile) + "-grid.csv"));
                outputCSV.write("step; lat; lng; time; side; path; vrt\n");
                outputCSV.write("0; " + startPos.getLatDeg() + "; " + startPos.getLngDeg() + "; " + startTime.asMillis() / 1000L + "; 0; 0; " + -distStartEndMeters + "\n");
                outputCSV.write("0; " + endPos.getLatDeg() + "; " + endPos.getLngDeg() + "; " + startTime.asMillis() / 1000L + "; 0; 0; 0\n");
                int stepCount = 0;
                for (List list : this.gridPositions) {
                    ++stepCount;
                    PathCandidateBitSet prevPos = null;
                    for (PathCandidateBitSet isoPos : list) {
                        if (prevPos != null && prevPos.pos.getPosition().getDistance(isoPos.pos.getPosition()).getMeters() < distResolution) continue;
                        outStr = stepCount + "; " + isoPos.pos.getPosition().getLatDeg() + "; " + isoPos.pos.getPosition().getLngDeg() + "; " + isoPos.pos.getTimePoint().asMillis() / 1000L + "; " + isoPos.sid;
                        outStr = String.valueOf(outStr) + "; " + isoPos.path + "; " + isoPos.vrt;
                        outStr = String.valueOf(outStr) + "\n";
                        outputCSV.write(outStr);
                        prevPos = isoPos;
                    }
                }
                outputCSV.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                outputCSV = new BufferedWriter(new FileWriter(String.valueOf(this.gridFile) + "-isoc.csv"));
                outputCSV.write("step; lat; lng; time; side; path; vrt\n");
                outputCSV.write("0; " + startPos.getLatDeg() + "; " + startPos.getLngDeg() + "; " + startTime.asMillis() / 1000L + "; 0; 0; " + -distStartEndMeters + "\n");
                outputCSV.write("0; " + endPos.getLatDeg() + "; " + endPos.getLngDeg() + "; " + startTime.asMillis() / 1000L + "; 0; 0; 0\n");
                int stepCount = 0;
                for (List list : this.isocPositions) {
                    ++stepCount;
                    PathCandidateBitSet prevPos = null;
                    for (PathCandidateBitSet isoPos : list) {
                        if (prevPos != null && prevPos.pos.getPosition().getDistance(isoPos.pos.getPosition()).getMeters() < distResolution) continue;
                        outStr = stepCount + "; " + isoPos.pos.getPosition().getLatDeg() + "; " + isoPos.pos.getPosition().getLngDeg() + "; " + isoPos.pos.getTimePoint().asMillis() / 1000L + "; " + isoPos.sid;
                        outStr = String.valueOf(outStr) + "; " + isoPos.path + "; " + isoPos.vrt;
                        outStr = String.valueOf(outStr) + "\n";
                        outputCSV.write(outStr);
                        prevPos = isoPos;
                    }
                }
                outputCSV.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (trgPaths.size() == 0) {
            curPosition = new TimedPositionWithSpeedImpl(startTime, startPos, null);
            path.add(curPosition);
            return new PathImpl(path, wf, this.algorithmTimedOut);
        }
        Collections.sort(trgPaths);
        for (PathCandidateBitSet curPath : trgPaths) {
            logger.info("\nPath: " + curPath.path + "\n      Time: " + (curPath.pos.getTimePoint().asMillis() - startTime.asMillis()) + ", Height: " + curPath.vrt + " of " + (double)Math.round(startPos.getDistance(endPos).getMeters() * 100.0) / 100.0 + ", Dist: " + curPath.hrz + "m ~ " + (double)Math.round(curPath.pos.getPosition().getDistance(endPos).getMeters() * 100.0) / 100.0 + "m");
        }
        this.bestCand = (PathCandidateBitSet)trgPaths.get(0);
        curPosition = null;
        boolean nextDirection = false;
        boolean prevDirection = false;
        int step = 0;
        while (step < this.bestCand.length - 1) {
            nextDirection = this.bestCand.path.get(step);
            if (step == 0) {
                curPosition = new TimedPositionWithSpeedImpl(startTime, startPos, null);
                path.add(curPosition);
            } else {
                boolean bl = this.isSameDirection(step, prevDirection, nextDirection);
                TimedPosition newPosition = this.getStep(curPosition, this.usedTimeStep, turnLoss, bl, nextDirection);
                curPosition = new TimedPositionWithSpeedImpl(newPosition.getTimePoint(), newPosition.getPosition(), null);
                path.add(curPosition);
            }
            prevDirection = nextDirection;
            ++step;
        }
        path.add(new TimedPositionWithSpeedImpl(this.bestCand.pos.getTimePoint(), this.bestCand.pos.getPosition(), null));
        return new PathImpl(path, wf, this.algorithmTimedOut);
    }

    class SortPathCandsAbsHorizontally
    implements Comparator<PathCandidateBitSet> {
        SortPathCandsAbsHorizontally() {
        }

        @Override
        public int compare(PathCandidateBitSet p1, PathCandidateBitSet p2) {
            if (Math.abs(p1.hrz) == Math.abs(p2.hrz)) {
                return 0;
            }
            return Math.abs(p1.hrz) < Math.abs(p2.hrz) ? -1 : 1;
        }
    }

    class SortPathCandsHorizontally
    implements Comparator<PathCandidateBitSet> {
        SortPathCandsHorizontally() {
        }

        @Override
        public int compare(PathCandidateBitSet p1, PathCandidateBitSet p2) {
            if (p1.hrz == p2.hrz) {
                return 0;
            }
            return p1.hrz < p2.hrz ? -1 : 1;
        }
    }
}

