/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PointOfSail;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.PathCandidate;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.PolarDiagramBase;
import com.sap.sailing.simulator.impl.SimulationParametersImpl;
import com.sap.sailing.simulator.impl.SparseSimulationDataException;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindField;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;

public class PathGeneratorTreeGrow360
extends PathGeneratorBase {
    private static final Logger logger = Logger.getLogger(PathGeneratorTreeGrow360.class.getName());
    private boolean debugMsgOn = false;
    double oobFact = 2.0;
    int maxTurns = 0;
    boolean upwindLeg = false;
    String initPathStr = "0";
    PathCandidate bestCand = null;
    long usedTimeStep = 0L;
    boolean gridStore = false;
    ArrayList<List<PathCandidate>> gridPositions = null;
    ArrayList<List<PathCandidate>> isocPositions = null;
    String gridFile = null;
    Distance endLineWidth = null;
    int endMatchCriterion;

    public PathGeneratorTreeGrow360(SimulationParameters params) {
        PolarDiagramBase polarDiagramClone = new PolarDiagramBase((PolarDiagramBase)params.getBoatPolarDiagram());
        this.parameters = new SimulationParametersImpl(params.getCourse(), params.getStartLine(), params.getEndLine(), polarDiagramClone, params.getWindField(), params.getSimuStep(), params.getMode(), params.showOmniscient(), params.showOpportunist(), params.getLegType());
    }

    public void setEvaluationParameters(String startDirection, int maxTurns, String gridFile) {
        this.initPathStr = startDirection != null ? "0" + startDirection : "0";
        this.maxTurns = maxTurns;
        this.gridFile = gridFile;
        if (this.gridFile != null) {
            this.gridStore = true;
            this.gridPositions = new ArrayList();
            this.isocPositions = new ArrayList();
        } else {
            this.gridStore = false;
            this.gridPositions = null;
            this.isocPositions = null;
        }
    }

    PathCandidate getBestCand() {
        return this.bestCand;
    }

    long getUsedTimeStep() {
        return this.usedTimeStep;
    }

    TimedPosition getStep(TimedPosition pos, Wind posWind, Position posEnd, long timeStep, long turnLoss, boolean sameBaseDirection, char nextDirection) throws SparseSimulationDataException {
        TimePoint curTime = pos.getTimePoint();
        Position curPosition = pos.getPosition();
        PolarDiagram polarDiagram = this.parameters.getBoatPolarDiagram();
        polarDiagram.setWind((SpeedWithBearing)posWind);
        Bearing travelBearing = null;
        SpeedWithBearing travelSpeed = null;
        if (nextDirection == 'L') {
            travelBearing = polarDiagram.optimalDirectionsUpwind()[0];
            travelSpeed = polarDiagram.getSpeedAtBearing(travelBearing);
        }
        if (nextDirection == 'r') {
            travelBearing = polarDiagram.optimalDirectionsDownwind()[0];
            travelSpeed = polarDiagram.getSpeedAtBearing(travelBearing);
        }
        if (nextDirection == 'R') {
            travelBearing = polarDiagram.optimalDirectionsUpwind()[1];
            travelSpeed = polarDiagram.getSpeedAtBearing(travelBearing);
        }
        if (nextDirection == 'l') {
            travelBearing = polarDiagram.optimalDirectionsDownwind()[1];
            travelSpeed = polarDiagram.getSpeedAtBearing(travelBearing);
        }
        if (nextDirection == 'D' || nextDirection == 'E') {
            travelBearing = curPosition.getBearingGreatCircle(posEnd);
            travelSpeed = polarDiagram.hasCurrent() ? polarDiagram.getSpeedAtBearingOverGround(travelBearing) : polarDiagram.getSpeedAtBearing(travelBearing);
        }
        if (travelBearing == null || travelSpeed == null) {
            if (travelBearing == null) {
                logger.severe("Travel Bearing for NextDirection '" + nextDirection + "' is NULL. This must NOT happen.");
            }
            if (travelSpeed == null) {
                logger.severe("Travel Speed for NextDirection '" + nextDirection + "' is NULL. This must NOT happen.");
            }
            throw new SparseSimulationDataException();
        }
        if (travelSpeed.getKnots() == 0.0 && !polarDiagram.hasCurrent()) {
            logger.severe("Travel Speed for NextDirection '" + nextDirection + "' is ZERO. This must NOT happen.");
            throw new SparseSimulationDataException();
        }
        MillisecondsTimePoint nextTime = new MillisecondsTimePoint(curTime.asMillis() + timeStep);
        MillisecondsTimePoint travelTime = sameBaseDirection ? nextTime : new MillisecondsTimePoint(nextTime.asMillis() - turnLoss);
        Position nextPosition = travelSpeed.travelTo(curPosition, curTime, (TimePoint)travelTime);
        return new TimedPositionImpl((TimePoint)nextTime, nextPosition);
    }

    boolean isSameDirection(char prevDirection, char nextDirection) {
        char tmpPrevDirection = this.getBaseDirection(prevDirection);
        char tmpNextDirection = this.getBaseDirection(nextDirection);
        return tmpNextDirection == tmpPrevDirection || tmpPrevDirection == '0';
    }

    char getOppositeDirection(char direction) {
        char oppositeDirection = ' ';
        switch (direction) {
            case 'L': {
                oppositeDirection = 'R';
                break;
            }
            case 'R': {
                oppositeDirection = 'L';
                break;
            }
            case 'l': {
                oppositeDirection = 'r';
                break;
            }
            case 'r': {
                oppositeDirection = 'l';
            }
        }
        return oppositeDirection;
    }

    char getBaseDirection(char direction) {
        char tmpDirection = direction;
        return (char)(tmpDirection == 'D' ? 76 : (tmpDirection == 'E' ? 82 : (tmpDirection == 'l' ? 76 : (tmpDirection == 'r' ? 82 : (int)tmpDirection))));
    }

    PathCandidate getPathCandWind(PathCandidate path, char nextDirection, long timeStep, long turnLoss, Position posStart, Position posEnd, double tgtHeight) throws SparseSimulationDataException {
        char prevDirection = path.path.charAt(path.path.length() - 1);
        boolean sameBaseDirection = this.isSameDirection(prevDirection, nextDirection);
        int turnCount = path.trn;
        if (!sameBaseDirection) {
            ++turnCount;
        }
        TimedPosition pathPos = this.getStep(path.pos, path.wind, posEnd, timeStep, turnLoss, sameBaseDirection, nextDirection);
        Wind posWind = this.parameters.getWindField().getWind(pathPos);
        Bearing bearVrt = posStart.getBearingGreatCircle(posEnd);
        Position posHeight = pathPos.getPosition().projectToLineThrough(posEnd, bearVrt.reverse());
        Bearing bearHeight = posEnd.getBearingGreatCircle(posHeight);
        double bearHeightSide = bearVrt.reverse().getDifferenceTo(bearHeight).getDegrees();
        double vrtSide = -1.0;
        if (Math.abs(bearHeightSide) > 170.0) {
            vrtSide = 1.0;
        }
        double vrtDist = vrtSide * (double)Math.round(posHeight.getDistance(posEnd).getMeters() * 1000.0) / 1000.0;
        boolean reachedEnd = false;
        if (!path.reached && vrtDist > 0.0) {
            Position prevPos = path.pos.getPosition();
            TimePoint prevTime = path.pos.getTimePoint();
            double heightFrac = path.vrt / (path.vrt - vrtDist);
            Position newPos = prevPos.translateGreatCircle(prevPos.getBearingGreatCircle(pathPos.getPosition()), prevPos.getDistance(pathPos.getPosition()).scale(heightFrac));
            long newTimeMillis = Math.round(((double)prevTime.asMillis() + (double)(pathPos.getTimePoint().asMillis() - prevTime.asMillis()) * heightFrac) / 1000.0) * 1000L;
            MillisecondsTimePoint newTime = new MillisecondsTimePoint(newTimeMillis);
            pathPos = new TimedPositionImpl((TimePoint)newTime, newPos);
            reachedEnd = true;
        }
        double posSide = 1.0;
        Bearing posBear = posStart.getBearingGreatCircle(pathPos.getPosition());
        double posBearDiff = bearVrt.getDifferenceTo(posBear).getDegrees();
        if (posBearDiff < 0.0 || posBearDiff > 180.0) {
            posSide = -1.0;
        } else if (posBearDiff == 0.0 || posBearDiff == 180.0) {
            posSide = 0.0;
        }
        Position posHeightTrgt = pathPos.getPosition().projectToLineThrough(posStart, bearVrt);
        double hrzDist = (double)Math.round(posSide * posHeightTrgt.getDistance(pathPos.getPosition()).getMeters() * 1000.0) / 1000.0;
        String pathStr = String.valueOf(path.path) + nextDirection;
        return new PathCandidate(pathPos, reachedEnd, vrtDist, hrzDist, turnCount, pathStr, this.getBaseDirection(nextDirection), posWind, path.start);
    }

    List<PathCandidate> getPathCandsBeatWind(PathCandidate path, long timeStep, long turnLoss, Position posStart, Position posEnd, double tgtHeight) throws SparseSimulationDataException {
        PathCandidate newPathCand;
        Bearing bearTarget = path.pos.getPosition().getBearingGreatCircle(posEnd);
        PolarDiagram polarDiagram = this.parameters.getBoatPolarDiagram();
        polarDiagram.setWind((SpeedWithBearing)path.wind);
        Bearing[] bearOptimalUpwind = polarDiagram.optimalDirectionsUpwind();
        Bearing upwindLeftRight = bearOptimalUpwind[0].getDifferenceTo(bearOptimalUpwind[1]);
        Bearing upwindLeftTarget = bearOptimalUpwind[0].getDifferenceTo(bearTarget);
        PointOfSail pointOfSail = PointOfSail.REACHING;
        char reachingSide = ' ';
        if (upwindLeftTarget.getDegrees() >= -1.0 && upwindLeftTarget.getDegrees() <= upwindLeftRight.getDegrees() + 1.0) {
            logger.finest("point-of-sail: tacking (diffLeftTarget: " + upwindLeftTarget.getDegrees() + ", diffLeftRight: " + upwindLeftRight.getDegrees() + ", " + path.path + ")");
            pointOfSail = PointOfSail.TACKING;
        } else {
            Bearing[] bearOptimalDownwind = polarDiagram.optimalDirectionsDownwind();
            Bearing downwindLeftRight = bearOptimalDownwind[0].getDifferenceTo(bearOptimalDownwind[1]);
            Bearing downwindLeftTarget = bearOptimalDownwind[0].getDifferenceTo(bearTarget);
            if (downwindLeftTarget.getDegrees() >= -1.0 && downwindLeftTarget.getDegrees() <= downwindLeftRight.getDegrees() + 1.0) {
                logger.finest("point-of-sail: jibing (diffLeftTarget: " + downwindLeftTarget.getDegrees() + ", diffLeftRight: " + downwindLeftRight.getDegrees() + ", " + path.path + ")");
                pointOfSail = PointOfSail.JIBING;
            } else {
                Bearing windBoat = path.wind.getBearing().getDifferenceTo(bearTarget);
                reachingSide = windBoat.getDegrees() > 0.0 ? (char)'D' : 'E';
            }
        }
        ArrayList<PathCandidate> result = new ArrayList<PathCandidate>();
        if (this.maxTurns > 0) {
            char prevDirection = path.path.charAt(path.path.length() - 1);
            if (pointOfSail == PointOfSail.TACKING) {
                if (path.trn < this.maxTurns || this.isSameDirection(prevDirection, 'L')) {
                    newPathCand = this.getPathCandWind(path, 'L', timeStep, turnLoss, posStart, posEnd, tgtHeight);
                    result.add(newPathCand);
                }
                if (path.trn < this.maxTurns || this.isSameDirection(prevDirection, 'R')) {
                    newPathCand = this.getPathCandWind(path, 'R', timeStep, turnLoss, posStart, posEnd, tgtHeight);
                    result.add(newPathCand);
                }
            }
            if (pointOfSail == PointOfSail.JIBING) {
                if (path.trn < this.maxTurns || this.isSameDirection(prevDirection, 'l')) {
                    newPathCand = this.getPathCandWind(path, 'l', timeStep, turnLoss, posStart, posEnd, tgtHeight);
                    result.add(newPathCand);
                }
                if (path.trn < this.maxTurns || this.isSameDirection(prevDirection, 'r')) {
                    newPathCand = this.getPathCandWind(path, 'r', timeStep, turnLoss, posStart, posEnd, tgtHeight);
                    result.add(newPathCand);
                }
            }
            if (pointOfSail == PointOfSail.REACHING) {
                if (path.trn < this.maxTurns || this.isSameDirection(prevDirection, reachingSide)) {
                    newPathCand = this.getPathCandWind(path, reachingSide, timeStep, turnLoss, posStart, posEnd, tgtHeight);
                    result.add(newPathCand);
                }
                if (prevDirection != reachingSide && prevDirection != '0') {
                    newPathCand = this.getPathCandWind(path, prevDirection, timeStep, turnLoss, posStart, posEnd, tgtHeight);
                    result.add(newPathCand);
                }
                char oppositeDirection = this.getOppositeDirection(prevDirection);
                if (path.trn < this.maxTurns && oppositeDirection != ' ' && prevDirection != '0') {
                    newPathCand = this.getPathCandWind(path, oppositeDirection, timeStep, turnLoss, posStart, posEnd, tgtHeight);
                    result.add(newPathCand);
                }
            }
        } else {
            if (pointOfSail == PointOfSail.TACKING) {
                newPathCand = this.getPathCandWind(path, 'L', timeStep, turnLoss, posStart, posEnd, tgtHeight);
                result.add(newPathCand);
                newPathCand = this.getPathCandWind(path, 'R', timeStep, turnLoss, posStart, posEnd, tgtHeight);
                result.add(newPathCand);
            }
            if (pointOfSail == PointOfSail.JIBING) {
                newPathCand = this.getPathCandWind(path, 'l', timeStep, turnLoss, posStart, posEnd, tgtHeight);
                result.add(newPathCand);
                newPathCand = this.getPathCandWind(path, 'r', timeStep, turnLoss, posStart, posEnd, tgtHeight);
                result.add(newPathCand);
            }
            if (pointOfSail == PointOfSail.REACHING) {
                char oppositeDirection;
                newPathCand = this.getPathCandWind(path, reachingSide, timeStep, turnLoss, posStart, posEnd, tgtHeight);
                result.add(newPathCand);
                char prevDirection = path.path.charAt(path.path.length() - 1);
                if (prevDirection != reachingSide && prevDirection != '0') {
                    newPathCand = this.getPathCandWind(path, prevDirection, timeStep, turnLoss, posStart, posEnd, tgtHeight);
                    result.add(newPathCand);
                }
                if ((oppositeDirection = this.getOppositeDirection(prevDirection)) != ' ' && prevDirection != '0') {
                    newPathCand = this.getPathCandWind(path, oppositeDirection, timeStep, turnLoss, posStart, posEnd, tgtHeight);
                    result.add(newPathCand);
                }
            }
        }
        return result;
    }

    Util.Pair<List<PathCandidate>, List<PathCandidate>> generateCandidate(List<PathCandidate> oldPaths, long timeStep, long turnLoss, Position posStart, Position posMiddle, Position posEnd, double tgtHeight) throws SparseSimulationDataException {
        ArrayList<PathCandidate> leftPaths = new ArrayList<PathCandidate>();
        ArrayList<PathCandidate> rightPaths = new ArrayList<PathCandidate>();
        for (PathCandidate curPath : oldPaths) {
            if (curPath.reached) continue;
            List<PathCandidate> newPathCands = this.getPathCandsBeatWind(curPath, timeStep, turnLoss, posStart, posEnd, tgtHeight);
            for (PathCandidate curNewPath : newPathCands) {
                double distFromMiddleMeters = posMiddle.getDistance(curPath.pos.getPosition()).getMeters();
                if (distFromMiddleMeters > this.oobFact * tgtHeight) continue;
                if (curNewPath.sid == 'L') {
                    leftPaths.add(curNewPath);
                    continue;
                }
                if (curNewPath.sid != 'R') continue;
                rightPaths.add(curNewPath);
            }
        }
        Util.Pair newPaths = new Util.Pair(leftPaths, rightPaths);
        return newPaths;
    }

    List<PathCandidate> filterCandidates(List<PathCandidate> allCands, double hrzBinWidth) {
        boolean[] filterMap = new boolean[allCands.size()];
        SortPathCandsHorizontally sortHorizontal = new SortPathCandsHorizontally();
        Collections.sort(allCands, sortHorizontal);
        int idxL = 0;
        int idxR = 0;
        int idx = 0;
        while (idx < allCands.size()) {
            double hrzDist = allCands.get((int)idx).hrz;
            while (Math.abs(hrzDist - allCands.get((int)idxL).hrz) > hrzBinWidth) {
                ++idxL;
            }
            boolean finished = false;
            while (!finished && idxR < allCands.size() - 1) {
                if (Math.abs(hrzDist - allCands.get((int)(idxR + 1)).hrz) <= hrzBinWidth) {
                    ++idxR;
                    continue;
                }
                finished = true;
            }
            int vrtIdx = idxL;
            double vrtMax = allCands.get((int)vrtIdx).vrt;
            filterMap[vrtIdx] = false;
            if (idxL < idxR) {
                int jdx = idxL + 1;
                while (jdx <= idxR) {
                    if (allCands.get((int)jdx).vrt > vrtMax) {
                        filterMap[vrtIdx] = true;
                        vrtMax = allCands.get((int)jdx).vrt;
                        vrtIdx = jdx;
                        filterMap[vrtIdx] = false;
                    } else {
                        filterMap[jdx] = true;
                    }
                    ++jdx;
                }
            }
            ++idx;
        }
        ArrayList<PathCandidate> filterCands = new ArrayList<PathCandidate>();
        int idx2 = 0;
        while (idx2 < allCands.size()) {
            if (!filterMap[idx2]) {
                filterCands.add(allCands.get(idx2));
            }
            ++idx2;
        }
        return filterCands;
    }

    List<PathCandidate> filterIsochrone(List<PathCandidate> allCands, double hrzBinWidth) {
        boolean[] filterMap = new boolean[allCands.size()];
        int idx = 0;
        while (idx < allCands.size()) {
            filterMap[idx] = true;
            ++idx;
        }
        SortPathCandsHorizontally sortHorizontal = new SortPathCandsHorizontally();
        Collections.sort(allCands, sortHorizontal);
        int idxL = 0;
        int idxR = 0;
        int idx2 = 0;
        while (idx2 < allCands.size()) {
            double hrzDist = allCands.get((int)idx2).hrz;
            while (Math.abs(hrzDist - allCands.get((int)idxL).hrz) > hrzBinWidth) {
                ++idxL;
            }
            boolean finished = false;
            while (!finished && idxR < allCands.size() - 1) {
                if (Math.abs(hrzDist - allCands.get((int)(idxR + 1)).hrz) <= hrzBinWidth) {
                    ++idxR;
                    continue;
                }
                finished = true;
            }
            ArrayList<Integer> vrtIdx = new ArrayList<Integer>();
            vrtIdx.add(idxL);
            double vrtMax = allCands.get((int)idxL).vrt;
            if (idxL < idxR) {
                int jdx = idxL + 1;
                while (jdx <= idxR) {
                    if (allCands.get((int)jdx).vrt > vrtMax) {
                        vrtMax = allCands.get((int)jdx).vrt;
                        vrtIdx = new ArrayList();
                        vrtIdx.add(jdx);
                    } else if (allCands.get((int)jdx).vrt == vrtMax) {
                        vrtIdx.add(jdx);
                    }
                    ++jdx;
                }
            }
            for (Integer jdx : vrtIdx) {
                filterMap[jdx.intValue()] = false;
            }
            ++idx2;
        }
        ArrayList<PathCandidate> filterCands = new ArrayList<PathCandidate>();
        int idx3 = 0;
        while (idx3 < allCands.size()) {
            if (!filterMap[idx3]) {
                filterCands.add(allCands.get(idx3));
            }
            ++idx3;
        }
        return filterCands;
    }

    @Override
    public Path getPath() throws SparseSimulationDataException {
        this.algorithmStartTime = MillisecondsTimePoint.now();
        WindFieldGenerator wf = this.parameters.getWindField();
        PolarDiagram polarDiagram = this.parameters.getBoatPolarDiagram();
        Position startPos = this.parameters.getCourse().get(0);
        Position endPos = this.parameters.getCourse().get(1);
        Bearing bearVrt = startPos.getBearingGreatCircle(endPos);
        List<Position> endLine = this.parameters.getEndLine();
        if (endLine != null) {
            Position endPositionRight;
            Position endPositionLeft;
            Bearing bearEndLine = endLine.get(0).getBearingGreatCircle(endLine.get(1));
            double diffEndLineVrt = bearVrt.getDifferenceTo(bearEndLine).getDegrees();
            if (diffEndLineVrt > 0.0 && diffEndLineVrt < 180.0) {
                endPositionLeft = endLine.get(0);
                endPositionRight = endLine.get(1);
            } else {
                endPositionLeft = endLine.get(1);
                endPositionRight = endLine.get(0);
            }
            if (this.initPathStr.length() > 1) {
                endPos = this.initPathStr.charAt(1) == 'L' ? endPositionLeft : endPositionRight;
                this.endLineWidth = null;
            } else {
                this.endLineWidth = endPositionLeft.getDistance(endPositionRight);
            }
            bearVrt = startPos.getBearingGreatCircle(endPos);
        }
        TimePoint startTime = wf.getStartTime();
        ArrayList<TimedPositionWithSpeed> path = new ArrayList<TimedPositionWithSpeed>();
        Position currentPosition = startPos;
        TimePoint currentTime = startTime;
        Distance distStartEnd = startPos.getDistance(endPos);
        double distStartEndMeters = distStartEnd.getMeters();
        Wind wndStart = wf.getWind(new TimedPositionWithSpeedImpl(startTime, startPos, null));
        logger.finest("wndStart speed:" + wndStart.getKnots() + " angle:" + wndStart.getBearing().getDegrees());
        polarDiagram.setWind((SpeedWithBearing)wndStart);
        Position middlePos = startPos.translateGreatCircle(bearVrt, distStartEnd.scale(0.5));
        String legType = "none";
        if (this.parameters.getLegType() == null) {
            Bearing bearRCWind = wndStart.getBearing().getDifferenceTo(bearVrt);
            legType = "downwind";
            this.upwindLeg = false;
            if (Math.abs(bearRCWind.getDegrees()) > 90.0 && Math.abs(bearRCWind.getDegrees()) < 270.0) {
                legType = "upwind";
                this.upwindLeg = true;
            }
        } else if (this.parameters.getLegType() == LegType.UPWIND) {
            legType = "upwind";
            this.upwindLeg = true;
        } else {
            legType = "downwind";
            this.upwindLeg = false;
        }
        if (this.debugMsgOn) {
            System.out.println("start : " + startPos.getLatDeg() + ", " + startPos.getLngDeg());
            System.out.println("middle: " + middlePos.getLatDeg() + ", " + middlePos.getLngDeg());
            System.out.println("end   : " + endPos.getLatDeg() + ", " + endPos.getLngDeg());
        }
        logger.fine("Leg Direction: " + legType);
        long turnLoss = polarDiagram.getTurnLoss();
        if (!this.upwindLeg) {
            turnLoss /= 2L;
        }
        logger.fine("Turnloss :" + turnLoss);
        this.usedTimeStep = this.parameters.getSimuStep() != null && this.parameters.getSimuStep().asMillis() > turnLoss + 1000L ? this.parameters.getSimuStep().asMillis() : turnLoss + 1000L;
        logger.fine("Time step :" + this.usedTimeStep);
        ArrayList<PathCandidate> initPaths = new ArrayList<PathCandidate>();
        ArrayList<PathCandidate> allPaths = new ArrayList<PathCandidate>();
        ArrayList<PathCandidate> trgPaths = new ArrayList<PathCandidate>();
        List<Position> startLine = this.parameters.getStartLine();
        if (startLine != null && startLine.size() > 2) {
            startLine = null;
        }
        if (startLine == null) {
            PathCandidate initPath = new PathCandidate(new TimedPositionImpl(currentTime, currentPosition), false, 0.0, 0.0, 0, "0", '0', wndStart, startPos);
            initPaths.add(initPath);
        } else {
            Position startPositionRight;
            Position startPositionLeft;
            Bearing bearLine = startLine.get(0).getBearingGreatCircle(startLine.get(1));
            double diffLineVrt = bearVrt.getDifferenceTo(bearLine).getDegrees();
            if (diffLineVrt > 0.0 && diffLineVrt < 180.0) {
                startPositionLeft = startLine.get(0);
                startPositionRight = startLine.get(1);
            } else {
                startPositionLeft = startLine.get(1);
                startPositionRight = startLine.get(0);
            }
            if (startLine.size() == 2) {
                if (this.maxTurns == 1 && this.initPathStr.length() > 1) {
                    PathCandidate initPath = this.initPathStr.charAt(1) == 'L' ? new PathCandidate(new TimedPositionImpl(currentTime, startPositionLeft), false, 0.0, 0.0, 0, "0", '0', wndStart, startPositionLeft) : new PathCandidate(new TimedPositionImpl(currentTime, startPositionRight), false, 0.0, 0.0, 0, "0", '0', wndStart, startPositionRight);
                    initPaths.add(initPath);
                } else {
                    Bearing bearStartLine = startPositionLeft.getBearingGreatCircle(startPositionRight);
                    int nParts = 10;
                    int idx = 0;
                    while (idx <= nParts) {
                        Distance deltaStartLine = startPositionLeft.getDistance(startPositionRight).scale((double)idx / (double)nParts);
                        Position tmpPosition = startPositionLeft.translateGreatCircle(bearStartLine, deltaStartLine);
                        Wind tmpWind = wf.getWind(new TimedPositionWithSpeedImpl(currentTime, tmpPosition, null));
                        PathCandidate initPath = new PathCandidate(new TimedPositionImpl(currentTime, tmpPosition), false, 0.0, 0.0, 0, "0", '0', tmpWind, tmpPosition);
                        initPaths.add(initPath);
                        ++idx;
                    }
                }
            }
        }
        if (this.initPathStr.length() > 1) {
            String initPathStrCaps = this.initPathStr.toUpperCase();
            if (!this.upwindLeg) {
                initPathStrCaps = initPathStrCaps.replace('L', 'r');
                initPathStrCaps = initPathStrCaps.replace('R', 'l');
            }
            for (PathCandidate cand : initPaths) {
                char nextDirection = '0';
                PathCandidate tmpCand1 = cand;
                int idx = 1;
                while (idx < initPathStrCaps.length()) {
                    nextDirection = initPathStrCaps.charAt(idx);
                    tmpCand1 = this.getPathCandWind(tmpCand1, nextDirection, this.usedTimeStep, turnLoss, startPos, endPos, distStartEndMeters);
                    ++idx;
                }
                allPaths.add(tmpCand1);
            }
        } else {
            allPaths = initPaths;
        }
        TimedPosition tstPosition = this.getStep(new TimedPositionImpl(startTime, startPos), wndStart, endPos, this.usedTimeStep, turnLoss, true, this.upwindLeg ? (char)'L' : 'l');
        double tstDist1 = startPos.getDistance(tstPosition.getPosition()).getMeters();
        tstPosition = this.getStep(new TimedPositionImpl(startTime, startPos), wndStart, endPos, this.usedTimeStep, turnLoss, true, this.upwindLeg ? (char)'R' : 'r');
        double tstDist2 = startPos.getDistance(tstPosition.getPosition()).getMeters();
        double hrzBinSize = (tstDist1 + tstDist2) / 6.0;
        if (this.debugMsgOn) {
            System.out.println("Horizontal Bin Size: " + hrzBinSize);
        }
        this.endMatchCriterion = this.endLineWidth != null ? (int)Math.round(this.endLineWidth.getMeters() / hrzBinSize) / 2 : 0;
        boolean reachedEnd = false;
        int addSteps = 0;
        int finalSteps = 0;
        while (!reachedEnd || addSteps < finalSteps) {
            if (reachedEnd) {
                ++addSteps;
            }
            Util.Pair<List<PathCandidate>, List<PathCandidate>> newPaths = this.generateCandidate(allPaths, this.usedTimeStep, turnLoss, startPos, middlePos, endPos, distStartEndMeters);
            List<PathCandidate> leftPaths = this.filterCandidates((List)newPaths.getA(), hrzBinSize / 2.0);
            List<PathCandidate> rightPaths = this.filterCandidates((List)newPaths.getB(), hrzBinSize / 2.0);
            ArrayList<PathCandidate> nextPaths = new ArrayList<PathCandidate>();
            nextPaths.addAll(leftPaths);
            nextPaths.addAll(rightPaths);
            allPaths = nextPaths;
            if (this.gridStore) {
                this.gridPositions.add(allPaths);
                List<PathCandidate> list = this.filterIsochrone(allPaths, hrzBinSize);
                this.isocPositions.add(list);
            }
            if (allPaths.size() > 0) {
                for (PathCandidate pathCandidate : allPaths) {
                    int curBin;
                    if (!pathCandidate.reached || Math.abs(curBin = (int)Math.round(Math.floor((pathCandidate.hrz + hrzBinSize / 2.0) / hrzBinSize))) > this.endMatchCriterion) continue;
                    reachedEnd = true;
                    trgPaths.add(pathCandidate);
                }
            } else {
                reachedEnd = true;
            }
            if (!this.isTimedOut()) continue;
            reachedEnd = true;
        }
        if (this.gridStore) {
            String outStr;
            BufferedWriter outputCSV;
            double distResolution = distStartEndMeters * 0.01;
            try {
                outputCSV = new BufferedWriter(new FileWriter(String.valueOf(this.gridFile) + "-grid.csv"));
                outputCSV.write("step; lat; lng; time; side; path; vrt\n");
                outputCSV.write("0; " + startPos.getLatDeg() + "; " + startPos.getLngDeg() + "; " + startTime.asMillis() / 1000L + "; 0; 0; " + -distStartEndMeters + "\n");
                outputCSV.write("0; " + endPos.getLatDeg() + "; " + endPos.getLngDeg() + "; " + startTime.asMillis() / 1000L + "; 0; 0; 0\n");
                int stepCount = 0;
                for (List list : this.gridPositions) {
                    ++stepCount;
                    PathCandidate prevPos = null;
                    for (PathCandidate isoPos : list) {
                        if (prevPos != null && prevPos.pos.getPosition().getDistance(isoPos.pos.getPosition()).getMeters() < distResolution) continue;
                        outStr = stepCount + "; " + isoPos.pos.getPosition().getLatDeg() + "; " + isoPos.pos.getPosition().getLngDeg() + "; " + isoPos.pos.getTimePoint().asMillis() / 1000L + "; " + isoPos.sid;
                        outStr = String.valueOf(outStr) + "; " + isoPos.path + "; " + isoPos.vrt;
                        outStr = String.valueOf(outStr) + "\n";
                        outputCSV.write(outStr);
                        prevPos = isoPos;
                    }
                }
                outputCSV.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                outputCSV = new BufferedWriter(new FileWriter(String.valueOf(this.gridFile) + "-isoc.csv"));
                outputCSV.write("step; lat; lng; time; side; path; vrt\n");
                outputCSV.write("0; " + startPos.getLatDeg() + "; " + startPos.getLngDeg() + "; " + startTime.asMillis() / 1000L + "; 0; 0; " + -distStartEndMeters + "\n");
                outputCSV.write("0; " + endPos.getLatDeg() + "; " + endPos.getLngDeg() + "; " + startTime.asMillis() / 1000L + "; 0; 0; 0\n");
                int stepCount = 0;
                for (List list : this.isocPositions) {
                    ++stepCount;
                    PathCandidate prevPos = null;
                    for (PathCandidate isoPos : list) {
                        if (prevPos != null && prevPos.pos.getPosition().getDistance(isoPos.pos.getPosition()).getMeters() < distResolution) continue;
                        outStr = stepCount + "; " + isoPos.pos.getPosition().getLatDeg() + "; " + isoPos.pos.getPosition().getLngDeg() + "; " + isoPos.pos.getTimePoint().asMillis() / 1000L + "; " + isoPos.sid;
                        outStr = String.valueOf(outStr) + "; " + isoPos.path + "; " + isoPos.vrt;
                        outStr = String.valueOf(outStr) + "\n";
                        outputCSV.write(outStr);
                        prevPos = isoPos;
                    }
                }
                outputCSV.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (trgPaths.size() == 0) {
            TimedPositionWithSpeedImpl curPosition = new TimedPositionWithSpeedImpl(startTime, startPos, null);
            path.add(curPosition);
            return new PathImpl(path, (WindField)wf, true, false);
        }
        Collections.sort(trgPaths);
        for (PathCandidate curPath : trgPaths) {
            logger.finest("\nPath: " + curPath.path + " (" + curPath.trn + ")\n      Time: " + (curPath.pos.getTimePoint().asMillis() - startTime.asMillis()) + ", Height: " + curPath.vrt + " of " + (double)Math.round(startPos.getDistance(endPos).getMeters() * 100.0) / 100.0 + ", Dist: " + curPath.hrz + "m ~ " + (double)Math.round(curPath.pos.getPosition().getDistance(endPos).getMeters() * 100.0) / 100.0 + "m");
        }
        this.bestCand = (PathCandidate)trgPaths.get(0);
        long endTime = this.bestCand.pos.getTimePoint().asMillis();
        TimedPositionWithSpeedImpl curPosition = null;
        char nextDirection = '0';
        int n = 48;
        int step = 0;
        while (step < this.bestCand.path.length() - 1) {
            char c;
            nextDirection = this.bestCand.path.charAt(step);
            if (nextDirection == '0') {
                curPosition = new TimedPositionWithSpeedImpl(startTime, this.bestCand.start, null);
                path.add(curPosition);
            } else {
                boolean sameBaseDirection = this.isSameDirection(c, nextDirection);
                Wind curWind = wf.getWind(curPosition);
                TimedPosition newPosition = this.getStep(curPosition, curWind, endPos, this.usedTimeStep, turnLoss, sameBaseDirection, nextDirection);
                if (newPosition.getTimePoint().asMillis() < endTime) {
                    curPosition = new TimedPositionWithSpeedImpl(newPosition.getTimePoint(), newPosition.getPosition(), null);
                    path.add(curPosition);
                }
            }
            c = nextDirection;
            ++step;
        }
        path.add(new TimedPositionWithSpeedImpl(this.bestCand.pos.getTimePoint(), this.bestCand.pos.getPosition(), null));
        boolean containsTacks = this.bestCand.path.contains("L") || this.bestCand.path.contains("R");
        boolean containsJibes = this.bestCand.path.contains("l") || this.bestCand.path.contains("r");
        long maxTurnTime = 0L;
        if (this.maxTurns == 1) {
            int turnMiddle = 1000;
            if (this.bestCand != null) {
                turnMiddle = this.bestCand.path.charAt(1) == (this.upwindLeg ? (char)'L' : 'l') ? this.bestCand.getIndexOfTurnLR() : this.bestCand.getIndexOfTurnRL();
                maxTurnTime = (long)turnMiddle * this.usedTimeStep;
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.bestCand.pos.getTimePoint().asMillis() - startTime.asMillis());
        SimpleDateFormat racetimeFormat = new SimpleDateFormat("HH:mm:ss:SSS");
        racetimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String racetimeFormatted = racetimeFormat.format(cal.getTime());
        logger.fine("Start Condition: " + this.initPathStr + "\nPath: " + this.bestCand.path + "\n      Time: " + racetimeFormatted + ", Distance: " + String.format("%.2f", (double)Math.round(this.bestCand.pos.getPosition().getDistance(endPos).getMeters() * 100.0) / 100.0) + " meters" + ", " + this.bestCand.trn + " Turn" + (this.bestCand.trn > 1 ? "s" : ""));
        return new PathImpl(path, wf, maxTurnTime, this.algorithmTimedOut, containsTacks && containsJibes && this.maxTurns == 1);
    }

    class SortPathCandsAbsHorizontally
    implements Comparator<PathCandidate> {
        SortPathCandsAbsHorizontally() {
        }

        @Override
        public int compare(PathCandidate p1, PathCandidate p2) {
            if (Math.abs(p1.hrz) == Math.abs(p2.hrz)) {
                return 0;
            }
            return Math.abs(p1.hrz) < Math.abs(p2.hrz) ? -1 : 1;
        }
    }

    class SortPathCandsHorizontally
    implements Comparator<PathCandidate> {
        SortPathCandsHorizontally() {
        }

        @Override
        public int compare(PathCandidate p1, PathCandidate p2) {
            if (p1.hrz == p2.hrz) {
                return 0;
            }
            return p1.hrz < p2.hrz ? -1 : 1;
        }
    }
}

