/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.shared;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.HashMap;
import java.util.Map;

public class DashboardLiveRaceProvider {
    private Map<String, TrackedRace> liveRaceForLeaderboardNames = new HashMap();
    private RacingEventService racingEventService;

    public DashboardLiveRaceProvider(RacingEventService racingEventService) {
        this.racingEventService = racingEventService;
    }

    public void validateLiveRaceForLeaderboardName(String leaderboardName) {
        Leaderboard leaderboard = this.racingEventService.getLeaderboardByName(leaderboardName);
        TrackedRace liveRace = null;
        if (leaderboard != null) {
            for (RaceColumn column : leaderboard.getRaceColumns()) {
                for (Fleet fleet : column.getFleets()) {
                    TrackedRace race = column.getTrackedRace(fleet);
                    if (race == null || !race.isLive(MillisecondsTimePoint.now())) continue;
                    liveRace = race;
                }
            }
        }
        if (liveRace != null) {
            this.setLiveRaceForLeaderboardName(leaderboardName, liveRace);
        }
    }

    public TrackedRace getLiveRaceForLeaderboardName(String leaderboardName) {
        return (TrackedRace)this.liveRaceForLeaderboardNames.get(leaderboardName);
    }

    private void setLiveRaceForLeaderboardName(String leaderboardName, TrackedRace liveRace) {
        if (this.liveRaceForLeaderboardNames.containsKey(leaderboardName)) {
            this.liveRaceForLeaderboardNames.remove(leaderboardName);
        }
        this.liveRaceForLeaderboardNames.put(leaderboardName, liveRace);
    }
}

