/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.server.util.actions.startlineadvantage.precalculation;

import com.sap.sailing.dashboards.gwt.server.util.actions.startlineadvantage.DefaultPolarValues;
import com.sap.sailing.dashboards.gwt.server.util.actions.startlineadvantage.precalculation.StartlineAdvantageCalculationData;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.shared.tracking.LineDetails;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.Iterator;

public class StartlineAdvantageCalculationDataRetriever {
    private PolarDataService polarDataService;
    private final DomainFactory domainFactory;

    public StartlineAdvantageCalculationDataRetriever(DomainFactory domainFactory, PolarDataService polarDataService) {
        this.polarDataService = polarDataService;
        this.domainFactory = domainFactory;
    }

    public StartlineAdvantageCalculationData retrieveDataForTrackedRace(TrackedRace trackedRace) {
        StartlineAdvantageCalculationData result = null;
        Position startBoatPosition = null;
        Position pinEndPosition = null;
        Position firstMarkPosition = null;
        Double startlineAdvantageAtPinEndInMeters = null;
        Double startlineLenghtInMeters = null;
        Wind wind = null;
        Double maneuverAngle = null;
        Util.Pair startlineMarkPositions = this.retrieveStartlineMarksPositions(trackedRace);
        startBoatPosition = (Position)startlineMarkPositions.getA();
        pinEndPosition = (Position)startlineMarkPositions.getB();
        firstMarkPosition = this.retrieveFirstMarkPosition(trackedRace);
        startlineAdvantageAtPinEndInMeters = this.retrieveStartlineAdvantage(trackedRace);
        startlineLenghtInMeters = this.retrieveStartlineLenght(trackedRace);
        wind = this.retrieveWindAtPosition(startBoatPosition, trackedRace);
        maneuverAngle = this.retrieveManouvreAngleAtWindSpeedAndBoatClass(this.domainFactory.getOrCreateBoatClass("Extreme 40"), ManeuverType.TACK, (Speed)wind);
        result = new StartlineAdvantageCalculationData(startBoatPosition, pinEndPosition, firstMarkPosition, startlineAdvantageAtPinEndInMeters, startlineLenghtInMeters, wind, maneuverAngle);
        return result;
    }

    private Position retrieveFirstMarkPosition(TrackedRace trackedRace) {
        Waypoint firstmarkWayPoint;
        Position result = null;
        Course course = trackedRace.getRace().getCourse();
        if (course != null && (firstmarkWayPoint = course.getFirstLeg().getTo()) != null) {
            result = this.retrieveFirstMarkPositionFromFirstMarkWayPoint(firstmarkWayPoint, trackedRace);
        }
        return result;
    }

    private Util.Pair<Position, Position> retrieveStartlineMarksPositions(TrackedRace trackedRace) {
        Util.Pair result = new Util.Pair(null, null);
        Course course = trackedRace.getRace().getCourse();
        if (course != null) {
            Waypoint startlineWayPoint = course.getFirstLeg().getFrom();
            Waypoint firstmarkWayPoint = course.getFirstLeg().getTo();
            if (startlineWayPoint != null && firstmarkWayPoint != null) {
                result = this.retrieveStartlineMarkPositionsFromStartLineWayPoint(startlineWayPoint, trackedRace);
            }
        }
        return result;
    }

    private Util.Pair<Position, Position> retrieveStartlineMarkPositionsFromStartLineWayPoint(Waypoint startLineWayPoint, TrackedRace trackedRace) {
        Util.Pair result = null;
        Iterator markIterator = startLineWayPoint.getMarks().iterator();
        if (markIterator.hasNext()) {
            Mark startboat = (Mark)markIterator.next();
            if (markIterator.hasNext()) {
                Mark pinEnd = (Mark)markIterator.next();
                TimePoint now = MillisecondsTimePoint.now();
                Position startBoatPosition = this.getPositionFromMarkAtTimePoint(trackedRace, startboat, now);
                Position pinEndPosition = this.getPositionFromMarkAtTimePoint(trackedRace, pinEnd, now);
                result = new Util.Pair((Object)startBoatPosition, (Object)pinEndPosition);
            }
        }
        return result;
    }

    private Position retrieveFirstMarkPositionFromFirstMarkWayPoint(Waypoint firstMarkWayPoint, TrackedRace trackedRace) {
        Position result = null;
        if (firstMarkWayPoint.getMarks().iterator().hasNext()) {
            Mark firstMark = (Mark)firstMarkWayPoint.getMarks().iterator().next();
            TimePoint now = MillisecondsTimePoint.now();
            result = this.getPositionFromMarkAtTimePoint(trackedRace, firstMark, now);
        }
        return result;
    }

    private Position getPositionFromMarkAtTimePoint(TrackedRace trackedRace, Mark mark, TimePoint timePoint) {
        GPSFixTrack fixTrack = trackedRace.getTrack(mark);
        return fixTrack.getEstimatedPosition(timePoint, true);
    }

    private Double retrieveStartlineAdvantage(TrackedRace trackedRace) {
        Double result = null;
        LineDetails startline = trackedRace.getStartLine(MillisecondsTimePoint.now());
        if (startline != null && startline.getAdvantage() != null) {
            result = startline.getAdvantage().getMeters();
        }
        return result;
    }

    private Double retrieveStartlineLenght(TrackedRace trackedRace) {
        Double result = null;
        LineDetails startline = trackedRace.getStartLine(MillisecondsTimePoint.now());
        result = startline.getLength().getMeters();
        return result;
    }

    private Wind retrieveWindAtPosition(Position position, TrackedRace trackedRace) {
        Wind result = null;
        result = trackedRace.getWind(position, MillisecondsTimePoint.now());
        return result;
    }

    private Double retrieveManouvreAngleAtWindSpeedAndBoatClass(BoatClass boatClass, ManeuverType maneuverType, Speed windSpeed) {
        Double result = DefaultPolarValues.getManouvreAngle((ManeuverType)ManeuverType.TACK);
        try {
            if (boatClass != null && maneuverType != null && windSpeed != null) {
                BearingWithConfidence bearingWithConfidence = this.polarDataService.getManeuverAngle(boatClass, maneuverType, windSpeed);
                result = ((Bearing)bearingWithConfidence.getObject()).getDegrees();
            }
        }
        catch (NotEnoughDataHasBeenAddedException | NullPointerException e) {
            e.printStackTrace();
        }
        return result;
    }
}

