/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.server.util.actions.startlineadvantage;

import com.sap.sailing.dashboards.gwt.server.util.actions.startlineadvantage.DefaultPolarWindAngleBoatSpeedFunction;
import com.sap.sailing.dashboards.gwt.server.util.actions.startlineadvantage.precalculation.StartlineAdvantageCalculationData;
import com.sap.sailing.dashboards.gwt.server.util.actions.startlineadvantage.precalculation.StartlineAdvantageCalculationDataRetriever;
import com.sap.sailing.dashboards.gwt.shared.dispatch.DashboardDispatchContext;
import com.sap.sailing.dashboards.gwt.shared.dto.StartLineAdvantageDTO;
import com.sap.sailing.dashboards.gwt.shared.dto.StartlineAdvantagesWithMaxAndAverageDTO;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartlineAdvantagesByWindCalculator {
    private StartlineAdvantageCalculationDataRetriever startlineAdvantageCalculationDataRetriever;
    private DashboardDispatchContext dashboardDispatchContext;
    private DomainFactory domainFactory;
    private DefaultPolarWindAngleBoatSpeedFunction defaultPolarSpeedWindAngleFunction;
    private final Logger logger = Logger.getLogger(StartlineAdvantagesByWindCalculator.class.getName());

    public StartlineAdvantagesByWindCalculator(DashboardDispatchContext dashboardDispatchContext, DomainFactory domainFactory) {
        this.dashboardDispatchContext = dashboardDispatchContext;
        this.domainFactory = domainFactory;
        this.defaultPolarSpeedWindAngleFunction = new DefaultPolarWindAngleBoatSpeedFunction();
        this.startlineAdvantageCalculationDataRetriever = new StartlineAdvantageCalculationDataRetriever(domainFactory, dashboardDispatchContext.getPolarDataService());
    }

    public StartlineAdvantagesWithMaxAndAverageDTO getStartLineAdvantagesAccrossLineFromTrackedRaceAtTimePoint(TrackedRace trackedRace, TimePoint timepoint) {
        StartlineAdvantagesWithMaxAndAverageDTO result = new StartlineAdvantagesWithMaxAndAverageDTO();
        if (trackedRace != null) {
            StartlineAdvantageCalculationData startlineAdvantageCalculationData = this.startlineAdvantageCalculationDataRetriever.retrieveDataForTrackedRace(trackedRace);
            if (startlineAdvantageCalculationData.getWind() != null) {
                Util.Pair startlineAdvantagesAndConfidencesAsArray = null;
                if (this.isStartlineCompletelyUnderneathLaylines(startlineAdvantageCalculationData)) {
                    this.logger.log(Level.INFO, "Startline is completely underneath laylines");
                    Util.Pair advantagesRange = new Util.Pair((Object)0.0, (Object)startlineAdvantageCalculationData.getStartlineLenghtInMeters());
                    List startlineAdvantages = this.calculateStartlineAdvantagesUnderneathLaylinesInRange(advantagesRange, startlineAdvantageCalculationData);
                    double maximum = this.getMaximumAdvantageOfStartlineAdvantageDTOs(startlineAdvantages);
                    result.maximum = maximum;
                    startlineAdvantagesAndConfidencesAsArray = this.convertStartLineAdvantageDTOListToPointAndConfidenceArrays(startlineAdvantages);
                } else if (this.isStartlineCompletelyAboveLaylines(startlineAdvantageCalculationData)) {
                    this.logger.log(Level.INFO, "Startline is completely above laylines");
                    Util.Pair advantagesRange = new Util.Pair((Object)0.0, (Object)startlineAdvantageCalculationData.getStartlineLenghtInMeters());
                    List startlineAdvantages = this.calculatePolarBasedStartlineAdvantagesInRange(advantagesRange, startlineAdvantageCalculationData);
                    this.subtractMinimumOfAllStartlineAdvantages(startlineAdvantages);
                    double maximum = this.getMaximumAdvantageOfStartlineAdvantageDTOs(startlineAdvantages);
                    result.maximum = maximum;
                    this.subtractAgainstMaximumOfAllStartlineAdvantages(startlineAdvantages, maximum);
                    startlineAdvantagesAndConfidencesAsArray = this.convertStartLineAdvantageDTOListToPointAndConfidenceArrays(startlineAdvantages);
                } else {
                    this.logger.log(Level.INFO, "Layline(s) cross startline");
                    Position intersectionOfRightLaylineAndStartline = this.getIntersectionOfRightLaylineAndStartline(startlineAdvantageCalculationData);
                    Position intersectionOfleftLaylineAndStartline = this.getIntersectionOfLeftLaylineAndStartline(startlineAdvantageCalculationData);
                    Util.Pair polarBasedStartlineAdvatagesRange = this.getStartAndEndPointOfPolarBasedStartlineAdvatagesInDistancesToRCBoat(intersectionOfRightLaylineAndStartline, intersectionOfleftLaylineAndStartline, startlineAdvantageCalculationData);
                    Util.Pair pinEndStartlineAdvatagesRange = this.getPinEndStartlineAdvantagesRangeFromPolarAdvantagesRange(polarBasedStartlineAdvatagesRange, startlineAdvantageCalculationData);
                    List startlineAdvantages = this.calculatePolarBasedStartlineAdvantagesInRange(polarBasedStartlineAdvatagesRange, startlineAdvantageCalculationData);
                    this.subtractMinimumOfAllStartlineAdvantages(startlineAdvantages);
                    double maximum = this.getMaximumAdvantageOfStartlineAdvantageDTOs(startlineAdvantages);
                    result.maximum = maximum;
                    this.subtractAgainstMaximumOfAllStartlineAdvantages(startlineAdvantages, maximum);
                    this.addClosingZeroPointToMixedAdvantages(startlineAdvantages, pinEndStartlineAdvatagesRange);
                    startlineAdvantagesAndConfidencesAsArray = this.convertStartLineAdvantageDTOListToPointAndConfidenceArrays(startlineAdvantages);
                }
                if (startlineAdvantagesAndConfidencesAsArray != null) {
                    result.distanceToRCBoatToStartlineAdvantage = (Number[][])startlineAdvantagesAndConfidencesAsArray.getA();
                    result.distanceToRCBoatToConfidence = (Number[][])startlineAdvantagesAndConfidencesAsArray.getB();
                }
            }
        } else {
            this.logger.log(Level.INFO, "No live race available for startlineadvantages calculation");
        }
        return result;
    }

    private boolean isBearingAboveAdvantageLines(Bearing bearing, StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        boolean result = false;
        DegreeBearingImpl bearingOfRightLaylineInDeg = new DegreeBearingImpl(startlineAdvantageCalculationData.getWind().getBearing().getDegrees() - startlineAdvantageCalculationData.getManeuverAngle() / 2.0);
        DegreeBearingImpl bearingOfLeftLaylineInDeg = new DegreeBearingImpl(startlineAdvantageCalculationData.getWind().getBearing().getDegrees() + startlineAdvantageCalculationData.getManeuverAngle() / 2.0);
        if (bearing.getDegrees() < bearingOfRightLaylineInDeg.getDegrees() && bearing.getDegrees() > 0.0 || bearing.getDegrees() > bearingOfLeftLaylineInDeg.getDegrees() && bearing.getDegrees() < 360.0) {
            result = true;
        }
        return result;
    }

    private boolean isBearingUnderneathAdvantageLines(Bearing bearing, StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        boolean result = false;
        DegreeBearingImpl bearingOfRightLaylineInDeg = new DegreeBearingImpl(startlineAdvantageCalculationData.getWind().getBearing().getDegrees() - startlineAdvantageCalculationData.getManeuverAngle() / 2.0);
        DegreeBearingImpl bearingOfLeftLaylineInDeg = new DegreeBearingImpl(startlineAdvantageCalculationData.getWind().getBearing().getDegrees() + startlineAdvantageCalculationData.getManeuverAngle() / 2.0);
        this.logger.log(Level.INFO, "Underneath bearingOfRightLaylineInDeg?" + bearingOfRightLaylineInDeg);
        this.logger.log(Level.INFO, "Underneath bearingOfLeftLaylineInDeg?" + bearingOfLeftLaylineInDeg);
        if (bearing.getDegrees() > bearingOfRightLaylineInDeg.getDegrees() && bearing.getDegrees() < bearingOfLeftLaylineInDeg.getDegrees()) {
            result = true;
        }
        return result;
    }

    private boolean isStartlineCompletelyAboveLaylines(StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        boolean result = false;
        DegreeBearingImpl bearingRCBoatToFirstMark = new DegreeBearingImpl(startlineAdvantageCalculationData.getFirstMarkPosition().getBearingGreatCircle(startlineAdvantageCalculationData.getStartBoatPosition()).getDegrees());
        DegreeBearingImpl bearingPinEndToFirstMark = new DegreeBearingImpl(startlineAdvantageCalculationData.getFirstMarkPosition().getBearingGreatCircle(startlineAdvantageCalculationData.getPinEndPosition()).getDegrees());
        if (this.isBearingAboveAdvantageLines((Bearing)bearingRCBoatToFirstMark, startlineAdvantageCalculationData) && this.isBearingAboveAdvantageLines((Bearing)bearingPinEndToFirstMark, startlineAdvantageCalculationData)) {
            result = true;
        }
        return result;
    }

    private boolean isStartlineCompletelyUnderneathLaylines(StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        boolean result = false;
        DegreeBearingImpl bearingFirstMarkToRCBoat = new DegreeBearingImpl(startlineAdvantageCalculationData.getFirstMarkPosition().getBearingGreatCircle(startlineAdvantageCalculationData.getStartBoatPosition()).getDegrees());
        DegreeBearingImpl bearingFirstMarkToPinEnd = new DegreeBearingImpl(startlineAdvantageCalculationData.getFirstMarkPosition().getBearingGreatCircle(startlineAdvantageCalculationData.getPinEndPosition()).getDegrees());
        this.logger.log(Level.INFO, "Underneath RC?" + bearingFirstMarkToRCBoat);
        this.logger.log(Level.INFO, "Underneath PIN?" + bearingFirstMarkToPinEnd);
        if (this.isBearingUnderneathAdvantageLines((Bearing)bearingFirstMarkToRCBoat, startlineAdvantageCalculationData) && this.isBearingUnderneathAdvantageLines((Bearing)bearingFirstMarkToPinEnd, startlineAdvantageCalculationData)) {
            result = true;
        }
        return result;
    }

    private Util.Pair<Double, Double> getStartAndEndPointOfPolarBasedStartlineAdvatagesInDistancesToRCBoat(Position rightIntersection, Position leftIntersection, StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        Util.Pair result = null;
        if (rightIntersection != null && leftIntersection == null) {
            double distanceFromIntersectionToRCBoatInMeters = rightIntersection.getDistance(startlineAdvantageCalculationData.getStartBoatPosition()).getMeters();
            result = new Util.Pair((Object)0.0, (Object)distanceFromIntersectionToRCBoatInMeters);
        } else if (rightIntersection == null && leftIntersection != null) {
            double distanceFromIntersectionToRCBoatInMeters = leftIntersection.getDistance(startlineAdvantageCalculationData.getStartBoatPosition()).getMeters();
            result = new Util.Pair((Object)distanceFromIntersectionToRCBoatInMeters, (Object)startlineAdvantageCalculationData.getStartlineLenghtInMeters());
        } else if (rightIntersection != null && leftIntersection != null) {
            result = new Util.Pair((Object)0.0, (Object)startlineAdvantageCalculationData.getStartlineLenghtInMeters());
        }
        return result;
    }

    private Position getIntersectionOfRightLaylineAndStartline(StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        Position result = null;
        DegreeBearingImpl bearingOfRightLaylineInDeg = new DegreeBearingImpl(startlineAdvantageCalculationData.getWind().getBearing().getDegrees() - startlineAdvantageCalculationData.getManeuverAngle() / 2.0);
        result = this.calculateIntersectionPointsOfStartlineAndLaylineWithBearing((Bearing)bearingOfRightLaylineInDeg, startlineAdvantageCalculationData);
        return result;
    }

    private Position getIntersectionOfLeftLaylineAndStartline(StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        Position result = null;
        DegreeBearingImpl bearingOfRightLaylineInDeg = new DegreeBearingImpl(startlineAdvantageCalculationData.getWind().getBearing().getDegrees() + startlineAdvantageCalculationData.getManeuverAngle() / 2.0);
        result = this.calculateIntersectionPointsOfStartlineAndLaylineWithBearing((Bearing)bearingOfRightLaylineInDeg, startlineAdvantageCalculationData);
        return result;
    }

    private Position calculateIntersectionPointsOfStartlineAndLaylineWithBearing(Bearing bearing, StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        Position result = null;
        Bearing bearingOfStartlineInRad = startlineAdvantageCalculationData.getStartBoatPosition().getBearingGreatCircle(startlineAdvantageCalculationData.getPinEndPosition());
        DegreeBearingImpl bearingOfStartlineInDeg = new DegreeBearingImpl(bearingOfStartlineInRad.getDegrees());
        this.logger.log(Level.INFO, "bearingOfStartlineInDeg " + bearingOfStartlineInDeg);
        this.logger.log(Level.INFO, "bearingOfLaylineInDeg " + bearing);
        Position intersectionPointLaylineStartline = startlineAdvantageCalculationData.getFirstMarkPosition().getIntersection(bearing, startlineAdvantageCalculationData.getPinEndPosition(), (Bearing)bearingOfStartlineInDeg);
        this.logger.log(Level.INFO, "rightIntersectionPointLaylineStartline " + intersectionPointLaylineStartline);
        DegreeBearingImpl bearingIntersectionPointToFirstMark = new DegreeBearingImpl(startlineAdvantageCalculationData.getFirstMarkPosition().getBearingGreatCircle(intersectionPointLaylineStartline).getDegrees());
        if (bearingIntersectionPointToFirstMark.getDegrees() < bearing.getDegrees() + 1.0 && bearingIntersectionPointToFirstMark.getDegrees() > bearing.getDegrees() - 1.0 && this.isPositionOnStartline(intersectionPointLaylineStartline, startlineAdvantageCalculationData)) {
            result = intersectionPointLaylineStartline;
            this.logger.log(Level.INFO, "Layline crosses startline");
        }
        this.logger.log(Level.INFO, "bearingLeftIntersectionPointToFirstMark.getDegrees() " + bearingIntersectionPointToFirstMark.getDegrees());
        return result;
    }

    private boolean isPositionOnStartline(Position position, StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        boolean result = false;
        Distance distanceToStartline = position.getDistanceToLine(startlineAdvantageCalculationData.getStartBoatPosition(), startlineAdvantageCalculationData.getPinEndPosition());
        if (distanceToStartline.getMeters() < 1.0) {
            result = true;
        }
        return result;
    }

    private List<StartLineAdvantageDTO> addClosingZeroPointToMixedAdvantages(List<StartLineAdvantageDTO> advantages, Util.Pair<Double, Double> rangePinEndStartlineAdvantage) {
        StartLineAdvantageDTO startLineAdvantageDTO = new StartLineAdvantageDTO();
        startLineAdvantageDTO.confidence = 1.0;
        if ((Double)rangePinEndStartlineAdvantage.getA() > 0.0) {
            startLineAdvantageDTO.distanceToRCBoatInMeters = (Double)rangePinEndStartlineAdvantage.getB();
            startLineAdvantageDTO.startLineAdvantage = 0.0;
            advantages.add(startLineAdvantageDTO);
        } else {
            startLineAdvantageDTO.distanceToRCBoatInMeters = (Double)rangePinEndStartlineAdvantage.getA();
            startLineAdvantageDTO.startLineAdvantage = 0.0;
            advantages.add(0, startLineAdvantageDTO);
        }
        return advantages;
    }

    private Util.Pair<Double, Double> getPinEndStartlineAdvantagesRangeFromPolarAdvantagesRange(Util.Pair<Double, Double> rangePolarBasedStartlineAdvatages, StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        Util.Pair result = null;
        if ((Double)rangePolarBasedStartlineAdvatages.getA() == 0.0 && ((Double)rangePolarBasedStartlineAdvatages.getB()).doubleValue() != startlineAdvantageCalculationData.getStartlineLenghtInMeters().doubleValue()) {
            double pinEndStartlineAdvantagesStart = (Double)rangePolarBasedStartlineAdvatages.getB();
            double pinEndStartlineAdvantagesEnd = startlineAdvantageCalculationData.getStartlineLenghtInMeters();
            result = new Util.Pair((Object)pinEndStartlineAdvantagesStart, (Object)pinEndStartlineAdvantagesEnd);
        } else if ((Double)rangePolarBasedStartlineAdvatages.getA() != 0.0 && ((Double)rangePolarBasedStartlineAdvatages.getB()).doubleValue() == startlineAdvantageCalculationData.getStartlineLenghtInMeters().doubleValue()) {
            double pinEndStartlineAdvantagesStart = 0.0;
            double pinEndStartlineAdvantagesEnd = (Double)rangePolarBasedStartlineAdvatages.getB();
            result = new Util.Pair((Object)pinEndStartlineAdvantagesStart, (Object)pinEndStartlineAdvantagesEnd);
        }
        return result;
    }

    private List<StartLineAdvantageDTO> calculateStartlineAdvantagesUnderneathLaylinesInRange(Util.Pair<Double, Double> rangePinEndStartlineAdvantage, StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        ArrayList<StartLineAdvantageDTO> result = new ArrayList<StartLineAdvantageDTO>();
        if (rangePinEndStartlineAdvantage != null) {
            this.logger.log(Level.INFO, "PinEnd startline advantages range " + rangePinEndStartlineAdvantage.getA() + " - " + rangePinEndStartlineAdvantage.getB());
            StartLineAdvantageDTO rightEdgeAdvantage = new StartLineAdvantageDTO();
            rightEdgeAdvantage.confidence = 1.0;
            rightEdgeAdvantage.distanceToRCBoatInMeters = (Double)rangePinEndStartlineAdvantage.getA();
            StartLineAdvantageDTO leftEdgeAdvantage = new StartLineAdvantageDTO();
            leftEdgeAdvantage.confidence = 1.0;
            leftEdgeAdvantage.distanceToRCBoatInMeters = (Double)rangePinEndStartlineAdvantage.getB();
            if (startlineAdvantageCalculationData.getStartlineAdvantageAtPinEndInMeters() >= 0.0) {
                leftEdgeAdvantage.startLineAdvantage = startlineAdvantageCalculationData.getStartlineAdvantageAtPinEndInMeters();
                rightEdgeAdvantage.startLineAdvantage = 0.0;
            } else {
                leftEdgeAdvantage.startLineAdvantage = 0.0;
                rightEdgeAdvantage.startLineAdvantage = Math.abs(startlineAdvantageCalculationData.getStartlineAdvantageAtPinEndInMeters());
            }
            result.add(rightEdgeAdvantage);
            result.add(leftEdgeAdvantage);
        } else {
            this.logger.log(Level.INFO, "PinEnd startline advantages range null");
        }
        return result;
    }

    private Util.Pair<Number[][], Number[][]> convertStartLineAdvantageDTOListToPointAndConfidenceArrays(List<StartLineAdvantageDTO> startLineAdvantageDTOList) {
        Util.Pair result = null;
        if (startLineAdvantageDTOList != null && startLineAdvantageDTOList.size() > 0) {
            Number[][] distanceToRCBoatToStartlineAdvantage = new Number[startLineAdvantageDTOList.size()][2];
            Number[][] distanceToRCBoatToConfidence = new Number[startLineAdvantageDTOList.size()][2];
            int i = 0;
            while (i < startLineAdvantageDTOList.size()) {
                StartLineAdvantageDTO startLineAdvantageDTO = startLineAdvantageDTOList.get(i);
                distanceToRCBoatToStartlineAdvantage[i][0] = startLineAdvantageDTO.distanceToRCBoatInMeters;
                distanceToRCBoatToStartlineAdvantage[i][1] = startLineAdvantageDTO.startLineAdvantage;
                distanceToRCBoatToConfidence[i][0] = startLineAdvantageDTO.distanceToRCBoatInMeters;
                distanceToRCBoatToConfidence[i][1] = startLineAdvantageDTO.confidence;
                ++i;
            }
            result = new Util.Pair((Object)distanceToRCBoatToStartlineAdvantage, (Object)distanceToRCBoatToConfidence);
        }
        return result;
    }

    private List<StartLineAdvantageDTO> calculatePolarBasedStartlineAdvantagesInRange(Util.Pair<Double, Double> rangePinEndStartlineAdvantage, StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        ArrayList<StartLineAdvantageDTO> result = new ArrayList<StartLineAdvantageDTO>();
        if (rangePinEndStartlineAdvantage != null) {
            this.logger.log(Level.INFO, "PolarBased startline advantages range " + rangePinEndStartlineAdvantage.getA() + " - " + rangePinEndStartlineAdvantage.getB());
            Bearing bearingOfStartlineInRad = startlineAdvantageCalculationData.getStartBoatPosition().getBearingGreatCircle(startlineAdvantageCalculationData.getPinEndPosition());
            DegreeBearingImpl bearingOfStartlineInDeg = new DegreeBearingImpl(bearingOfStartlineInRad.getDegrees());
            double i = (Double)rangePinEndStartlineAdvantage.getA();
            while (i < (Double)rangePinEndStartlineAdvantage.getB() - 1.0) {
                StartLineAdvantageDTO startlineAdvantage = new StartLineAdvantageDTO();
                startlineAdvantage.confidence = 0.5;
                startlineAdvantage.distanceToRCBoatInMeters = i;
                Position startingPosition = startlineAdvantageCalculationData.getStartBoatPosition().translateRhumb((Bearing)bearingOfStartlineInDeg, (Distance)new MeterDistance(i));
                Distance startingPositionToFirstMarkDistance = startingPosition.getDistance(startlineAdvantageCalculationData.getFirstMarkPosition());
                Bearing bearingOfFirstMarkToStartPositionPositionInRad = startlineAdvantageCalculationData.getFirstMarkPosition().getBearingGreatCircle(startingPosition);
                DegreeBearingImpl bearingOfFirstMarkToStartPositionPositionInDeg = new DegreeBearingImpl(bearingOfFirstMarkToStartPositionPositionInRad.getDegrees());
                DegreeBearingImpl angleToWind = new DegreeBearingImpl(Math.abs(startlineAdvantageCalculationData.getWind().getBearing().getDifferenceTo((Bearing)bearingOfFirstMarkToStartPositionPositionInDeg).getDegrees()));
                this.logger.log(Level.INFO, "angleToWind" + angleToWind);
                SpeedWithConfidence speedWithConfidence = this.getBoatSpeedWithConfidenceForWindAngleAndStrength((Bearing)angleToWind, startlineAdvantageCalculationData);
                Speed speed = (Speed)speedWithConfidence.getObject();
                this.logger.log(Level.INFO, "Speed: " + speed.getKnots() + " Confidence: " + speedWithConfidence.getConfidence());
                this.logger.log(Level.INFO, "startingPositionToFirstMarkDistance.getMeters()" + startingPositionToFirstMarkDistance.getMeters());
                startlineAdvantage.startLineAdvantage = Math.abs(startingPositionToFirstMarkDistance.getMeters() / speed.getMetersPerSecond() * speed.getMetersPerSecond());
                result.add(startlineAdvantage);
                i += 1.0;
            }
        } else {
            this.logger.log(Level.INFO, "PinEnd startline advantages range null");
        }
        return result;
    }

    private List<StartLineAdvantageDTO> subtractAgainstMaximumOfAllStartlineAdvantages(List<StartLineAdvantageDTO> advantages, double maximum) {
        for (StartLineAdvantageDTO startLineAdvantageDTO : advantages) {
            startLineAdvantageDTO.startLineAdvantage = maximum - startLineAdvantageDTO.startLineAdvantage;
        }
        return advantages;
    }

    private List<StartLineAdvantageDTO> subtractMinimumOfAllStartlineAdvantages(List<StartLineAdvantageDTO> advantages) {
        double minimum = this.getMinimumAdvantageOfStartlineAdvantageDTOs(advantages);
        for (StartLineAdvantageDTO startLineAdvantageDTO : advantages) {
            startLineAdvantageDTO.startLineAdvantage = startLineAdvantageDTO.startLineAdvantage - minimum;
        }
        return advantages;
    }

    private Double getMaximumAdvantageOfStartlineAdvantageDTOs(List<StartLineAdvantageDTO> advantages) {
        Double result = null;
        ArrayList<StartLineAdvantageDTO> sortedAdvantages = new ArrayList<StartLineAdvantageDTO>();
        sortedAdvantages.addAll(advantages);
        if (sortedAdvantages != null && sortedAdvantages.size() > 0) {
            Collections.sort(sortedAdvantages, StartLineAdvantageDTO.startlineAdvantageComparatorByAdvantageDesc);
            result = (double)((StartLineAdvantageDTO)sortedAdvantages.get((int)0)).startLineAdvantage;
        }
        return result;
    }

    private double getMinimumAdvantageOfStartlineAdvantageDTOs(List<StartLineAdvantageDTO> advantages) {
        double result = 0.0;
        ArrayList<StartLineAdvantageDTO> sortedAdvantages = new ArrayList<StartLineAdvantageDTO>();
        sortedAdvantages.addAll(advantages);
        if (sortedAdvantages != null && sortedAdvantages.size() > 0) {
            Collections.sort(sortedAdvantages, StartLineAdvantageDTO.startlineAdvantageComparatorByAdvantageDesc);
            result = ((StartLineAdvantageDTO)sortedAdvantages.get((int)(sortedAdvantages.size() - 1))).startLineAdvantage;
        }
        return result;
    }

    private SpeedWithConfidence<Void> getBoatSpeedWithConfidenceForWindAngleAndStrength(Bearing angleToWind, StartlineAdvantageCalculationData startlineAdvantageCalculationData) {
        SpeedWithConfidence result = null;
        try {
            result = this.dashboardDispatchContext.getPolarDataService().getSpeed(this.domainFactory.getOrCreateBoatClass("Extreme 40"), (Speed)new KnotSpeedImpl(startlineAdvantageCalculationData.getWind().getBeaufort()), angleToWind);
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            result = this.defaultPolarSpeedWindAngleFunction.getBoatSpeedForWindAngleAndSpeed(angleToWind, (Speed)new KnotSpeedImpl(startlineAdvantageCalculationData.getWind().getBeaufort()));
            e.printStackTrace();
        }
        return result;
    }
}

