/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.server.util.actions.startanalysis;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.TimePoint;
import java.util.Iterator;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtIncompatible
public abstract class AbstractStartAnalysisCreationValidator {
    protected static int MINIMUM_MARKPASSIINGS_AT_FIRST_MARK = 3;
    protected static long MINIMUM_RACE_PROGRESSION_IN_MILLISECONDS = 360000L;

    protected static boolean threeCompetitorsPassedSecondWayPoint(TrackedRace trackedRace) {
        Waypoint secondWaypoint = trackedRace.getRace().getCourse().getFirstLeg().getTo();
        Iterator markPassingsInOrder = trackedRace.getMarkPassingsInOrder(secondWaypoint).iterator();
        int markPassingsCounter = 0;
        while (markPassingsInOrder.hasNext() && markPassingsCounter < MINIMUM_MARKPASSIINGS_AT_FIRST_MARK) {
            markPassingsInOrder.next();
            ++markPassingsCounter;
        }
        return markPassingsCounter >= MINIMUM_MARKPASSIINGS_AT_FIRST_MARK;
    }

    private static boolean competitorPassedSecondWayPoint(Competitor competitor, TrackedRace trackedRace) {
        Waypoint secondWaypoint = trackedRace.getRace().getCourse().getFirstLeg().getTo();
        return trackedRace.getMarkPassing(competitor, secondWaypoint) != null;
    }

    private static boolean gateStartGolfFlagIsDown(TrackedRace trackedRace) {
        if (trackedRace.getGateStartGolfDownTime() != 0L) {
            return true;
        }
        TimePoint timeStartOfRace = trackedRace.getStartOfRace();
        TimePoint timeNewestEvent = trackedRace.getTimePointOfNewestEvent();
        return timeStartOfRace != null && timeNewestEvent != null && timeStartOfRace.asMillis() + MINIMUM_RACE_PROGRESSION_IN_MILLISECONDS > timeNewestEvent.asMillis();
    }

    protected static boolean raceProgressedFarEnough(Competitor competitor, TrackedRace trackedRace) {
        Boolean isGateStart = trackedRace.isGateStart();
        if (isGateStart == Boolean.TRUE) {
            return AbstractStartAnalysisCreationValidator.gateStartGolfFlagIsDown((TrackedRace)trackedRace);
        }
        return AbstractStartAnalysisCreationValidator.competitorPassedSecondWayPoint((Competitor)competitor, (TrackedRace)trackedRace);
    }
}

