/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.widgets.windbot.compass;

import com.sap.sailing.dashboards.gwt.client.device.Compass;
import com.sap.sailing.dashboards.gwt.client.device.CompassListener;
import com.sap.sailing.dashboards.gwt.client.device.Location;
import com.sap.sailing.dashboards.gwt.client.device.LocationListener;
import com.sap.sailing.dashboards.gwt.client.device.Orientation;
import com.sap.sailing.dashboards.gwt.client.device.OrientationListener;
import com.sap.sailing.dashboards.gwt.client.device.OrientationType;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.compass.LocationPointerCompassAngleDistanceListener;
import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.List;

public class LocationPointerCompassAngleDistance
implements LocationListener,
CompassListener,
OrientationListener {
    private List<LocationPointerCompassAngleDistanceListener> listeners = new ArrayList();
    private double latDevice;
    private double lonDevice;
    private double latBot;
    private double lonBot;
    private double angle;
    private double compassHeading;
    private static Double degreesToRadiansFactor = Math.PI / 180;

    public LocationPointerCompassAngleDistance() {
        Compass.getInstance().addListener((CompassListener)this);
        Location.getInstance().addListener((LocationListener)this);
        Orientation.getInstance().addListener((OrientationListener)this);
    }

    public void triggerOrientationRead() {
        Orientation.getInstance().triggerDeviceOrientationRead();
    }

    private double getAngleBetweenGPSPoints(double lat1, double lng1, double lat2, double lng2) {
        Double phi1 = lat1 * degreesToRadiansFactor;
        Double phi2 = lat2 * degreesToRadiansFactor;
        Double lam1 = lng1 * degreesToRadiansFactor;
        Double lam2 = lng2 * degreesToRadiansFactor;
        double angle = Math.atan2(Math.sin(lam2 - lam1) * Math.cos(phi2), Math.cos(phi1) * Math.sin(phi2) - Math.sin(phi1) * Math.cos(phi2) * Math.cos(lam2 - lam1)) * 180.0 / Math.PI;
        if (angle < 0.0) {
            angle += 360.0;
        }
        return Math.abs(angle);
    }

    private float getDistanceBetweenGPSPoints(double lat1, double lng1, double lat2, double lng2) {
        double earthRadius = 6371000.0;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLng = Math.toRadians(lng2 - lng1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        float dist = (float)(earthRadius * c);
        return dist;
    }

    public void addListener(LocationPointerCompassAngleDistanceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LocationPointerCompassAngleDistanceListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListenerAboutAngleChange(double angle) {
        for (LocationPointerCompassAngleDistanceListener listener : this.listeners) {
            listener.angleChanged(angle);
        }
    }

    private void notifyListenerAboutAngleAndDistanceChange(double angle, double distance) {
        for (LocationPointerCompassAngleDistanceListener listener : this.listeners) {
            listener.angleAndDistanceChanged(angle, distance);
        }
    }

    private void calulateNewAngleAndDistance() {
        this.angle = this.getAngleBetweenGPSPoints(this.latDevice, this.lonDevice, this.latBot, this.lonBot);
        double distance = this.getDistanceBetweenGPSPoints(this.latDevice, this.lonDevice, this.latBot, this.lonBot);
        this.notifyListenerAboutAngleAndDistanceChange(this.calulateNewAngleFromPositionAngleAndCompassHeading(this.angle, this.compassHeading), distance);
    }

    public void compassHeadingChanged(double compassHeading) {
        this.compassHeading = compassHeading;
        this.notifyListenerAboutAngleChange(this.calulateNewAngleFromPositionAngleAndCompassHeading(this.angle, this.compassHeading));
    }

    private double calulateNewAngleFromPositionAngleAndCompassHeading(double positionAngle, double compassAngle) {
        double compassWidgetAngle = this.compassHeading > this.angle ? 360.0 + (this.angle - this.compassHeading) : this.angle - this.compassHeading;
        return compassWidgetAngle %= 360.0;
    }

    public void locationChanged(double latDeg, double longDeg) {
        this.latDevice = latDeg;
        this.lonDevice = longDeg;
        this.calulateNewAngleAndDistance();
    }

    public void windBotPositionChanged(Position positionDTO) {
        this.latBot = positionDTO.getLatDeg();
        this.lonBot = positionDTO.getLngDeg();
        this.calulateNewAngleAndDistance();
    }

    private void setAngleOffsetAtListeners(double offset) {
        for (LocationPointerCompassAngleDistanceListener listener : this.listeners) {
            listener.setAngleOffset(offset);
        }
    }

    public void orientationChanged(Util.Pair<OrientationType, Double> orientation) {
        this.setAngleOffsetAtListeners(((Double)orientation.getB()).doubleValue());
    }
}

