/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.widgets.windbot.compass;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.compass.LocationPointerCompass;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.compass.LocationPointerCompassAngleDistance;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.compass.LocationPointerCompassAngleDistanceListener;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.compass.LocationPointerCompassRessources;
import com.sap.sailing.domain.common.Position;
import java.util.Iterator;

public class LocationPointerCompass
extends Composite
implements HasWidgets,
LocationPointerCompassAngleDistanceListener {
    private static LocationPointerCompasssUiBinder uiBinder = (LocationPointerCompasssUiBinder)GWT.create(LocationPointerCompasssUiBinder.class);
    @UiField
    Image compassNeedle;
    @UiField
    DivElement distanceToPointetLocation;
    @UiField
    DivElement angleToPointetLocation;
    private double angleOffset;
    private LocationPointerCompassAngleDistance locationPointerCompassAngleDistance;

    public LocationPointerCompass() {
        LocationPointerCompassRessources.INSTANCE.gss().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.compassNeedle.setResource(LocationPointerCompassRessources.INSTANCE.compass());
        this.locationPointerCompassAngleDistance = new LocationPointerCompassAngleDistance();
        this.locationPointerCompassAngleDistance.addListener((LocationPointerCompassAngleDistanceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNeedleAngle(double newDirection) {
        LocationPointerCompass locationPointerCompass = this;
        synchronized (locationPointerCompass) {
            double newAngle = (newDirection - this.angleOffset) % 360.0;
            String winddirectionformatted = NumberFormat.getFormat((String)"#0").format(newAngle);
            this.compassNeedle.getElement().getStyle().setProperty("transform", "rotate(" + winddirectionformatted + "deg)");
            this.compassNeedle.getElement().getStyle().setProperty("webkitTransform", "rotate(" + winddirectionformatted + "deg)");
            String winddirectionFormattedForLabel = NumberFormat.getFormat((String)"#0").format(newAngle < 0.0 ? 360.0 + newAngle : newAngle);
            this.angleToPointetLocation.setInnerHTML(String.valueOf(winddirectionFormattedForLabel) + "\u00b0");
        }
    }

    private void updateDistanceToPointedLocationLabel(double distance, double angle) {
        String distanceFormatted = NumberFormat.getFormat((String)"#0").format(distance);
        this.distanceToPointetLocation.setInnerHTML(String.valueOf(distanceFormatted) + " m");
    }

    public void windBotPositionChanged(Position positionDTO) {
        this.locationPointerCompassAngleDistance.windBotPositionChanged(positionDTO);
    }

    public void angleChanged(double angle) {
        this.updateNeedleAngle(angle);
    }

    public void angleAndDistanceChanged(double angle, double distance) {
        this.updateNeedleAngle(angle);
        this.updateDistanceToPointedLocationLabel(distance, angle);
    }

    public void setAngleOffset(double offset) {
        this.angleOffset = offset;
    }

    public void add(Widget w) {
        throw new UnsupportedOperationException("The method add(Widget w) is not supported.");
    }

    public void clear() {
        throw new UnsupportedOperationException("The method clear() is not supported.");
    }

    public Iterator<Widget> iterator() {
        return null;
    }

    public boolean remove(Widget w) {
        return false;
    }
}

