/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.widgets.windbot;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.dashboards.gwt.client.DashboardClientFactory;
import com.sap.sailing.dashboards.gwt.client.dataretriever.WindBotDataRetrieverListener;
import com.sap.sailing.dashboards.gwt.client.widgets.header.DashboardWidgetHeaderAndNoDataMessage;
import com.sap.sailing.dashboards.gwt.client.widgets.startlineadvantage.util.LiveAverageComponent;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.WindBotWidget;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.WindBotWidgetResources;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.charts.VerticalWindChart;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.charts.VerticalWindChartClickListener;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.compass.LocationPointerCompass;
import com.sap.sailing.dashboards.gwt.shared.MovingAverage;
import com.sap.sailing.dashboards.gwt.shared.WindType;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sailing.gwt.ui.shared.WindInfoForRaceDTO;
import com.sap.sailing.gwt.ui.shared.WindTrackInfoDTO;
import com.sap.sse.gwt.dispatch.client.system.batching.SplitScheduler;
import com.sap.sse.gwt.shared.ClientConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindBotWidget
extends Composite
implements HasWidgets,
WindBotDataRetrieverListener {
    private MovingAverage movingAverageSpeed;
    private MovingAverage movingAverageDirection;
    private static WindBotWidgetUiBinder uiBinder = (WindBotWidgetUiBinder)GWT.create(WindBotWidgetUiBinder.class);
    private static final Logger logger = Logger.getLogger(WindBotWidget.class.getName());
    @UiField
    HTMLPanel contentContainer;
    @UiField(provided=true)
    DashboardWidgetHeaderAndNoDataMessage dashboardWidgetHeaderAndNoDataMessage;
    @UiField
    DivElement totalWindSpeedHeader;
    @UiField
    DivElement totalWindDirectionHeader;
    @UiField(provided=true)
    public LiveAverageComponent trueWindSpeedLiveAverageComponent;
    @UiField(provided=true)
    public LiveAverageComponent trueWindDirectionLiveAverageComponent;
    @UiField(provided=true)
    public VerticalWindChart trueWindSpeedVerticalWindChart;
    @UiField(provided=true)
    public VerticalWindChart trueWindDirectionVerticalWindChart;
    @UiField
    public LocationPointerCompass locationPointerCompass;
    public DashboardClientFactory dashboardClientFactory;
    private String windBotId;
    private StringMessages stringConstants;

    public WindBotWidget(DashboardClientFactory dashboardClientFactory) {
        WindBotWidgetResources.INSTANCE.gss().ensureInjected();
        this.dashboardClientFactory = dashboardClientFactory;
        this.dashboardWidgetHeaderAndNoDataMessage = new DashboardWidgetHeaderAndNoDataMessage();
        this.stringConstants = StringMessages.INSTANCE;
        this.movingAverageSpeed = new MovingAverage(500);
        this.movingAverageDirection = new MovingAverage(500);
        this.trueWindSpeedLiveAverageComponent = new LiveAverageComponent(this.stringConstants.dashboardTrueWindSpeedUnit());
        this.trueWindDirectionLiveAverageComponent = new LiveAverageComponent(this.stringConstants.degreesUnit());
        this.trueWindSpeedVerticalWindChart = new VerticalWindChart("#008FFF", "#6ADBFF");
        this.trueWindDirectionVerticalWindChart = new VerticalWindChart("#008FFF", "#6ADBFF");
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.hideContentContainer();
        this.dashboardWidgetHeaderAndNoDataMessage.setHeaderText(this.stringConstants.dashboardWindBot());
        if (ClientConfiguration.getInstance().isBrandingActive()) {
            this.dashboardWidgetHeaderAndNoDataMessage.showNoDataMessageWithHeaderAndMessage(this.stringConstants.dashboardNoWindBotAvailableHeader(), String.valueOf(this.stringConstants.dashboardNoWindBotAvailableMessage(ClientConfiguration.getInstance().getBrandTitle(Optional.empty()))) + " ");
        } else {
            this.dashboardWidgetHeaderAndNoDataMessage.showNoDataMessageWithHeaderAndMessage(this.stringConstants.dashboardNoWindBotAvailableHeader(), this.stringConstants.dashboardNoWindBotAvailableMessage(""));
        }
        this.totalWindSpeedHeader.setInnerHTML(this.stringConstants.dashboardTrueWindSpeed());
        this.totalWindDirectionHeader.setInnerHTML(this.stringConstants.dashboardTrueWindDirection());
        this.trueWindSpeedVerticalWindChart.addVerticalWindChartClickListener((VerticalWindChartClickListener)this.trueWindSpeedLiveAverageComponent);
        this.trueWindDirectionVerticalWindChart.addVerticalWindChartClickListener((VerticalWindChartClickListener)this.trueWindDirectionLiveAverageComponent);
    }

    public void setWindBotId(String windBotId) {
        this.windBotId = windBotId;
        this.dashboardWidgetHeaderAndNoDataMessage.setHeaderText(String.valueOf(this.stringConstants.dashboardWindBot()) + " " + windBotId);
    }

    private void showContentContainer() {
        this.contentContainer.getElement().getStyle().setOpacity(1.0);
    }

    private void hideContentContainer() {
        this.contentContainer.getElement().getStyle().setOpacity(0.0);
    }

    private WindTrackInfoDTO getWindTrackInfoDTOFromAndWindBotID(WindInfoForRaceDTO windInfoForRaceDTO, String id) {
        WindTrackInfoDTO windTrackInfo = null;
        for (WindSource windSource : windInfoForRaceDTO.windTrackInfoByWindSource.keySet()) {
            if (!windSource.getType().equals((Object)WindSourceType.EXPEDITION) || windSource.getId() == null || !windSource.getId().toString().equals(id)) continue;
            windTrackInfo = (WindTrackInfoDTO)windInfoForRaceDTO.windTrackInfoByWindSource.get(windSource);
        }
        return windTrackInfo;
    }

    public void updateWindBotUI(WindInfoForRaceDTO windInfoForRaceDTO) {
        logger.log(Level.INFO, "WindBotComponent with id " + this.windBotId + " got notified about new WindInfoForRaceDTO");
        if (windInfoForRaceDTO != null) {
            WindTrackInfoDTO windTrackInfoDTO = this.getWindTrackInfoDTOFromAndWindBotID(windInfoForRaceDTO, this.windBotId);
            if (windTrackInfoDTO != null) {
                logger.log(Level.INFO, "WindInfoForRaceDTO contains WindTrackInfoDTO for Windbot id " + this.windBotId);
                if (windTrackInfoDTO.windFixes != null) {
                    if (windTrackInfoDTO.windFixes.size() > 0) {
                        this.dashboardWidgetHeaderAndNoDataMessage.hideNoDataMessage();
                        logger.log(Level.INFO, "Upating UI with Wind Fixes for WindBot id " + this.windBotId);
                        SplitScheduler.get().schedule((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
                        SplitScheduler.get().schedule((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
                        SplitScheduler.get().schedule((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
                        SplitScheduler.get().schedule((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
                        this.showContentContainer();
                    } else {
                        logger.log(Level.INFO, "WindTrackInfoDTO.windFixes is empty");
                    }
                } else {
                    logger.log(Level.INFO, "WindTrackInfoDTO.windFixes is null");
                }
            } else {
                logger.log(Level.INFO, "WindInfoForRaceDTO does not contains WindTrackInfoDTO for Windbot id " + this.windBotId);
            }
        } else {
            logger.log(Level.INFO, "WindInfoForRaceDTO is null");
        }
    }

    private void updateWindSpeedLabelsAndChart(WindTrackInfoDTO windTrackInfoDTO) {
        int size = windTrackInfoDTO.windFixes.size();
        this.trueWindSpeedLiveAverageComponent.setLiveValue(NumberFormat.getFormat((String)"#0.0").format((Number)((WindDTO)windTrackInfoDTO.windFixes.get((int)(size - 1))).trueWindSpeedInKnots));
        this.trueWindSpeedVerticalWindChart.addPointsToSeriesWithAverageAndWindType(windTrackInfoDTO.windFixes, this.movingAverageSpeed.getAverage(), WindType.SPEED);
        this.trueWindSpeedLiveAverageComponent.setAverageValue(NumberFormat.getFormat((String)"#0.0").format(this.movingAverageSpeed.getAverage()));
    }

    private void updateWindDirectionLabelsAndChart(WindTrackInfoDTO windTrackInfoDTO) {
        int size = windTrackInfoDTO.windFixes.size();
        this.trueWindDirectionLiveAverageComponent.setLiveValue(NumberFormat.getFormat((String)"#0.0").format((Number)((WindDTO)windTrackInfoDTO.windFixes.get((int)(size - 1))).trueWindFromDeg));
        this.trueWindDirectionVerticalWindChart.addPointsToSeriesWithAverageAndWindType(windTrackInfoDTO.windFixes, this.movingAverageDirection.getAverage(), WindType.DIRECTION);
        this.trueWindDirectionLiveAverageComponent.setAverageValue(NumberFormat.getFormat((String)"#0.0").format(this.movingAverageDirection.getAverage()));
    }

    private void updateLocationPointerCompass(WindTrackInfoDTO windTrackInfoDTO) {
        this.locationPointerCompass.windBotPositionChanged(((WindDTO)windTrackInfoDTO.windFixes.get((int)(windTrackInfoDTO.windFixes.size() - 1))).position);
    }

    private void updateMovingAverages(List<WindDTO> windFixes) {
        for (WindDTO windDTO : windFixes) {
            this.movingAverageSpeed.add(windDTO.trueWindSpeedInKnots.doubleValue());
            this.movingAverageDirection.add(windDTO.trueWindFromDeg.doubleValue());
        }
    }

    public void add(Widget w) {
        throw new UnsupportedOperationException("The method add(Widget w) is not supported.");
    }

    public void clear() {
        throw new UnsupportedOperationException("The method clear() is not supported.");
    }

    public Iterator<Widget> iterator() {
        return null;
    }

    public boolean remove(Widget w) {
        return false;
    }

    static /* synthetic */ void access$0(WindBotWidget windBotWidget, List list) {
        windBotWidget.updateMovingAverages(list);
    }

    static /* synthetic */ void access$1(WindBotWidget windBotWidget, WindTrackInfoDTO windTrackInfoDTO) {
        windBotWidget.updateWindSpeedLabelsAndChart(windTrackInfoDTO);
    }

    static /* synthetic */ void access$2(WindBotWidget windBotWidget, WindTrackInfoDTO windTrackInfoDTO) {
        windBotWidget.updateWindDirectionLabelsAndChart(windTrackInfoDTO);
    }

    static /* synthetic */ void access$3(WindBotWidget windBotWidget, WindTrackInfoDTO windTrackInfoDTO) {
        windBotWidget.updateLocationPointerCompass(windTrackInfoDTO);
    }
}

