/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.dashboardpanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.mgwt.ui.client.widget.carousel.Carousel;
import com.sap.sailing.dashboards.gwt.client.DashboardClientFactory;
import com.sap.sailing.dashboards.gwt.client.actions.GetIDFromRaceThatIsLiveAction;
import com.sap.sailing.dashboards.gwt.client.dashboardpanel.DashboardPanel;
import com.sap.sailing.dashboards.gwt.client.dashboardpanel.DashboardPanelResources;
import com.sap.sailing.dashboards.gwt.client.dataretriever.NumberOfWindBotsChangeListener;
import com.sap.sailing.dashboards.gwt.client.dataretriever.WindBotDataRetrieverListener;
import com.sap.sailing.dashboards.gwt.client.dataretriever.WindBotDataRetrieverProvider;
import com.sap.sailing.dashboards.gwt.client.header.DashboardHeader;
import com.sap.sailing.dashboards.gwt.client.notifications.orientation.WrongDeviceOrientationNotification;
import com.sap.sailing.dashboards.gwt.client.widgets.PollsLiveDataEvery5Seconds;
import com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.StartAnalysisWidget;
import com.sap.sailing.dashboards.gwt.client.widgets.startlineadvantage.course.StartlineAdvantageByGeometryWidget;
import com.sap.sailing.dashboards.gwt.client.widgets.startlineadvantage.wind.StartlineAdvantagesByWindWidget;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.WindBotWidget;
import com.sap.sailing.dashboards.gwt.shared.DashboardURLParameters;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DashboardPanel
extends Composite
implements NumberOfWindBotsChangeListener,
PollsLiveDataEvery5Seconds {
    private static RootUiBinder uiBinder = (RootUiBinder)GWT.create(RootUiBinder.class);
    @UiField
    LayoutPanel root;
    @UiField
    DashboardHeader header;
    @UiField
    Carousel carousel;
    @UiField(provided=true)
    WindBotWidget leftWindBotWidget;
    @UiField(provided=true)
    WindBotWidget rightWindBotWidget;
    @UiField(provided=true)
    StartlineAdvantagesByWindWidget startlineAdvantagesByWindComponent;
    @UiField
    public HTMLPanel bottombar;
    @UiField
    public HTMLPanel windcharthint;
    @UiField
    public Image eventLogo;
    @UiField(provided=true)
    public StartAnalysisWidget startanalysisComponent;
    @UiField(provided=true)
    public StartlineAdvantageByGeometryWidget startlineAdvantageByGeometryWidget;
    private StringMessages stringConstants;
    DashboardClientFactory dashboardClientFactory;
    private static final Logger logger = Logger.getLogger(DashboardPanel.class.getName());

    public DashboardPanel(DashboardClientFactory dashboardClientFactory, ErrorReporter errorReporter) {
        DashboardPanelResources.INSTANCE.style().ensureInjected();
        this.dashboardClientFactory = dashboardClientFactory;
        this.leftWindBotWidget = new WindBotWidget(dashboardClientFactory);
        this.rightWindBotWidget = new WindBotWidget(dashboardClientFactory);
        this.startanalysisComponent = new StartAnalysisWidget(this.dashboardClientFactory, errorReporter);
        this.startlineAdvantagesByWindComponent = new StartlineAdvantagesByWindWidget(this.dashboardClientFactory);
        this.startlineAdvantageByGeometryWidget = new StartlineAdvantageByGeometryWidget(this.dashboardClientFactory);
        this.stringConstants = StringMessages.INSTANCE;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.windcharthint.getElement().setInnerText(this.stringConstants.dashboardWindChartHint());
        this.loadEventLogoAndName(dashboardClientFactory.getSailingService());
        this.initAndAddWrongOrientationNotification();
        this.registerForDashboardFiveSecondsTimer(dashboardClientFactory);
    }

    private void loadEventLogoAndName(SailingServiceAsync sailingServiceAsync) {
        String eventId = DashboardURLParameters.EVENT_ID.getValue();
        if (eventId != null) {
            try {
                UUID eventUUID = UUID.fromString(eventId);
                logger.log(Level.INFO, "Loading EventDTO for id " + eventId);
                sailingServiceAsync.getEventById(eventUUID, true, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IllegalArgumentException e) {
                this.eventLogo.getElement().getStyle().setVisibility(Style.Visibility.HIDDEN);
            }
        }
    }

    private void initAndAddWrongOrientationNotification() {
        WrongDeviceOrientationNotification wrongDeviceOrientationNotification = new WrongDeviceOrientationNotification();
        Document.get().getBody().appendChild((Node)wrongDeviceOrientationNotification.getElement());
    }

    public void timeChanged(Date newTime, Date oldTime) {
        String leaderboardNameParameterValue = DashboardURLParameters.LEADERBOARD_NAME.getValue();
        if (leaderboardNameParameterValue != null) {
            this.dashboardClientFactory.getDispatch().execute((Action)new GetIDFromRaceThatIsLiveAction(leaderboardNameParameterValue), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void registerForDashboardFiveSecondsTimer(DashboardClientFactory dashboardClientFactory) {
        if (dashboardClientFactory != null) {
            dashboardClientFactory.getDashboardFiveSecondsTimer().addTimeListener((TimeListener)this);
        }
    }

    public void numberOfWindBotsReceivedChanged(List<String> windBotIDs, WindBotDataRetrieverProvider windBotDataRetrieverProvider) {
        if (windBotIDs != null) {
            logger.log(Level.INFO, "Number of available windbots changed to " + windBotIDs.size());
            int i = 0;
            while (i < windBotIDs.size()) {
                if (i == 0) {
                    this.leftWindBotWidget.setWindBotId(windBotIDs.get(i));
                    windBotDataRetrieverProvider.addWindBotDataRetrieverListener((WindBotDataRetrieverListener)this.leftWindBotWidget);
                }
                if (i == 1) {
                    this.rightWindBotWidget.setWindBotId(windBotIDs.get(i));
                    windBotDataRetrieverProvider.addWindBotDataRetrieverListener((WindBotDataRetrieverListener)this.rightWindBotWidget);
                }
                ++i;
            }
        } else {
            logger.log(Level.INFO, "Number of available windbots changed. WindBots List is null");
        }
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }
}

