/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.grib.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.MeterPerSecondSpeedWithDegreeBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sailing.grib.impl.AbstractGribWindFieldImpl;
import com.sap.sailing.grib.impl.CompositeVariableSpecification;
import com.sap.sailing.grib.impl.Grib1VariableSpecification;
import com.sap.sailing.grib.impl.Grib2VariableSpecification;
import com.sap.sailing.grib.impl.VariableSpecification;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.Array;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;

public class SpeedAndDirectionWindField
extends AbstractGribWindFieldImpl {
    private static final Logger logger = Logger.getLogger(SpeedAndDirectionWindField.class.getName());
    private static final int WIND_DIRECTION_PARAMETER_ID = 31;
    private static final int WIND_DIRECTION_GRIB2_DISCIPLINE = 0;
    private static final int WIND_DIRECTION_GRIB2_PARAMETER_CATEGORY = 2;
    private static final int WIND_DIRECTION_GRIB2_PARAMETER_NUMBER = 0;
    private static final int WIND_SPEED_PARAMETER_ID = 32;
    private static final int WIND_SPEED_GRIB2_DISCIPLINE = 0;
    private static final int WIND_SPEED_GRIB2_PARAMETER_CATEGORY = 2;
    private static final int WIND_SPEED_GRIB2_PARAMETER_NUMBER = 1;
    private static final VariableSpecification windDirectionVariableSpecification;
    private static final VariableSpecification windSpeedVariableSpecification;

    static {
        VariableSpecification[] variableSpecificationArray = new VariableSpecification[2];
        variableSpecificationArray[0] = new Grib1VariableSpecification(31);
        int[] nArray = new int[3];
        nArray[1] = 2;
        variableSpecificationArray[1] = new Grib2VariableSpecification(nArray);
        windDirectionVariableSpecification = new CompositeVariableSpecification(variableSpecificationArray);
        VariableSpecification[] variableSpecificationArray2 = new VariableSpecification[2];
        variableSpecificationArray2[0] = new Grib1VariableSpecification(32);
        int[] nArray2 = new int[3];
        nArray2[1] = 2;
        nArray2[2] = 1;
        variableSpecificationArray2[1] = new Grib2VariableSpecification(nArray2);
        windSpeedVariableSpecification = new CompositeVariableSpecification(variableSpecificationArray2);
    }

    public SpeedAndDirectionWindField(FeatureDataset ... dataSets) {
        super(0.5, dataSets);
    }

    @Override
    public WindWithConfidence<TimePoint> getWind(TimePoint timePoint, Position position) throws IOException {
        Wind wind;
        double confidence;
        Util.Triple<Double, TimePoint, Position> directionComponentInDegreesTrue = null;
        Util.Triple<Double, TimePoint, Position> speedComponentInMetersPerSecond = null;
        FeatureDataset[] featureDatasetArray = this.getDataSets();
        int n = featureDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDataset dataSet = featureDatasetArray[n2];
            if (dataSet instanceof GridDataset) {
                for (GridDatatype grid : ((GridDataset)dataSet).getGrids()) {
                    if (windDirectionVariableSpecification.matches((VariableSimpleIF)grid.getVariable())) {
                        assert (this.isDegreesTrue(this.getUnit(grid.getVariable()).get()));
                        directionComponentInDegreesTrue = this.getValue(grid, timePoint, position);
                    } else if (windSpeedVariableSpecification.matches((VariableSimpleIF)grid.getVariable())) {
                        assert (this.isMetersPerSecond(this.getUnit(grid.getVariable()).get()));
                        speedComponentInMetersPerSecond = this.getValue(grid, timePoint, position);
                    }
                    if (directionComponentInDegreesTrue != null && speedComponentInMetersPerSecond != null) break;
                }
            }
            ++n2;
        }
        if (directionComponentInDegreesTrue != null && speedComponentInMetersPerSecond != null) {
            confidence = this.getTimeConfidence(timePoint, (TimePoint)directionComponentInDegreesTrue.getB());
            wind = this.createWindFixFromDirectionAndSpeed((Position)directionComponentInDegreesTrue.getC(), (TimePoint)directionComponentInDegreesTrue.getB(), (Double)speedComponentInMetersPerSecond.getA(), (Double)directionComponentInDegreesTrue.getA());
        } else {
            wind = null;
            confidence = 0.0;
        }
        return new WindWithConfidenceImpl(wind, confidence * this.getBaseConfidence(), (Object)timePoint, true);
    }

    private Wind createWindFixFromDirectionAndSpeed(Position position, TimePoint timePoint, double speedInMetersPerSecond, double fromTrueDirectionInDeg) {
        return new WindImpl(position, timePoint, (SpeedWithBearing)new MeterPerSecondSpeedWithDegreeBearingImpl(speedInMetersPerSecond, new DegreeBearingImpl(fromTrueDirectionInDeg).reverse()));
    }

    public static boolean handles(FeatureDataset ... dataSets) {
        return SpeedAndDirectionWindField.hasVariable(windDirectionVariableSpecification, dataSets) && SpeedAndDirectionWindField.hasVariable(windSpeedVariableSpecification, dataSets);
    }

    @Override
    public Iterable<Wind> getAllWindFixes() throws IOException {
        ArrayList<Wind> result = new ArrayList<Wind>();
        GridDatatype directionGrid = null;
        GridDatatype speedGrid = null;
        FeatureDataset[] featureDatasetArray = this.getDataSets();
        int n = featureDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDataset dataSet = featureDatasetArray[n2];
            Iterator i = ((GridDataset)dataSet).getGrids().iterator();
            while (i.hasNext() && (directionGrid == null || speedGrid == null)) {
                GridDatatype grid = (GridDatatype)i.next();
                if (windDirectionVariableSpecification.matches((VariableSimpleIF)grid.getVariable())) {
                    assert (this.isDegreesTrue(this.getUnit(grid.getVariable()).get()));
                    directionGrid = grid;
                    continue;
                }
                if (!windSpeedVariableSpecification.matches((VariableSimpleIF)grid.getVariable())) continue;
                assert (this.isMetersPerSecond(this.getUnit(grid.getVariable()).get()));
                speedGrid = grid;
            }
            ++n2;
        }
        if (directionGrid != null && speedGrid != null) {
            GridDatatype finalSpeedGrid = speedGrid;
            HashMap speedGridDataCache = new HashMap();
            for (Wind wind : this.foreach(directionGrid, (directionGridData, timeIndex, index, timePoint, position) -> {
                try {
                    Array speedGridData = (Array)speedGridDataCache.get(timeIndex);
                    if (speedGridData == null) {
                        speedGridData = finalSpeedGrid.readVolumeData(timeIndex);
                        speedGridDataCache.put(timeIndex, speedGridData);
                    }
                    double speedInMetersPerSecond = speedGridData.getDouble(index);
                    double trueDirectionFromInDeg = directionGridData.getDouble(index);
                    Wind wind = !Double.isNaN(speedInMetersPerSecond) && !Double.isNaN(trueDirectionFromInDeg) ? this.createWindFixFromDirectionAndSpeed(position, timePoint, speedInMetersPerSecond, trueDirectionFromInDeg) : null;
                    return wind;
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Exception trying to compute wind from speed and direction", e);
                    return null;
                }
            })) {
                if (wind == null) continue;
                result.add(wind);
            }
        }
        return result;
    }
}

