/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.grib.impl;

import com.sap.sailing.domain.common.Bounds;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.impl.BoundsImpl;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.confidence.ConfidenceFactory;
import com.sap.sailing.grib.GribWindField;
import com.sap.sailing.grib.impl.VariableSpecification;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.TimeRangeImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.StreamSupport;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public abstract class AbstractGribWindFieldImpl
implements GribWindField {
    private final FeatureDataset[] dataSets;
    private final Weigher<TimePoint> timeConfidenceWeigher;
    private final double baseConfidence;

    public AbstractGribWindFieldImpl(double baseConfidence, FeatureDataset ... dataSets) {
        this.dataSets = dataSets;
        this.baseConfidence = baseConfidence;
        this.timeConfidenceWeigher = ConfidenceFactory.INSTANCE.createExponentialTimeDifferenceWeigher(Duration.ONE_SECOND.times(30L).asMillis(), 1.0E-10);
    }

    protected static boolean hasVariable(VariableSpecification variableSpecification, FeatureDataset ... dataSets) {
        return variableSpecification.appearsInAnyOf(dataSets);
    }

    protected boolean hasVariable(VariableSpecification variableSpecification) {
        return variableSpecification.appearsInAnyOf(this.dataSets);
    }

    protected double getBaseConfidence() {
        return this.baseConfidence;
    }

    @Override
    public Bounds getBounds() {
        Bounds result = null;
        FeatureDataset[] featureDatasetArray = this.getDataSets();
        int n = featureDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDataset dataSet = featureDatasetArray[n2];
            Bounds dataSetBounds = this.toBounds(dataSet.getBoundingBox());
            result = result == null ? dataSetBounds : result.extend(dataSetBounds);
            ++n2;
        }
        return result;
    }

    @Override
    public TimeRange getTimeRange() {
        return new TimeRangeImpl(this.getStartTime(), this.getEndTime());
    }

    protected double getTimeConfidence(TimePoint timePoint) {
        double result;
        TimeRange timeRange = this.getTimeRange();
        if (timeRange.includes(timePoint)) {
            result = 1.0;
        } else if (timeRange.startsAtOrAfter(timePoint)) {
            result = this.timeConfidenceWeigher.getConfidence((Object)timeRange.from(), (Object)timePoint);
        } else {
            assert (timeRange.endsBefore(timePoint));
            result = this.timeConfidenceWeigher.getConfidence((Object)timeRange.to(), (Object)timePoint);
        }
        return result;
    }

    protected double getTimeConfidence(TimePoint request, TimePoint fact) {
        return this.timeConfidenceWeigher.getConfidence((Object)request, (Object)fact);
    }

    protected TimePoint toTimePoint(CalendarDate calendarDate) {
        return new MillisecondsTimePoint(calendarDate.getMillis());
    }

    protected TimePoint getStartTime() {
        return StreamSupport.stream(Arrays.asList(this.getDataSets()).spliterator(), false).map(dataSet -> this.toTimePoint(dataSet.getCalendarDateStart())).min(Comparator.naturalOrder()).get();
    }

    private TimePoint getEndTime() {
        return StreamSupport.stream(Arrays.asList(this.getDataSets()).spliterator(), false).map(dataSet -> this.toTimePoint(dataSet.getCalendarDateEnd())).max(Comparator.naturalOrder()).get();
    }

    private Bounds toBounds(LatLonRect boundingBox) {
        return new BoundsImpl(this.toPosition((LatLonPoint)boundingBox.getLowerLeftPoint()), this.toPosition((LatLonPoint)boundingBox.getUpperRightPoint()));
    }

    private Position toPosition(LatLonPoint point) {
        return new DegreePosition(point.getLatitude(), point.getLongitude());
    }

    protected FeatureDataset[] getDataSets() {
        return this.dataSets;
    }

    protected Util.Triple<Double, TimePoint, Position> getValue(GridDatatype grid, TimePoint timePoint, Position position) throws IOException {
        TimePoint responseTimePoint;
        int timeIndex;
        GridCoordSystem coordinateSystem = grid.getCoordinateSystem();
        int[] xy = coordinateSystem.findXYindexFromLatLon(position.getLatDeg(), position.getLngDeg(), new int[2]);
        Dimension timeDimension = grid.getTimeDimension();
        if (timeDimension != null) {
            int numberOfTimepointsInGrid = timeDimension.getLength();
            if (numberOfTimepointsInGrid == 1) {
                timeIndex = 0;
                responseTimePoint = this.getStartTime();
            } else {
                Duration timeBetweenSamples = this.getTimeRange().getDuration().divide((long)numberOfTimepointsInGrid);
                Duration requestedDurationAfterStart = this.getStartTime().until(timePoint);
                double steps = requestedDurationAfterStart.divide(timeBetweenSamples);
                if (steps < 0.0) {
                    timeIndex = 0;
                    responseTimePoint = this.getStartTime();
                } else if (steps > (double)(numberOfTimepointsInGrid - 1)) {
                    timeIndex = numberOfTimepointsInGrid - 1;
                    responseTimePoint = this.getEndTime();
                } else {
                    timeIndex = (int)Math.round(steps);
                    responseTimePoint = this.getStartTime().plus(timeBetweenSamples.times((long)timeIndex));
                }
            }
        } else {
            timeIndex = -1;
            responseTimePoint = this.getStartTime();
        }
        Util.Pair<Double, Position> nearestNonNaNValueWithPosition = this.getNearestNonNaNValueWithPosition(coordinateSystem, grid, timeIndex, 0, xy[1], xy[0], 0);
        return new Util.Triple((Object)((Double)nearestNonNaNValueWithPosition.getA()), (Object)responseTimePoint, (Object)((Position)nearestNonNaNValueWithPosition.getB()));
    }

    private Util.Pair<Double, Position> getNearestNonNaNValueWithPosition(GridCoordSystem coordinateSystem, GridDatatype grid, int timeIndex, int zIndex, int yIndex, int xIndex, int distance) throws IOException {
        double valueAsFloat;
        int minX = Math.max(0, xIndex - distance);
        int maxX = Math.min(grid.getXDimension().getLength() - 1, xIndex + distance);
        int minY = Math.max(0, yIndex - distance);
        int maxY = Math.min(grid.getYDimension().getLength() - 1, yIndex + distance);
        if (minX > maxX || minY > maxY) {
            return new Util.Pair((Object)Double.NaN, null);
        }
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                valueAsFloat = this.getValue(grid, timeIndex, zIndex, x, y);
                if (!Double.isNaN(valueAsFloat)) {
                    Position responsePosition = this.toPosition(coordinateSystem.getLatLon(x, y));
                    return new Util.Pair((Object)valueAsFloat, (Object)responsePosition);
                }
                y += Math.max(1, maxY - minY);
            }
            ++x;
        }
        int y = minY + 1;
        while (y < maxY) {
            int x2 = minX;
            while (x2 <= maxX) {
                valueAsFloat = this.getValue(grid, timeIndex, zIndex, x2, y);
                if (!Double.isNaN(valueAsFloat)) {
                    Position responsePosition = this.toPosition(coordinateSystem.getLatLon(x2, y));
                    return new Util.Pair((Object)valueAsFloat, (Object)responsePosition);
                }
                x2 += Math.max(1, maxX - minX);
            }
            ++y;
        }
        return this.getNearestNonNaNValueWithPosition(coordinateSystem, grid, timeIndex, zIndex, yIndex, xIndex, distance + 1);
    }

    protected double getValue(GridDatatype grid, int timeIndex, int zIndex, int x, int y) throws IOException {
        Array arrayForTimePointBefore = grid.readDataSlice(timeIndex, zIndex, y, x);
        double valueAsFloat = arrayForTimePointBefore.getFloat(0);
        return valueAsFloat;
    }

    protected double getValue(Array gridData, int zIndex, int x, int y) throws IOException {
        double valueAsFloat = gridData.getRank() == 3 ? gridData.getDouble(Index.factory((int[])new int[]{zIndex, y, x})) : gridData.getDouble(Index.factory((int[])new int[]{y, x}));
        return valueAsFloat;
    }

    protected <T> Iterable<T> foreach(GridDatatype grid, ValueForCoordinateProvider<T> provider) throws IOException {
        ArrayList<T> result = new ArrayList<T>();
        GridCoordSystem coordinateSystem = grid.getCoordinateSystem();
        int timeDimLength = grid.getTimeDimension().getLength();
        int t = 0;
        while (t < timeDimLength) {
            TimePoint timePoint = this.toTimePoint(coordinateSystem.getTimeAxis1D().getCalendarDate(t));
            Array gridData = grid.readVolumeData(t);
            long arraySize = gridData.getSize();
            Index index = gridData.getIndex();
            long i = 0L;
            while (i < arraySize) {
                Position position = this.toPosition(coordinateSystem.getLatLon(index.getCurrentCounter()[index.getCurrentCounter().length - 1], index.getCurrentCounter()[index.getCurrentCounter().length - 2]));
                result.add(provider.getValue(gridData, t, index, timePoint, position));
                index.incr();
                ++i;
            }
            ++t;
        }
        return result;
    }

    protected Optional<String> getUnit(VariableDS variable) {
        Attribute attribute = variable.findAttribute("units");
        Optional<String> result = attribute != null ? Optional.of(attribute.getStringValue()) : Optional.empty();
        return result;
    }

    protected boolean isMetersPerSecond(String unit) {
        String spacelessUnit = this.removeSpacesAndToLowercase(unit);
        return spacelessUnit.equals("m/s") || spacelessUnit.equals("ms^-1");
    }

    protected boolean isDegreesTrue(String unit) {
        String spacelessUnit = this.removeSpacesAndToLowercase(unit).replaceAll("_", "");
        return spacelessUnit.equals("degreetrue") || spacelessUnit.equals("degtrue");
    }

    private String removeSpacesAndToLowercase(String unit) {
        return unit.replaceAll(" ", "").toLowerCase();
    }

    @FunctionalInterface
    static interface ValueForCoordinateProvider<T> {
        public T getValue(Array var1, int var2, Index var3, TimePoint var4, Position var5);
    }
}

