/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.shared.subscription;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sse.common.TimePoint;
import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.ui.shared.subscription.HasSubscriptionMessageKeys;

public abstract class SubscriptionDTO
implements HasSubscriptionMessageKeys,
IsSerializable {
    protected static final String PAYMENT_STATUS_SUCCESS = "success";
    private static final String PAYMENT_STATUS_NO_SUCCESS = "no_success";
    private String planId;
    private String subscriptionId;
    private String subscriptionStatus;
    private String paymentStatus;
    private String transactionType;
    private Integer reoccuringPaymentValue;
    private String currencyCode;
    private TimePoint createdAt;
    private TimePoint cancelledAt;
    private TimePoint nextBillingAt;
    private TimePoint currentTermEnd;
    private TimePoint trialEnd;
    private String provider;

    protected SubscriptionDTO() {
    }

    protected SubscriptionDTO(String planId, String subscriptionId, String subscriptionStatus, String paymentStatus, String transactionType, Integer reoccuringPaymentValue, String currencyCode, TimePoint createdAt, TimePoint trialEnd, TimePoint currentTermEnd, TimePoint cancelledAt, TimePoint nextBillingAt, String provider) {
        this.planId = planId;
        this.subscriptionId = subscriptionId;
        this.trialEnd = trialEnd;
        this.subscriptionStatus = subscriptionStatus;
        this.paymentStatus = paymentStatus;
        this.transactionType = transactionType;
        this.provider = provider;
        this.reoccuringPaymentValue = reoccuringPaymentValue;
        this.currencyCode = currencyCode;
        this.createdAt = createdAt;
        this.cancelledAt = cancelledAt;
        this.nextBillingAt = nextBillingAt;
        this.currentTermEnd = currentTermEnd;
    }

    public abstract boolean isInTrial();

    public abstract boolean isActive();

    public abstract boolean isPaused();

    public abstract boolean isCancelled();

    public abstract boolean isRefunded();

    public boolean isRenewing() {
        return this.nextBillingAt != null && !Subscription.emptyTime().equals(this.nextBillingAt) && this.reoccuringPaymentValue != null;
    }

    public boolean isPaymentSuccess() {
        return PAYMENT_STATUS_SUCCESS.equals(this.paymentStatus);
    }

    public boolean isPaymentNoSuccess() {
        return PAYMENT_STATUS_NO_SUCCESS.equals(this.paymentStatus);
    }

    public String getSubscriptionPlanId() {
        return this.planId;
    }

    public String getProvider() {
        return this.provider;
    }

    public TimePoint getTrialEnd() {
        return this.trialEnd;
    }

    protected String getSubscriptionStatus() {
        return this.subscriptionStatus;
    }

    protected String getPaymentStatus() {
        return this.paymentStatus;
    }

    protected String getTransactionType() {
        return this.transactionType;
    }

    public Integer getReoccuringPaymentValue() {
        return this.reoccuringPaymentValue;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public TimePoint getCreatedAt() {
        return this.createdAt;
    }

    public TimePoint getCancelledAt() {
        return this.cancelledAt;
    }

    public TimePoint getNextBillingAt() {
        return this.nextBillingAt;
    }

    public TimePoint getCurrentTermEnd() {
        return this.currentTermEnd;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }
}

