/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.server.subscription.chargebee;

import com.chargebee.Result;
import com.chargebee.models.HostedPage;
import com.chargebee.models.Invoice;
import com.chargebee.models.Subscription;
import com.chargebee.models.Transaction;
import com.sap.sse.ServerStartupConstants;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.subscription.SubscriptionPlan;
import com.sap.sse.security.shared.subscription.chargebee.ChargebeeSubscription;
import com.sap.sse.security.subscription.SubscriptionApiService;
import com.sap.sse.security.subscription.SubscriptionCancelResult;
import com.sap.sse.security.subscription.SubscriptionNonRenewingResult;
import com.sap.sse.security.subscription.chargebee.ChargebeeConfiguration;
import com.sap.sse.security.ui.client.subscription.chargebee.ChargebeeSubscriptionWriteService;
import com.sap.sse.security.ui.server.subscription.chargebee.ChargebeeSubscriptionServiceImpl;
import com.sap.sse.security.ui.shared.subscription.SubscriptionListDTO;
import com.sap.sse.security.ui.shared.subscription.chargebee.ChargebeeConfigurationDTO;
import com.sap.sse.security.ui.shared.subscription.chargebee.FinishCheckoutDTO;
import com.sap.sse.security.ui.shared.subscription.chargebee.PrepareCheckoutDTO;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChargebeeSubscriptionWriteServiceImpl
extends ChargebeeSubscriptionServiceImpl
implements ChargebeeSubscriptionWriteService {
    private static final long serialVersionUID = 3058555834123504387L;
    private static final String SUBSCRIPTION_STATUS_ACTIVE = "active";
    private static final String SUBSCRIPTION_NON_RENEWING = "non_renewing";
    private static final Logger logger = Logger.getLogger(ChargebeeSubscriptionWriteServiceImpl.class.getName());

    public SubscriptionListDTO finishCheckout(FinishCheckoutDTO data) {
        SubscriptionListDTO subscriptionDto;
        logger.info("finishCheckout hostedPageId: " + data.getHostedPageId());
        try {
            User user = this.getCurrentUser();
            SecurityService securityService = this.getSecurityService();
            securityService.lockSubscriptionsForUser(user);
            try {
                String invoiceStatus;
                String invoiceId;
                String transactionStatus;
                String transactionType;
                Result result = HostedPage.acknowledge((String)data.getHostedPageId()).request();
                HostedPage.Content content = result.hostedPage().content();
                String customerId = content.customer().id();
                if (customerId != null && !customerId.equals(user.getName())) {
                    throw new UserManagementException("User does not match!");
                }
                Transaction transaction = content.transaction();
                if (transaction != null) {
                    transactionType = transaction.type().name().toLowerCase();
                    transactionStatus = transaction.status().name().toLowerCase();
                } else {
                    transactionType = null;
                    transactionStatus = null;
                }
                Invoice invoice = content.invoice();
                if (invoice != null) {
                    invoiceId = invoice.id();
                    invoiceStatus = invoice.status().name().toLowerCase();
                } else {
                    invoiceId = null;
                    invoiceStatus = null;
                }
                Subscription contentSubscription = content.subscription();
                Timestamp trialStart = contentSubscription.trialStart();
                Timestamp trialEnd = contentSubscription.trialEnd();
                SubscriptionPlan plan = null;
                for (Subscription.SubscriptionItem item : contentSubscription.subscriptionItems()) {
                    if (!item.itemType().equals((Object)Subscription.SubscriptionItem.ItemType.PLAN)) continue;
                    String itemPriceId = item.itemPriceId();
                    plan = this.getSecurityService().getSubscriptionPlanByItemPriceId(itemPriceId);
                    break;
                }
                if (plan == null) {
                    throw new IllegalArgumentException("No such Subscriptionplan");
                }
                String paymentStatus = ChargebeeSubscription.determinePaymentStatus((String)transactionType, (String)transactionStatus, (String)invoiceStatus);
                ChargebeeSubscription subscription = new ChargebeeSubscription(contentSubscription.id(), plan.getId(), customerId, trialStart == null ? com.sap.sse.security.shared.subscription.Subscription.emptyTime() : TimePoint.of((Date)trialStart), trialStart == null ? com.sap.sse.security.shared.subscription.Subscription.emptyTime() : TimePoint.of((Date)trialEnd), contentSubscription.status().name().toLowerCase(), paymentStatus, transactionType, transactionStatus, invoiceId, invoiceStatus, contentSubscription.mrr(), contentSubscription.currencyCode(), this.getTime(contentSubscription.createdAt()), this.getTime(contentSubscription.updatedAt()), this.getTime(contentSubscription.activatedAt()), this.getTime(contentSubscription.nextBillingAt()), this.getTime(contentSubscription.currentTermEnd()), this.getTime(contentSubscription.cancelledAt()), com.sap.sse.security.shared.subscription.Subscription.emptyTime(), com.sap.sse.security.shared.subscription.Subscription.emptyTime());
                this.updateUserSubscription(user, (com.sap.sse.security.shared.subscription.Subscription)subscription);
                this.cancelOldSubscriptionIfCoveredByNewOne(user.getSubscriptions(), (com.sap.sse.security.shared.subscription.Subscription)subscription);
                subscriptionDto = this.getSubscriptions(Boolean.valueOf(true));
            }
            finally {
                securityService.unlockSubscriptionsForUser(user);
            }
        }
        catch (UserManagementException e) {
            logger.log(Level.FINE, "No user is logged in.");
            subscriptionDto = new SubscriptionListDTO(null, e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in saving subscription", e);
            subscriptionDto = new SubscriptionListDTO(null, e.getMessage());
        }
        return subscriptionDto;
    }

    private void cancelOldSubscriptionIfCoveredByNewOne(Iterable<com.sap.sse.security.shared.subscription.Subscription> oldSubsciptions, com.sap.sse.security.shared.subscription.Subscription newSubscription) {
        if (this.isActive(newSubscription)) {
            SubscriptionPlan newSubscribedPlan = this.getSecurityService().getSubscriptionPlanById(newSubscription.getPlanId());
            for (com.sap.sse.security.shared.subscription.Subscription oldSubscription : oldSubsciptions) {
                if (oldSubscription.getSubscriptionId() == null || oldSubscription.getSubscriptionId().equals(newSubscription.getSubscriptionId()) || !this.isActive(oldSubscription)) continue;
                SubscriptionPlan oldSubscribedPlan = this.getSecurityService().getSubscriptionPlanById(oldSubscription.getPlanId());
                if (!Util.containsAll((Iterable)newSubscribedPlan.getPlanCategories(), (Iterable)oldSubscribedPlan.getPlanCategories())) continue;
                logger.info("An old subscription is totally covered by new one. We can cancel the old one: " + oldSubscribedPlan.toString());
                this.cancelSubscription(oldSubscribedPlan.getId());
            }
        }
    }

    private boolean isActive(com.sap.sse.security.shared.subscription.Subscription subscription) {
        return SUBSCRIPTION_STATUS_ACTIVE.equals(subscription.getSubscriptionStatus()) || SUBSCRIPTION_NON_RENEWING.equals(subscription.getSubscriptionStatus());
    }

    private TimePoint getTime(Timestamp timeStamp) {
        return timeStamp == null ? com.sap.sse.security.shared.subscription.Subscription.emptyTime() : TimePoint.of((Date)timeStamp);
    }

    public ChargebeeConfigurationDTO getConfiguration() {
        ChargebeeConfiguration configuration = ChargebeeConfiguration.getInstance();
        ChargebeeConfigurationDTO result = configuration != null ? new ChargebeeConfigurationDTO(configuration.getSite()) : null;
        return result;
    }

    public PrepareCheckoutDTO prepareCheckout(String priceId) {
        PrepareCheckoutDTO response = new PrepareCheckoutDTO();
        try {
            User user = this.getCurrentUser();
            if (!ServerStartupConstants.SUBSCRIPTIONS_DISABLE_EMAIL_VERIFICATION_REQUIRED && !user.isEmailValidated()) {
                throw new IllegalArgumentException("User mail must be validated.");
            }
            SubscriptionPlan planForPrice = this.getSecurityService().getSubscriptionPlanByItemPriceId(priceId);
            if (planForPrice == null) {
                throw new IllegalArgumentException("No matching subscription plan found for given price id.");
            }
            if (planForPrice.getIsOneTimePlan().booleanValue() && user.hasAnySubscription(planForPrice.getId())) {
                throw new IllegalArgumentException("Plan can only be subscribed once.");
            }
            if (this.isNewPlanCompletelyIncludedInCurrentPlan(user, planForPrice)) {
                throw new IllegalArgumentException("User has already subscribed to plan which covers the new one.");
            }
            Util.Pair usernames = this.getUserFirstAndLastName(user);
            String locale = user.getLocaleOrDefault().getLanguage();
            HostedPage.CheckoutNewForItemsRequest requestBuilder = HostedPage.checkoutNewForItems().subscriptionItemItemPriceId(0, priceId).subscriptionItemQuantity(0, Integer.valueOf(1)).customerId(user.getName()).customerEmail(user.getEmail()).customerFirstName((String)usernames.getA()).customerLastName((String)usernames.getB());
            if (this.isChargebeeSupportedLocale(locale)) {
                requestBuilder.customerLocale(locale);
            }
            Result result = requestBuilder.request();
            response.setHostedPageJSONString(result.hostedPage().toJson());
        }
        catch (UserManagementException e) {
            logger.log(Level.FINE, "No user is logged in.");
            response.setError("You have to login as user to use this function.");
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "Error occured while preparing Chargebee checkout. " + e.getMessage());
            response.setError("Error occured while preparing Chargebee checkout. " + e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in generating Chargebee hosted page data ", e);
            response.setError("Unexpected error occurred while generating Chargebee hosted page.");
        }
        return response;
    }

    private boolean isChargebeeSupportedLocale(String locale) {
        HashSet<String> supportedLocales = new HashSet<String>(Arrays.asList("en", "fr", "de", "it", "pt", "es"));
        return supportedLocales.contains(locale);
    }

    public boolean cancelSubscription(String planId) {
        boolean result;
        try {
            User user = this.getCurrentUser();
            SecurityService securityService = this.getSecurityService();
            securityService.lockSubscriptionsForUser(user);
            try {
                com.sap.sse.security.shared.subscription.Subscription subscription = user.getSubscriptionByPlan(planId);
                if (this.isValidSubscription(subscription)) {
                    logger.info(() -> "Cancel user subscription, user " + user.getName() + ", plan " + planId);
                    SubscriptionApiService apiService = this.getApiService();
                    if (apiService != null) {
                        SubscriptionCancelResult cancelResult = (SubscriptionCancelResult)this.requestCancelSubscription(apiService, subscription.getSubscriptionId()).get();
                        if (cancelResult.isSuccess()) {
                            logger.info(() -> "Cancel subscription successful");
                            result = true;
                            if (cancelResult.getSubscription() != null) {
                                this.updateUserSubscription(user, cancelResult.getSubscription());
                            }
                        } else {
                            result = false;
                            if (cancelResult.isDeleted()) {
                                logger.info(() -> "Subscription for plan was deleted");
                                com.sap.sse.security.shared.subscription.Subscription emptySubscription = ChargebeeSubscription.createEmptySubscription((String)planId, (TimePoint)subscription.getLatestEventTime(), (TimePoint)TimePoint.now());
                                this.updateUserSubscription(user, emptySubscription);
                            } else {
                                logger.info(() -> "Cancel subscription failed");
                            }
                        }
                    } else {
                        logger.info(() -> "No active api service found");
                        result = false;
                    }
                } else {
                    logger.info(() -> "Invalid subscription");
                    result = false;
                }
            }
            finally {
                securityService.unlockSubscriptionsForUser(user);
            }
        }
        catch (UserManagementException e) {
            logger.log(Level.FINE, "No user is logged in.");
            result = false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in cancel subscription ", e);
            result = false;
        }
        return result;
    }

    public boolean nonRenewingSubscription(String planId) {
        boolean result;
        try {
            User user = this.getCurrentUser();
            SecurityService securityService = this.getSecurityService();
            securityService.lockSubscriptionsForUser(user);
            try {
                com.sap.sse.security.shared.subscription.Subscription subscription = user.getSubscriptionByPlan(planId);
                if (this.isValidSubscription(subscription)) {
                    logger.info(() -> "Set user subscription to non renewing, user " + user.getName() + ", plan " + planId);
                    SubscriptionApiService apiService = this.getApiService();
                    if (apiService != null) {
                        SubscriptionNonRenewingResult nonRenewingResult = (SubscriptionNonRenewingResult)this.requestNonRenewingSubscription(apiService, subscription.getSubscriptionId()).get();
                        if (nonRenewingResult.isSuccess()) {
                            logger.info(() -> "Setting subscription to non renewing successful");
                            result = true;
                            if (nonRenewingResult.getSubscription() != null) {
                                this.updateUserSubscription(user, nonRenewingResult.getSubscription());
                            }
                        } else {
                            result = false;
                            if (nonRenewingResult.isDeleted()) {
                                logger.info(() -> "Subscription for plan was deleted");
                                com.sap.sse.security.shared.subscription.Subscription emptySubscription = ChargebeeSubscription.createEmptySubscription((String)planId, (TimePoint)subscription.getLatestEventTime(), (TimePoint)TimePoint.now());
                                this.updateUserSubscription(user, emptySubscription);
                            } else {
                                logger.info(() -> "Setting subscription to non renewing failed");
                            }
                        }
                    } else {
                        logger.info(() -> "No active api service found");
                        result = false;
                    }
                } else {
                    logger.info(() -> "Invalid subscription");
                    result = false;
                }
            }
            finally {
                securityService.unlockSubscriptionsForUser(user);
            }
        }
        catch (UserManagementException e) {
            logger.log(Level.FINE, "No user is logged in.");
            result = false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in setting subscription to non renewing ", e);
            result = false;
        }
        return result;
    }

    private Future<SubscriptionNonRenewingResult> requestNonRenewingSubscription(SubscriptionApiService apiService, String subscriptionId) {
        CompletableFuture<SubscriptionNonRenewingResult> result = new CompletableFuture<SubscriptionNonRenewingResult>();
        apiService.nonRenewingSubscription(subscriptionId, (SubscriptionApiService.OnNonRenewingSubscriptionResultListener)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private Future<SubscriptionCancelResult> requestCancelSubscription(SubscriptionApiService apiService, String subscriptionId) {
        CompletableFuture<SubscriptionCancelResult> result = new CompletableFuture<SubscriptionCancelResult>();
        apiService.cancelSubscription(subscriptionId, (SubscriptionApiService.OnCancelSubscriptionResultListener)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }
}

