/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.server.subscription;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.sap.sse.common.Util;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.AbstractOwnership;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.SecurityAccessControlList;
import com.sap.sse.security.shared.SecurityUser;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.shared.subscription.SubscriptionPlan;
import com.sap.sse.security.subscription.SubscriptionApiService;
import com.sap.sse.security.ui.client.subscription.SubscriptionService;
import com.sap.sse.security.ui.server.Activator;
import com.sap.sse.security.ui.shared.subscription.SubscriptionPlanDTO;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class SubscriptionServiceImpl
extends RemoteServiceServlet
implements SubscriptionService {
    private static final long serialVersionUID = -2953209842119970755L;
    private static final Logger logger = Logger.getLogger(SubscriptionServiceImpl.class.getName());
    private BundleContext context;
    private CompletableFuture<SecurityService> securityService;
    private ServiceTracker<SubscriptionApiService, SubscriptionApiService> subscriptionApiServiceTracker;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = Activator.getContext();
        this.securityService = this.initSecurityService();
        this.subscriptionApiServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)this.context, SubscriptionApiService.class);
    }

    public ArrayList<String> getUnlockingSubscriptionplans(WildcardPermission permission) throws UserManagementException {
        ArrayList<String> result = new ArrayList<String>();
        User currentUser = this.getSecurityService().getCurrentUser() != null ? this.getSecurityService().getCurrentUser() : this.getSecurityService().getAllUser();
        SecurityService securityServiceInstance = this.getSecurityService();
        User allUser = this.getSecurityService().getAllUser();
        this.getSecurityService().getAllSubscriptionPlans().values().forEach(plan -> {
            Role[] subscriptionPlanUserRolesArray = this.getSecurityService().getSubscriptionPlanUserRoles(currentUser, plan);
            Set subscriptionPlanUserRoles = Stream.of(subscriptionPlanUserRolesArray).collect(Collectors.toSet());
            List parts = permission.getParts();
            if (parts.size() > 2 && !((Set)parts.get(2)).isEmpty()) {
                boolean allChecksPassed = true;
                for (QualifiedObjectIdentifier objectIdentifier : permission.getQualifiedObjectIdentifiers()) {
                    AccessControlListAnnotation acl;
                    OwnershipAnnotation ownership = securityServiceInstance.getOwnership(objectIdentifier);
                    allChecksPassed = PermissionChecker.isPermitted((WildcardPermission)permission, (SecurityUser)currentUser, (SecurityUser)allUser, (AbstractOwnership)(ownership == null ? null : (Ownership)ownership.getAnnotation()), (SecurityAccessControlList)((acl = securityServiceInstance.getAccessControlList(objectIdentifier)) == null ? null : (AccessControlList)acl.getAnnotation()), subscriptionPlanUserRoles);
                    if (!allChecksPassed) break;
                }
                if (allChecksPassed) {
                    result.add(plan.getId());
                }
            } else if (PermissionChecker.isPermitted((WildcardPermission)permission, (SecurityUser)currentUser, (SecurityUser)allUser, null, null, subscriptionPlanUserRoles)) {
                result.add(plan.getId());
            }
        });
        return result;
    }

    public boolean isUserInPossessionOfRoles(String priceId) throws UserManagementException {
        User currentUser = this.getCurrentUser();
        SubscriptionPlan plan = this.getSecurityService().getSubscriptionPlanByItemPriceId(priceId);
        return plan.isUserInPossessionOfRoles(currentUser);
    }

    private CompletableFuture<SecurityService> initSecurityService() {
        FullyInitializedReplicableTracker tracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)this.context, SecurityService.class);
        return CompletableFuture.supplyAsync(() -> {
            SecurityService result = null;
            try {
                logger.info("Waiting for SecurityService...");
                result = (SecurityService)tracker.getInitializedService(0L);
                logger.info("Obtained SecurityService " + result);
                SecurityUtils.setSecurityManager((SecurityManager)result.getSecurityManager());
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "Interrupted while waiting for SecurityService service", e);
            }
            return result;
        });
    }

    protected void updateUserSubscription(User user, Subscription subscription) throws UserManagementException {
        logger.info(() -> "Update user subscription, user " + user.getName() + ", new subsription " + subscription.toString());
        this.getSecurityService().updateUserSubscription(user.getName(), subscription);
    }

    protected boolean isNewPlanCompletelyIncludedInCurrentPlan(User user, SubscriptionPlan newPlan) {
        Iterable subscriptions = user.getSubscriptions();
        if (subscriptions != null) {
            for (Subscription sub : subscriptions) {
                SubscriptionPlan subscribedPlan = this.getSecurityService().getSubscriptionPlanById(sub.getPlanId());
                if (subscribedPlan == null || !this.isValidSubscription(sub) || this.isSubscriptionCancelled(sub) || !Util.containsAll((Iterable)subscribedPlan.getPlanCategories(), (Iterable)newPlan.getPlanCategories())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isOneOfTheUserSubscriptionsIsCoveredByPlan(User user, SubscriptionPlan plan) {
        Iterable subscriptions = user.getSubscriptions();
        if (subscriptions != null) {
            for (Subscription sub : subscriptions) {
                SubscriptionPlan subscribedPlan = this.getSecurityService().getSubscriptionPlanById(sub.getPlanId());
                if (subscribedPlan == null || !this.isValidSubscription(sub) || this.isSubscriptionCancelled(sub) || !Util.containsAll((Iterable)plan.getPlanCategories(), (Iterable)subscribedPlan.getPlanCategories())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isValidSubscription(Subscription subscription) {
        return subscription != null && subscription.getSubscriptionId() != null && subscription.getSubscriptionId().length() != 0;
    }

    protected Util.Pair<String, String> getUserFirstAndLastName(User user) {
        Util.Pair result;
        if (user.getFullName() == null || user.getFullName().isEmpty()) {
            result = new Util.Pair((Object)user.getName(), (Object)"");
        } else {
            String[] userNameParts = user.getFullName().split("\\s+");
            String firstName = userNameParts[0];
            String lastName = userNameParts.length > 1 ? String.join((CharSequence)" ", Arrays.copyOfRange(userNameParts, 1, userNameParts.length)) : "";
            result = new Util.Pair((Object)firstName, (Object)lastName);
        }
        return result;
    }

    protected SecurityService getSecurityService() {
        SecurityService service;
        try {
            service = (SecurityService)this.securityService.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return service;
    }

    protected User getCurrentUser() throws UserManagementException {
        User user = this.getSecurityService().getCurrentUser();
        if (user == null) {
            throw new UserManagementException("User does not exist");
        }
        return user;
    }

    protected SubscriptionApiService getApiService() {
        ServiceReference[] serviceReferences;
        ServiceReference[] serviceReferenceArray = serviceReferences = this.subscriptionApiServiceTracker.getServiceReferences();
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            SubscriptionApiService service;
            ServiceReference serviceReference = serviceReferenceArray[n2];
            if (Util.equalsWithNull((Object)serviceReference.getProperty("provider-name"), (Object)this.getProviderName()) && (service = (SubscriptionApiService)this.context.getService(serviceReference)).isActive()) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    protected SubscriptionPlanDTO convertToDto(SubscriptionPlan plan) {
        boolean hasHadSubscriptionForOneTimePlan;
        boolean isUserSubscribedToPlan = this.isUserSubscribedToPlan(plan.getId());
        boolean isUserSubscribedToAllPlanCategories = false;
        if (isUserSubscribedToPlan) {
            isUserSubscribedToAllPlanCategories = true;
            hasHadSubscriptionForOneTimePlan = plan.getIsOneTimePlan();
        } else {
            HashSet categoriesRequired = new HashSet(plan.getPlanCategories());
            for (SubscriptionPlan subscriptionPlan : this.getSecurityService().getAllSubscriptionPlans().values()) {
                if (!this.isUserSubscribedToPlan(subscriptionPlan.getId())) continue;
                categoriesRequired.removeAll(subscriptionPlan.getPlanCategories());
                if (!categoriesRequired.isEmpty()) continue;
                isUserSubscribedToAllPlanCategories = true;
                break;
            }
            try {
                User currentUser = this.getCurrentUser();
                hasHadSubscriptionForOneTimePlan = currentUser.hasAnySubscription(plan.getId()) && plan.getIsOneTimePlan() != false;
            }
            catch (UserManagementException e) {
                logger.log(Level.FINE, "No user is logged in.");
                hasHadSubscriptionForOneTimePlan = false;
            }
        }
        boolean disablePrice = hasHadSubscriptionForOneTimePlan;
        HashSet prices = new HashSet();
        plan.getPrices().forEach(price -> {
            price.setDisablePlan(Boolean.valueOf(disablePrice));
            prices.add(price);
        });
        return new SubscriptionPlanDTO(plan.getId(), isUserSubscribedToPlan, prices, plan.getPlanCategories(), hasHadSubscriptionForOneTimePlan, isUserSubscribedToAllPlanCategories, null, plan.getGroup(), this.isOneOfTheUserSubscriptionsIsCoveredByPlan(plan.getId()));
    }

    private boolean isUserSubscribedToPlan(String planId) {
        try {
            User currentUser = this.getCurrentUser();
            Subscription subscriptionByPlan = currentUser.getSubscriptionByPlan(planId);
            return subscriptionByPlan != null ? subscriptionByPlan.isActiveSubscription() : false;
        }
        catch (UserManagementException e) {
            logger.log(Level.FINE, "No user is logged in.");
            return false;
        }
    }

    private boolean isOneOfTheUserSubscriptionsIsCoveredByPlan(String planId) {
        try {
            User currentUser = this.getCurrentUser();
            SubscriptionPlan subscriptionPlanById = this.getSecurityService().getSubscriptionPlanById(planId);
            return this.isOneOfTheUserSubscriptionsIsCoveredByPlan(currentUser, subscriptionPlanById);
        }
        catch (UserManagementException e) {
            logger.log(Level.FINE, "No user is logged in.");
            return false;
        }
    }

    protected ArrayList<SubscriptionPlanDTO> convertToDtos(Collection<SubscriptionPlan> plans) {
        return plans.stream().map(plan -> this.convertToDto(plan)).collect(Collectors.toCollection(ArrayList::new));
    }

    protected abstract String getProviderName();

    protected abstract boolean isSubscriptionCancelled(Subscription var1);
}

