/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.server;

import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.ui.server.Activator;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class LocaleInjectionFilter
implements Filter {
    private ServiceTracker<SecurityService, SecurityService> securityServiceTracker;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Locale preferredLocale;
        User user;
        SecurityService service;
        Object principal;
        if (this.securityServiceTracker == null) {
            BundleContext context = Activator.getContext();
            this.securityServiceTracker = new ServiceTracker(context, SecurityService.class, null);
            this.securityServiceTracker.open();
        }
        HttpServletResponse resp = (HttpServletResponse)response;
        Subject currentSubject = SecurityUtils.getSubject();
        if (currentSubject != null && (principal = currentSubject.getPrincipal()) instanceof String && (service = (SecurityService)this.securityServiceTracker.getService()) != null && (user = service.getUserByName((String)principal)) != null && (preferredLocale = user.getLocale()) != null) {
            Cookie cookie = new Cookie("GWT_LOCALE", preferredLocale.toLanguageTag());
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(true);
            resp.addCookie(cookie);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        if (this.securityServiceTracker != null) {
            this.securityServiceTracker.close();
            this.securityServiceTracker = null;
        }
    }
}

