/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.usermanagement.permissions;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.UserGroupListDataProvider;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.usermanagement.RoleAndPermissionDetailsResources;
import com.sap.sse.security.ui.client.usermanagement.permissions.WildcardPermissionWithSecurityDTOTableWrapper;
import java.util.function.Function;

public class WildcardPermissionPanel
extends HorizontalPanel
implements SelectionChangeEvent.Handler,
ChangeHandler,
KeyUpHandler,
UserGroupListDataProvider.UserGroupListDataProviderChangeHandler {
    private final WildcardPermissionWithSecurityDTOTableWrapper wildcardPermissionWithSecurityDTOTableWrapper;
    private final SingleSelectionModel<UserDTO> userSelectionModel;
    private final SuggestBox suggestPermission;
    private final RoleAndPermissionDetailsResources roleAndPermissionResources = (RoleAndPermissionDetailsResources)GWT.create(RoleAndPermissionDetailsResources.class);

    public WildcardPermissionPanel(UserService userService, StringMessages stringMessages, ErrorReporter errorReporter, CellTableWithCheckboxResources tableResources, MultiSelectionModel<UserDTO> userSelectionModel, Runnable updateUsers, Function<SuggestOracle, SuggestBox> suggestBoxConstructor) {
        SingleSelectionModel multiToSingleSelectionModelAdapter = new SingleSelectionModel();
        this.ensureDebugId(this.getClass().getSimpleName());
        MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();
        userSelectionModel.addSelectionChangeHandler(event -> {
            multiToSingleSelectionModelAdapter.clear();
            if (userSelectionModel.getSelectedSet().size() != 1) {
                this.setVisible(false);
            } else {
                multiToSingleSelectionModelAdapter.setSelected((Object)((UserDTO)userSelectionModel.getSelectedSet().iterator().next()), true);
                this.setVisible(true);
                this.updatePermissionOracleWithSecuredTypes(userService, oracle);
                this.updatePermissionList();
            }
        });
        this.userSelectionModel = multiToSingleSelectionModelAdapter;
        this.updatePermissionOracleWithSecuredTypes(userService, oracle);
        this.suggestPermission = suggestBoxConstructor.apply((SuggestOracle)oracle);
        this.suggestPermission.ensureDebugId("suggestPermission");
        this.roleAndPermissionResources.css().ensureInjected();
        this.suggestPermission.addStyleName(this.roleAndPermissionResources.css().enterPermissionSuggest());
        this.suggestPermission.getElement().setPropertyString("placeholder", stringMessages.enterPermissionName());
        this.initPlaceholder((UIObject)this.suggestPermission, stringMessages.enterPermissionName());
        HorizontalPanel permissionInputPanel = new HorizontalPanel();
        permissionInputPanel.add((Widget)this.suggestPermission);
        Button addPermissionButton = new Button(stringMessages.add(), event -> {
            UserDTO selectedUser;
            WildcardPermission selectedPermission = new WildcardPermission(this.suggestPermission.getText());
            if (selectedPermission != null && (selectedUser = (UserDTO)this.userSelectionModel.getSelectedObject()) != null) {
                userService.getUserManagementWriteService().addPermissionForUser(selectedUser.getName(), selectedPermission, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.suggestPermission.setText("");
        });
        addPermissionButton.ensureDebugId("addPermissionButton");
        Command addPermissionButtonUpdater = () -> addPermissionButton.setEnabled(!this.suggestPermission.getValue().isEmpty());
        this.suggestPermission.addKeyUpHandler(event -> addPermissionButtonUpdater.execute());
        this.suggestPermission.addSelectionHandler(event -> addPermissionButtonUpdater.execute());
        permissionInputPanel.add((Widget)addPermissionButton);
        this.wildcardPermissionWithSecurityDTOTableWrapper = new WildcardPermissionWithSecurityDTOTableWrapper(userService, stringMessages, errorReporter, true, tableResources, this.userSelectionModel, updateUsers);
        ScrollPanel scrollPanel = new ScrollPanel(this.wildcardPermissionWithSecurityDTOTableWrapper.asWidget());
        LabeledAbstractFilterablePanel userFilterbox = this.wildcardPermissionWithSecurityDTOTableWrapper.getFilterField();
        userFilterbox.getElement().setPropertyString("placeholder", stringMessages.filterUserGroups());
        VerticalPanel permissionPanel = new VerticalPanel();
        permissionPanel.add((Widget)permissionInputPanel);
        permissionPanel.add((Widget)userFilterbox);
        permissionPanel.add((Widget)scrollPanel);
        CaptionPanel captionPanel = new CaptionPanel(stringMessages.permissions());
        captionPanel.add((Widget)permissionPanel);
        this.setVisible(false);
        this.add((Widget)captionPanel);
    }

    private void updatePermissionOracleWithSecuredTypes(UserService userService, MultiWordSuggestOracle oracle) {
        for (HasPermissions permission : userService.getAllKnownPermissions()) {
            HasPermissions.Action[] actionArray = permission.getAvailableActions();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                HasPermissions.Action action = actionArray[n2];
                oracle.add(permission.getStringPermission(new HasPermissions.Action[]{action}));
                ++n2;
            }
        }
    }

    private void initPlaceholder(UIObject target, String placeholder) {
        target.getElement().setAttribute("placeholder", placeholder);
    }

    public void updatePermissionList() {
        this.wildcardPermissionWithSecurityDTOTableWrapper.refreshPermissionList();
    }

    public void onChange() {
        this.updatePermissionList();
    }

    public void onKeyUp(KeyUpEvent event) {
        this.updatePermissionList();
    }

    public void onChange(ChangeEvent event) {
        this.updatePermissionList();
    }

    public void onSelectionChange(SelectionChangeEvent event) {
        this.updatePermissionList();
    }
}

