/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.subscription;

import com.sap.sse.security.shared.subscription.InvalidSubscriptionProviderException;
import com.sap.sse.security.ui.client.subscription.SubscriptionClientProvider;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceAsync;
import com.sap.sse.security.ui.client.subscription.SubscriptionWriteServiceAsync;
import com.sap.sse.security.ui.client.subscription.chargebee.ChargebeeSubscriptionClientProvider;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionServiceFactory {
    private static final String DEFAULT_PROVIDER_NAME = "chargebee";
    private static SubscriptionServiceFactory instance;
    private Map<String, SubscriptionClientProvider> providers = new HashMap();
    private boolean inited;

    public static SubscriptionServiceFactory getInstance() {
        if (instance == null) {
            instance = new SubscriptionServiceFactory();
        }
        return instance;
    }

    private SubscriptionServiceFactory() {
        this.registerProviders();
    }

    public void initializeProviders() {
        if (!this.inited) {
            for (SubscriptionClientProvider p : this.providers.values()) {
                p.init();
            }
            this.inited = true;
        }
    }

    public void registerAsyncServices(String basePath) {
        for (SubscriptionClientProvider p : this.providers.values()) {
            p.registerAsyncService(basePath);
        }
    }

    public SubscriptionWriteServiceAsync<?, ?, ?> getWriteAsyncServiceByProvider(String providerName) throws InvalidSubscriptionProviderException {
        return this.getProvider(providerName).getSubscriptionWriteService();
    }

    public SubscriptionServiceAsync<?, ?> getAsyncServiceByProvider(String providerName) throws InvalidSubscriptionProviderException {
        return this.getProvider(providerName).getSubscriptionService();
    }

    public SubscriptionClientProvider getDefaultProvider() throws InvalidSubscriptionProviderException {
        return this.getProvider(DEFAULT_PROVIDER_NAME);
    }

    public SubscriptionServiceAsync<?, ?> getDefaultAsyncService() throws InvalidSubscriptionProviderException {
        return this.getAsyncServiceByProvider(DEFAULT_PROVIDER_NAME);
    }

    public SubscriptionWriteServiceAsync<?, ?, ?> getDefaultWriteAsyncService() throws InvalidSubscriptionProviderException {
        return this.getWriteAsyncServiceByProvider(DEFAULT_PROVIDER_NAME);
    }

    private SubscriptionClientProvider getProvider(String name) throws InvalidSubscriptionProviderException {
        SubscriptionClientProvider provider = (SubscriptionClientProvider)this.providers.get(name);
        if (provider == null) {
            throw new InvalidSubscriptionProviderException(name);
        }
        return provider;
    }

    private void registerProviders() {
        this.registerSubscriptionProvider((SubscriptionClientProvider)new ChargebeeSubscriptionClientProvider());
    }

    private void registerSubscriptionProvider(SubscriptionClientProvider provider) {
        this.providers.put(provider.getProviderName(), provider);
    }
}

