/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.shared.oauthlogin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.shared.oauthlogin.OAuthLogin;
import com.sap.sse.security.ui.client.shared.oauthlogin.OAuthLoginResources;
import com.sap.sse.security.ui.oauth.client.CredentialDTO;
import com.sap.sse.security.ui.oauth.client.util.ClientUtils;

public class OAuthLogin
extends Composite {
    private static OAuthLoginUiBinder uiBinder = (OAuthLoginUiBinder)GWT.create(OAuthLoginUiBinder.class);
    private static final String SAP_SAILING_OAUTH_WINDOW = "sap_sailing_oauth_verification_window";
    @UiField
    Anchor facebookAnchor;
    @UiField
    Anchor googleAnchor;
    @UiField
    Anchor twitterAnchor;
    @UiField
    Anchor linkedinAnchor;
    @UiField
    Anchor yahooAnchor;
    @UiField
    Anchor vimeoAnchor;
    @UiField
    Anchor githubAnchor;
    @UiField
    Anchor instagramAnchor;
    @UiField
    Anchor flickrAnchor;
    @UiField
    Anchor liveAnchor;
    @UiField
    Anchor tumblrAnchor;
    @UiField
    Anchor foursquareAnchor;
    public static OAuthLoginResources images = OAuthLoginResources.INSTANCE;
    private UserManagementWriteServiceAsync userManagementWriteService;

    public OAuthLogin(UserManagementWriteServiceAsync userManagementWriteService) {
        this.userManagementWriteService = userManagementWriteService;
        OAuthLoginResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    private void retreiveAndStoreAuthorizationUrl(int authProvider) {
        String callbackUrl = ClientUtils.getCallbackUrl();
        GWT.log((String)"Getting authorization url");
        CredentialDTO credential = new CredentialDTO();
        credential.setRedirectUrl(callbackUrl);
        credential.setAuthProvider(authProvider);
        this.userManagementWriteService.getAuthorizationUrl(credential, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"facebookAnchor"})
    void facebookAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"Facebook");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"googleAnchor"})
    void googleAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"Google");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"twitterAnchor"})
    void twitterAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"Twitter");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"yahooAnchor"})
    void yahooAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"Yahoo!");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"linkedinAnchor"})
    void linkedinAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"Linkedin");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"instagramAnchor"})
    void instagramAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"Instagram");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"vimeoAnchor"})
    void vimeoAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"Vimeo");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"githubAnchor"})
    void githubAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"github");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"flickrAnchor"})
    void flickrAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"flickr");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"liveAnchor"})
    void liveAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"Windows Live");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"tumblrAnchor"})
    void tumblrAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"tumblr.");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }

    @UiHandler(value={"foursquareAnchor"})
    void foursquareAnchorClicked(ClickEvent event) {
        int authProvider = ClientUtils.getAuthProvider((String)"foursquare");
        this.retreiveAndStoreAuthorizationUrl(authProvider);
    }
}

