/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.premium;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.dialog.ConfirmationDialog;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PremiumCheckBox;
import com.sap.sse.security.ui.client.premium.PremiumUiElement;
import com.sap.sse.security.ui.client.premium.settings.AbstractSecuredValueSetting;

public abstract class PremiumCheckBox
extends PremiumUiElement
implements HasValue<Boolean>,
HasAllKeyHandlers {
    private static PremiumCheckBoxUiBinder uiBinder = (PremiumCheckBoxUiBinder)GWT.create(PremiumCheckBoxUiBinder.class);
    @UiField
    StringMessages i18n;
    @UiField
    Style style;
    @UiField
    FocusPanel container;
    @UiField(provided=true)
    protected final Image image = this.createPremiumIcon();
    @UiField(provided=true)
    protected final CheckBox checkBox;
    private final boolean defaultValue;
    private final ConfirmationDialog subscribeDialog;

    protected PremiumCheckBox(String label, HasPermissions.Action action, PaywallResolver paywallResolver, SecuredDTO contextDTO, boolean defaultValue) {
        super(action, paywallResolver, contextDTO);
        this.defaultValue = defaultValue;
        this.checkBox = new CheckBox(label);
        this.checkBox.setValue(Boolean.valueOf(defaultValue));
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.subscribeDialog = ConfirmationDialog.create((String)this.i18n.subscriptionSuggestionTitle(), (String)this.i18n.pleaseSubscribeToUse(), (String)this.i18n.takeMeToSubscriptions(), (String)this.i18n.cancel(), () -> paywallResolver.getUnlockingSubscriptionPlans(action, contextDTO, arg_0 -> this.onSubscribeDialogConfirmation(arg_0)));
        this.updateUserPermission();
    }

    protected PremiumCheckBox(String label, AbstractSecuredValueSetting<Boolean> setting) {
        this(label, setting.getAction(), setting.getPaywallResolver(), setting.getSecuredDTO(), ((Boolean)setting.getValue()).booleanValue());
    }

    protected abstract void onSubscribeDialogConfirmation(Iterable<String> var1);

    protected void onEnsureDebugId(String baseID) {
        this.checkBox.ensureDebugId(baseID);
    }

    @UiHandler(value={"container"})
    void onContainerClicked(ClickEvent event) {
        if (!this.hasPermission()) {
            this.updateUserPermission();
            this.subscribeDialog.center();
        }
    }

    protected void onUserPermissionUpdate(boolean isPermitted) {
        this.checkBox.setValue(this.getValue());
        this.checkBox.setEnabled(this.isEnabled() && isPermitted);
        this.container.setStyleName(this.style.premiumPermitted(), isPermitted);
    }

    public void setValue(Boolean value) {
        this.checkBox.setValue(Boolean.valueOf(this.hasPermission() && value != false));
    }

    public void setValue(Boolean value, boolean fireEvents) {
        this.checkBox.setValue(Boolean.valueOf(this.hasPermission() && value != false), fireEvents);
    }

    public Boolean getValue() {
        Boolean result = this.hasPermission() ? this.checkBox.getValue() : Boolean.valueOf(this.defaultValue);
        return result;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
        return this.checkBox.addValueChangeHandler(handler);
    }

    public void setEnabled(boolean enabled) {
        if (this.hasPermission()) {
            super.setEnabled(enabled);
            this.checkBox.setEnabled(enabled);
        }
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.container.addKeyDownHandler(handler);
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.container.addKeyPressHandler(handler);
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.container.addKeyUpHandler(handler);
    }

    public FocusWidget getFocusWidget() {
        return this.checkBox;
    }

    public CheckBox getCheckBox() {
        return this.checkBox;
    }
}

