/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component.editacl;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sse.common.Named;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.controls.listedit.StringListEditorComposite;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.component.editacl.AclDialogResources;
import com.sap.sse.security.ui.client.component.editacl.AclEditPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AclEditPanel
extends Composite {
    private static AclEditPanelUiBinder uiBinder = (AclEditPanelUiBinder)GWT.create(AclEditPanelUiBinder.class);
    @UiField
    FlowPanel userGroupCellListPanelUi;
    @UiField
    FlowPanel permissionsCellListPanelUi;
    @UiField
    Label lblId;
    @UiField
    Label lblType;
    private final Button removeUserGroupButtonUi;
    private final Button addUserGroupButtonUi;
    private final SuggestBox suggestUserGroupUi;
    private final com.sap.sse.security.ui.client.i18n.StringMessages stringMessages;
    private final StringListEditorComposite allowedActionsEditor;
    private final StringListEditorComposite deniedActionsEditor;
    private final CaptionPanel allowedActionsContainer;
    private final CaptionPanel deniedActionsContainer;
    private final SingleSelectionModel<StrippedUserGroupDTO> userGroupSelectionModel = new SingleSelectionModel();
    private final ListDataProvider<StrippedUserGroupDTO> userGroupDataProvider = new ListDataProvider();
    private final Map<StrippedUserGroupDTO, Set<String>> userGroupsWithAllowedActions = new HashMap();
    private final Map<StrippedUserGroupDTO, Set<String>> userGroupsWithDeniedActions = new HashMap();
    private final UserManagementServiceAsync userManagementService;
    private final StrippedUserGroupDTO nullUserGroup;

    public AclEditPanel(UserManagementServiceAsync userManagementService, HasPermissions.Action[] availableActions, com.sap.sse.security.ui.client.i18n.StringMessages stringMessages, String typeIdentifier, String id) {
        this.stringMessages = stringMessages;
        this.userManagementService = userManagementService;
        this.nullUserGroup = new StrippedUserGroupDTO(null, stringMessages.nullUserGroup());
        AclDialogResources.INSTANCE.css().ensureInjected();
        this.suggestUserGroupUi = this.createUserGroupSuggest(userManagementService);
        this.addUserGroupButtonUi = new Button(stringMessages.add(), event -> this.onUserGroupAdd());
        this.removeUserGroupButtonUi = new Button(stringMessages.remove(), event -> this.onUserGroupRemove());
        this.removeUserGroupButtonUi.setEnabled(false);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        CellList userGroupList = this.createUserGroupCellList();
        this.userGroupDataProvider.addDataDisplay((HasData)userGroupList);
        this.userGroupCellListPanelUi.add((Widget)this.wrapIntoCaptionPanel(userGroupList, stringMessages.userGroups(), new Widget[]{this.suggestUserGroupUi, this.addUserGroupButtonUi, this.removeUserGroupButtonUi}));
        List actionNames = Stream.of(availableActions).map(HasPermissions.Action::name).collect(Collectors.toList());
        this.allowedActionsEditor = new StringListEditorComposite(new ArrayList(), (StringMessages)stringMessages, IconResources.INSTANCE.removeIcon(), actionNames, stringMessages.allowedActionName());
        this.allowedActionsEditor.addValueChangeHandler(event -> {
            Set set = this.userGroupsWithAllowedActions.put((StrippedUserGroupDTO)this.userGroupSelectionModel.getSelectedObject(), this.toSet((Iterable)event.getValue()));
        });
        this.allowedActionsContainer = this.createActionsContainer(stringMessages.allowedActions(), (Widget)this.allowedActionsEditor, AclDialogResources.INSTANCE.css().allowedActionsTable());
        this.permissionsCellListPanelUi.add((Widget)this.allowedActionsContainer);
        this.deniedActionsEditor = new StringListEditorComposite(new ArrayList(), (StringMessages)stringMessages, IconResources.INSTANCE.removeIcon(), actionNames, stringMessages.deniedActionName());
        this.deniedActionsEditor.addValueChangeHandler(e -> {
            Set set = this.userGroupsWithDeniedActions.put((StrippedUserGroupDTO)this.userGroupSelectionModel.getSelectedObject(), this.toDeniedActionSet((Iterable)e.getValue()));
        });
        this.deniedActionsContainer = this.createActionsContainer(stringMessages.deniedActions(), (Widget)this.deniedActionsEditor, AclDialogResources.INSTANCE.css().deniedActionsTable());
        this.permissionsCellListPanelUi.add((Widget)this.deniedActionsContainer);
        this.userGroupSelectionModel.addSelectionChangeHandler(event -> {
            StrippedUserGroupDTO userGroup = (StrippedUserGroupDTO)this.userGroupSelectionModel.getSelectedObject();
            this.deniedActionsEditor.setEnabled(userGroup != null && userGroup.getId() != null);
        });
        this.lblId.setText(id);
        this.lblType.setText(typeIdentifier);
        this.addUserGroupButtonUi.getElement().setAttribute("selenium-id", "AddUserGroupButton");
        this.suggestUserGroupUi.getElement().setAttribute("selenium-id", "SuggestUserGroupInput");
        this.allowedActionsContainer.getElement().setAttribute("selenium-id", "allowedActionsContainer");
        this.deniedActionsContainer.getElement().setAttribute("selenium-id", "deniedActionsContainer");
    }

    private CaptionPanel createActionsContainer(SafeHtml caption, Widget content, String styleName) {
        CaptionPanel container = new CaptionPanel(caption);
        container.add(content);
        container.addStyleName(styleName);
        container.setVisible(false);
        return container;
    }

    private SuggestBox createUserGroupSuggest(UserManagementServiceAsync userManagementService) {
        MultiWordSuggestOracle userGroupOracle = new MultiWordSuggestOracle();
        userManagementService.getUserGroups((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        SuggestBox suggestBox = new SuggestBox((SuggestOracle)userGroupOracle, (ValueBoxBase)new TextBox());
        suggestBox.getElement().setPropertyString("placeholder", this.stringMessages.enterUserGroupName());
        suggestBox.addStyleName(AclDialogResources.INSTANCE.css().userGroupTextBox());
        return suggestBox;
    }

    private CellList<StrippedUserGroupDTO> createUserGroupCellList() {
        CellList userGroupCellList = new CellList((Cell)new /* Unavailable Anonymous Inner Class!! */);
        userGroupCellList.setSelectionModel((SelectionModel)this.userGroupSelectionModel);
        this.userGroupSelectionModel.addSelectionChangeHandler(event -> this.updateActionEditors((StrippedUserGroupDTO)this.userGroupSelectionModel.getSelectedObject()));
        return userGroupCellList;
    }

    private void updateActionEditors(StrippedUserGroupDTO selectedUserGroup) {
        boolean userGroupSelected = selectedUserGroup != null;
        this.removeUserGroupButtonUi.setEnabled(userGroupSelected);
        this.allowedActionsContainer.setVisible(userGroupSelected);
        this.deniedActionsContainer.setVisible(userGroupSelected);
        if (userGroupSelected) {
            this.allowedActionsEditor.setValue((Iterable)this.userGroupsWithAllowedActions.get(selectedUserGroup), false);
            this.deniedActionsEditor.setValue((Iterable)this.removeExclamationMarkFromStrings((Iterable)this.userGroupsWithDeniedActions.get(selectedUserGroup)), false);
        }
    }

    private CaptionPanel wrapIntoCaptionPanel(CellList<?> cellList, String title, Widget ... additionalWidgets) {
        cellList.setPageSize(10);
        SimplePager pager = new SimplePager(SimplePager.TextLocation.CENTER, false, 50, true);
        pager.setDisplay(cellList);
        ScrollPanel tenantPanel = new ScrollPanel(cellList);
        VerticalPanel tenantListWrapper = new VerticalPanel();
        tenantListWrapper.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        FlowPanel additionalWidgetsPanel = new FlowPanel();
        Widget[] widgetArray = additionalWidgets;
        int n = additionalWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget additionalWidget = widgetArray[n2];
            additionalWidgetsPanel.add(additionalWidget);
            additionalWidget.addStyleName(AclDialogResources.INSTANCE.css().additionalWidget());
            ++n2;
        }
        tenantListWrapper.add((Widget)additionalWidgetsPanel);
        tenantListWrapper.add((Widget)tenantPanel);
        tenantListWrapper.add((Widget)pager);
        CaptionPanel tenantListCaption = new CaptionPanel(title);
        tenantListCaption.add((Widget)tenantListWrapper);
        return tenantListCaption;
    }

    public void updateAcl(AccessControlListDTO acl) {
        HashMap combinedActions = acl != null ? (acl.getActionsByUserGroup() != null ? new HashMap(acl.getActionsByUserGroup()) : new HashMap()) : new HashMap();
        for (Map.Entry combinedAction : combinedActions.entrySet()) {
            HashSet<String> allowedActions = new HashSet<String>();
            HashSet<String> deniedActions = new HashSet<String>();
            for (String action : (Set)combinedAction.getValue()) {
                if (action.startsWith("!")) {
                    deniedActions.add(action);
                    continue;
                }
                allowedActions.add(action);
            }
            if (combinedAction.getKey() == null) {
                this.userGroupsWithAllowedActions.put(this.nullUserGroup, allowedActions);
                this.userGroupsWithDeniedActions.put(this.nullUserGroup, deniedActions);
                continue;
            }
            this.userGroupsWithAllowedActions.put((StrippedUserGroupDTO)combinedAction.getKey(), allowedActions);
            this.userGroupsWithDeniedActions.put((StrippedUserGroupDTO)combinedAction.getKey(), deniedActions);
        }
        this.refreshUi();
    }

    private void refreshUi() {
        this.userGroupDataProvider.getList().clear();
        HashSet combinedKeySet = new HashSet();
        combinedKeySet.addAll(this.userGroupsWithAllowedActions.keySet());
        combinedKeySet.addAll(this.userGroupsWithDeniedActions.keySet());
        this.userGroupDataProvider.getList().addAll(combinedKeySet);
        Collections.sort(this.userGroupDataProvider.getList(), Comparator.comparing(Named::getName));
        if (this.userGroupDataProvider.getList().isEmpty()) {
            this.userGroupSelectionModel.clear();
        } else {
            this.userGroupSelectionModel.setSelected((Object)((StrippedUserGroupDTO)this.userGroupDataProvider.getList().iterator().next()), true);
        }
    }

    private void onUserGroupAdd() {
        String userGroupName = this.suggestUserGroupUi.getValue();
        this.userManagementService.getStrippedUserGroupByName(userGroupName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void onUserGroupRemove() {
        StrippedUserGroupDTO selectedObject = (StrippedUserGroupDTO)this.userGroupSelectionModel.getSelectedObject();
        if (selectedObject != null) {
            this.userGroupsWithAllowedActions.remove(selectedObject);
            this.userGroupsWithDeniedActions.remove(selectedObject);
            Notification.notify((String)this.stringMessages.successMessageRemovedUserGroup(selectedObject.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
            this.refreshUi();
        }
    }

    public Map<StrippedUserGroupDTO, Set<String>> getUserGroupsWithCombinedActions() {
        HashMap<StrippedUserGroupDTO, Set<String>> combinedActions = new HashMap<StrippedUserGroupDTO, Set<String>>(this.userGroupsWithAllowedActions);
        for (Map.Entry actionEntry : this.userGroupsWithDeniedActions.entrySet()) {
            if (combinedActions.containsKey(actionEntry.getKey())) {
                Set set = (Set)combinedActions.get(actionEntry.getKey());
                set.addAll((Collection)actionEntry.getValue());
                continue;
            }
            combinedActions.put((StrippedUserGroupDTO)actionEntry.getKey(), (Set)actionEntry.getValue());
        }
        return combinedActions;
    }

    private <T> Set<T> toSet(Iterable<T> iter) {
        HashSet<T> resultSet;
        if (iter instanceof Set) {
            resultSet = (HashSet<T>)iter;
        } else {
            resultSet = new HashSet<T>();
            for (T t : iter) {
                resultSet.add(t);
            }
        }
        return resultSet;
    }

    private Set<String> toDeniedActionSet(Iterable<String> iter) {
        HashSet<String> set = new HashSet<String>();
        for (String s : iter) {
            set.add(s.startsWith("!") ? s : "!" + s);
        }
        return set;
    }

    private Set<String> removeExclamationMarkFromStrings(Iterable<String> iter) {
        HashSet<String> set = new HashSet<String>();
        for (String s : iter) {
            set.add(s.startsWith("!") ? s.substring(1) : s);
        }
        return set;
    }

    static /* synthetic */ com.sap.sse.security.ui.client.i18n.StringMessages access$0(AclEditPanel aclEditPanel) {
        return aclEditPanel.stringMessages;
    }

    static /* synthetic */ StrippedUserGroupDTO access$1(AclEditPanel aclEditPanel) {
        return aclEditPanel.nullUserGroup;
    }

    static /* synthetic */ Map access$2(AclEditPanel aclEditPanel) {
        return aclEditPanel.userGroupsWithAllowedActions;
    }

    static /* synthetic */ Map access$3(AclEditPanel aclEditPanel) {
        return aclEditPanel.userGroupsWithDeniedActions;
    }

    static /* synthetic */ void access$4(AclEditPanel aclEditPanel) {
        aclEditPanel.refreshUi();
    }

    static /* synthetic */ SuggestBox access$5(AclEditPanel aclEditPanel) {
        return aclEditPanel.suggestUserGroupUi;
    }

    static /* synthetic */ SingleSelectionModel access$6(AclEditPanel aclEditPanel) {
        return aclEditPanel.userGroupSelectionModel;
    }
}

