/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Named;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DialogUtils;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedUserDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.function.Consumer;

public class EditOwnershipDialog
extends DataEntryDialog<OwnershipDialogResult> {
    private final StringMessages stringMessages;
    private final UserManagementServiceAsync userManagementService;
    private final SuggestBox suggestUserName;
    private final SuggestBox suggestUserGroupName;
    private boolean resolvingUsername;
    private boolean resolvingUserGroupName;
    private StrippedUserGroupDTO resolvedUserGroup;
    private boolean userExists;
    private final String permissionType;
    private final String securedObjectId;

    private EditOwnershipDialog(UserManagementServiceAsync userManagementService, OwnershipDTO ownership, StringMessages stringMessages, DataEntryDialog.DialogCallback<OwnershipDialogResult> callback, String permissionType, String securedObjectId) {
        super(stringMessages.ownership(), stringMessages.editObjectOwnership(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new Validator(stringMessages), callback);
        this.userManagementService = userManagementService;
        this.stringMessages = stringMessages;
        this.permissionType = permissionType;
        this.securedObjectId = securedObjectId;
        StrippedUserDTO userOwner = ownership == null ? null : (StrippedUserDTO)ownership.getUserOwner();
        this.resolvedUserGroup = ownership == null ? null : (StrippedUserGroupDTO)ownership.getTenantOwner();
        MultiWordSuggestOracle suggestUserOracle = new MultiWordSuggestOracle();
        this.userManagementService.getUserList((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.suggestUserName = this.createSuggestBox((SuggestOracle)suggestUserOracle);
        this.suggestUserName.setText(userOwner == null ? "" : userOwner.getName());
        MultiWordSuggestOracle suggestUserGroupOracle = new MultiWordSuggestOracle();
        this.userManagementService.getUserGroups((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.suggestUserGroupName = this.createSuggestBox((SuggestOracle)suggestUserGroupOracle);
        this.suggestUserGroupName.setText(this.resolvedUserGroup == null ? "" : this.resolvedUserGroup.getName());
        this.suggestUserName.addValueChangeHandler(e -> this.checkIfUserExists());
        this.suggestUserGroupName.addValueChangeHandler(e -> this.resolveUserGroup());
        this.suggestUserName.addSelectionHandler(e -> this.checkIfUserExists());
        this.suggestUserGroupName.addSelectionHandler(e -> this.resolveUserGroup());
        DialogUtils.addFocusUponKeyUpToggler((SuggestBox)this.suggestUserName);
        DialogUtils.addFocusUponKeyUpToggler((SuggestBox)this.suggestUserGroupName);
        this.checkIfUserExists();
        this.resolveUserGroup();
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(4, 2);
        result.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.id()) + ": "));
        result.setWidget(0, 1, (Widget)new Label(this.securedObjectId));
        result.setWidget(1, 0, (Widget)new Label(String.valueOf(this.stringMessages.permissionType()) + ": "));
        result.setWidget(1, 1, (Widget)new Label(this.permissionType));
        result.setWidget(2, 0, (Widget)new Label(this.stringMessages.user()));
        result.setWidget(2, 1, (Widget)this.suggestUserName);
        result.setWidget(3, 0, (Widget)new Label(this.stringMessages.group()));
        result.setWidget(3, 1, (Widget)this.suggestUserGroupName);
        return result;
    }

    public void show() {
        super.show();
        this.suggestUserName.setFocus(true);
    }

    private void resolveUserGroup() {
        if (this.resolvedUserGroup == null || !this.suggestUserGroupName.getText().equals(this.resolvedUserGroup.getName())) {
            this.resolvedUserGroup = null;
            this.resolvingUserGroupName = true;
            this.userManagementService.getStrippedUserGroupByName(this.suggestUserGroupName.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void checkIfUserExists() {
        if (!this.resolvingUsername) {
            this.resolvingUsername = true;
            this.userManagementService.userExists(this.suggestUserName.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected OwnershipDialogResult getResult() {
        return new OwnershipDialogResult(this.suggestUserName.getText(), this.resolvedUserGroup == null ? "" : this.resolvedUserGroup.getName(), this.resolvingUsername, this.resolvingUserGroupName, this.resolvedUserGroup == null ? null : this.resolvedUserGroup.getId(), this.userExists, null);
    }

    public static <T extends Named & SecuredDTO> DialogConfig<T> create(UserManagementWriteServiceAsync userManagementWriteService, HasPermissions type, Consumer<T> updateCallback, StringMessages stringMessages) {
        return new DialogConfig(userManagementWriteService, type, updateCallback, stringMessages, null);
    }

    /* synthetic */ EditOwnershipDialog(UserManagementServiceAsync userManagementServiceAsync, OwnershipDTO ownershipDTO, StringMessages stringMessages, DataEntryDialog.DialogCallback dialogCallback, String string, String string2, EditOwnershipDialog editOwnershipDialog) {
        this(userManagementServiceAsync, ownershipDTO, stringMessages, dialogCallback, string, string2);
    }

    static /* synthetic */ void access$2(EditOwnershipDialog editOwnershipDialog, StrippedUserGroupDTO strippedUserGroupDTO) {
        editOwnershipDialog.resolvedUserGroup = strippedUserGroupDTO;
    }

    static /* synthetic */ void access$3(EditOwnershipDialog editOwnershipDialog, boolean bl) {
        editOwnershipDialog.resolvingUserGroupName = bl;
    }

    static /* synthetic */ void access$4(EditOwnershipDialog editOwnershipDialog) {
        editOwnershipDialog.validateAndUpdate();
    }

    static /* synthetic */ StringMessages access$5(EditOwnershipDialog editOwnershipDialog) {
        return editOwnershipDialog.stringMessages;
    }

    static /* synthetic */ void access$6(EditOwnershipDialog editOwnershipDialog, boolean bl) {
        editOwnershipDialog.resolvingUsername = bl;
    }

    static /* synthetic */ void access$7(EditOwnershipDialog editOwnershipDialog, boolean bl) {
        editOwnershipDialog.userExists = bl;
    }
}

