/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.component.AbstractUserDialog;
import com.sap.sse.security.ui.client.i18n.StringMessages;

public class AbstractUserDialog
extends DataEntryDialog<UserData> {
    private final StringMessages stringMessages;
    private final TextBox nameBox = this.createTextBox("", 30);
    private final TextBox emailBox;
    private final TextBox oldPwBox;
    private final PasswordTextBox pwBox;
    private final PasswordTextBox pwRepeat;
    private final UserManagementServiceAsync userManagementService;
    private boolean resolvingUsername = false;
    private boolean usernameUnavailable = true;

    public AbstractUserDialog(StringMessages stringMessages, String title, UserManagementServiceAsync userManagementService, UserDTO user, DataEntryDialog.DialogCallback<UserData> callback, boolean checkUsernameForExistance) {
        this(stringMessages, title, title, userManagementService, user, callback, checkUsernameForExistance);
    }

    public AbstractUserDialog(StringMessages stringMessages, String title, String message, UserManagementServiceAsync userManagementService, UserDTO user, DataEntryDialog.DialogCallback<UserData> callback, boolean checkUsernameForExistance) {
        this(stringMessages, title, message, userManagementService, user, null, callback, checkUsernameForExistance);
        super.setValidator((DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */);
    }

    public AbstractUserDialog(StringMessages stringMessages, String title, String message, UserManagementServiceAsync userManagementService, UserDTO user, DataEntryDialog.Validator<UserData> validator, DataEntryDialog.DialogCallback<UserData> callback) {
        this(stringMessages, title, message, userManagementService, user, validator, callback, true);
    }

    public AbstractUserDialog(StringMessages stringMessages, String title, String message, UserManagementServiceAsync userManagementService, UserDTO user, DataEntryDialog.Validator<UserData> validator, DataEntryDialog.DialogCallback<UserData> callback, boolean checkUsernameForExistance) {
        super(title, message, stringMessages.ok(), stringMessages.cancel(), validator, callback);
        this.nameBox.setName("username");
        this.nameBox.ensureDebugId("username");
        this.emailBox = this.createTextBox("", 30);
        this.emailBox.ensureDebugId("eMail");
        this.oldPwBox = this.createPasswordTextBox("", 30);
        this.pwBox = this.createPasswordTextBox("", 30);
        this.pwBox.ensureDebugId("pw");
        this.pwBox.setName("password");
        this.pwRepeat = this.createPasswordTextBox("", 30);
        this.pwRepeat.ensureDebugId("pwrepeat");
        if (user != null) {
            this.nameBox.setText(user.getName());
            this.emailBox.setText(user.getEmail());
        }
        this.stringMessages = stringMessages;
        this.userManagementService = userManagementService;
        if (checkUsernameForExistance) {
            this.nameBox.addKeyUpHandler(e -> this.checkIfUsernameExists());
        } else {
            this.usernameUnavailable = false;
        }
    }

    public AbstractUserDialog(StringMessages stringMessages, String title, UserManagementServiceAsync userManagementService, UserDTO user, DataEntryDialog.DialogCallback<UserData> callback) {
        this(stringMessages, title, userManagementService, user, callback, true);
    }

    private void checkIfUsernameExists() {
        this.resolvingUsername = true;
        this.validateAndUpdate();
        String username = this.nameBox.getText();
        this.userManagementService.userExists(username, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected UserManagementServiceAsync getUserManagementService() {
        return this.userManagementService;
    }

    protected Focusable getInitialFocusWidget() {
        return this.nameBox;
    }

    protected StringMessages getStringMessages() {
        return this.stringMessages;
    }

    protected TextBox getNameBox() {
        return this.nameBox;
    }

    protected TextBox getEmailBox() {
        return this.emailBox;
    }

    protected TextBox getOldPwBox() {
        return this.oldPwBox;
    }

    protected PasswordTextBox getPwBox() {
        return this.pwBox;
    }

    protected PasswordTextBox getPwRepeat() {
        return this.pwRepeat;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(4, 2);
        result.setWidget(0, 0, (Widget)new Label(this.getStringMessages().username()));
        result.setWidget(0, 1, (Widget)this.getNameBox());
        result.setWidget(1, 0, (Widget)new Label(this.getStringMessages().email()));
        result.setWidget(1, 1, (Widget)this.getEmailBox());
        result.setWidget(2, 0, (Widget)new Label(this.getStringMessages().password()));
        result.setWidget(2, 1, (Widget)this.getPwBox());
        result.setWidget(3, 0, (Widget)new Label(this.getStringMessages().passwordRepeat()));
        result.setWidget(3, 1, (Widget)this.getPwRepeat());
        return result;
    }

    protected UserData getResult() {
        return new UserData(this.nameBox.getText(), this.emailBox.getText(), this.oldPwBox.getText(), this.pwBox.getText(), this.pwRepeat.getText());
    }

    static /* synthetic */ boolean access$1(AbstractUserDialog abstractUserDialog) {
        return abstractUserDialog.resolvingUsername;
    }

    static /* synthetic */ boolean access$2(AbstractUserDialog abstractUserDialog) {
        return abstractUserDialog.usernameUnavailable;
    }

    static /* synthetic */ TextBox access$3(AbstractUserDialog abstractUserDialog) {
        return abstractUserDialog.nameBox;
    }

    static /* synthetic */ void access$4(AbstractUserDialog abstractUserDialog, boolean bl) {
        abstractUserDialog.usernameUnavailable = bl;
    }

    static /* synthetic */ void access$5(AbstractUserDialog abstractUserDialog, boolean bl) {
        abstractUserDialog.resolvingUsername = bl;
    }

    static /* synthetic */ void access$6(AbstractUserDialog abstractUserDialog) {
        abstractUserDialog.validateAndUpdate();
    }
}

