/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.authentication.app;

import com.sap.sse.gwt.client.ServerInfoDTO;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.authentication.app.AuthenticationContext;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import java.util.ArrayList;

public class AuthenticationContextImpl
implements AuthenticationContext {
    private final UserDTO currentUser;
    private static final UserDTO ANONYMOUS = new UserDTO("Anonymous", "", "", "", null, false, new ArrayList(), new ArrayList(), null, new ArrayList(), null, null);
    private final UserService userService;
    private final PaywallResolver paywallResolver;

    public AuthenticationContextImpl(UserDTO currentUser, UserService userService, PaywallResolver paywallResolver) {
        this.userService = userService;
        this.paywallResolver = paywallResolver;
        this.currentUser = currentUser == null ? ANONYMOUS : currentUser;
    }

    public boolean isLoggedIn() {
        return this.currentUser != ANONYMOUS;
    }

    public UserDTO getCurrentUser() {
        return this.currentUser;
    }

    public String getUserTitle() {
        String fullName = this.currentUser.getFullName();
        if (fullName != null && !fullName.isEmpty()) {
            return fullName;
        }
        return this.currentUser.getName();
    }

    public String getUserSubtitle() {
        String company = this.currentUser.getCompany();
        if (company != null && !company.isEmpty()) {
            return company;
        }
        String email = this.currentUser.getEmail();
        if (email != null && !email.isEmpty()) {
            return email;
        }
        return this.currentUser.getName();
    }

    public boolean hasPermission(SecuredDTO securedDTO, HasPermissions.Action action) {
        return this.userService.hasPermission(securedDTO, action);
    }

    public boolean hasServerPermission(HasPermissions.Action action) {
        return this.userService.hasServerPermission(action);
    }

    public ServerInfoDTO getServerInfo() {
        return this.userService.getServerInfo();
    }

    public PaywallResolver getPaywallResolver() {
        return this.paywallResolver;
    }
}

