/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector.persistence.impl;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sailing.expeditionconnector.ExpeditionDeviceConfiguration;
import com.sap.sailing.expeditionconnector.persistence.DomainObjectFactory;
import com.sap.sailing.expeditionconnector.persistence.impl.CollectionNames;
import com.sap.sailing.expeditionconnector.persistence.impl.FieldNames;
import java.util.ArrayList;
import java.util.UUID;
import org.bson.Document;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private final MongoDatabase db;

    public DomainObjectFactoryImpl(MongoDatabase db) {
        this.db = db;
    }

    @Override
    public Iterable<ExpeditionDeviceConfiguration> getExpeditionDeviceConfigurations() {
        ArrayList<ExpeditionDeviceConfiguration> result = new ArrayList<ExpeditionDeviceConfiguration>();
        MongoCollection expeditionDeviceConfigurationsCollection = this.db.getCollection(CollectionNames.EXPEDITION_DEVICE_CONFIGURATIONS.name());
        for (Document dbo : expeditionDeviceConfigurationsCollection.find()) {
            UUID uuid = (UUID)dbo.get((Object)FieldNames.EXPEDITION_DEVICE_CONFIGURATION_UUID.name());
            String name = (String)dbo.get((Object)FieldNames.EXPEDITION_DEVICE_CONFIGURATION_NAME.name());
            Number boatIdAsNumber = (Number)dbo.get((Object)FieldNames.EXPEDITION_DEVICE_CONFIGURATION_BOAT_ID.name());
            Integer boatId = boatIdAsNumber == null ? null : Integer.valueOf(boatIdAsNumber.intValue());
            result.add(new ExpeditionDeviceConfiguration(name, uuid, boatId));
        }
        return result;
    }
}

