/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.operationaltransformation;

import com.sap.sse.operationaltransformation.Operation;
import java.util.ArrayList;
import java.util.List;

public class UnmergedOperationsQueue<O extends Operation<S>, S> {
    private int numberOfFirstInList = 0;
    private final List<O> unmergedOperations = new ArrayList<O>(5);

    public synchronized void sentOutOperation(O operationSentOut) {
        this.unmergedOperations.add(operationSentOut);
    }

    public synchronized List<O> getUnmergedOperations(int numberOfConfirmedLocalOperations) {
        return new ArrayList<O>(this.unmergedOperations.subList(numberOfConfirmedLocalOperations - this.numberOfFirstInList, this.unmergedOperations.size()));
    }

    public synchronized void updateWithTransformed(int localOperationNumber, O operation) {
        this.unmergedOperations.set(localOperationNumber - this.numberOfFirstInList, operation);
    }

    public synchronized void confirm(int numberOfMergedOperations) {
        int i = this.numberOfFirstInList;
        while (i < numberOfMergedOperations) {
            this.unmergedOperations.remove(0);
            ++i;
        }
        this.numberOfFirstInList = numberOfMergedOperations;
    }

    public synchronized String toString() {
        int i = this.numberOfFirstInList;
        StringBuilder result = new StringBuilder();
        result.append('[');
        boolean first = true;
        for (Operation op : this.unmergedOperations) {
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            result.append(i);
            result.append(": ");
            result.append(op);
        }
        result.append(']');
        return result.toString();
    }
}

