/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.windestimation;

import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.confidence.HasConfidenceAndIsScalable;
import com.sap.sailing.polars.windestimation.ManeuverClassification;
import com.sap.sse.common.scalablevalue.ScalableValue;
import java.util.function.Function;

public class ManeuverClassificationToHasConfidenceAndIsScalableAdapter<ValueType, BaseType>
implements Function<ManeuverClassification, HasConfidenceAndIsScalable<ValueType, BaseType, Void>> {
    private final Function<ManeuverClassification, ScalableValue<ValueType, BaseType>> mapper;
    private final ManeuverType maneuverType;

    public ManeuverClassificationToHasConfidenceAndIsScalableAdapter(ManeuverType maneuverType, Function<ManeuverClassification, ScalableValue<ValueType, BaseType>> mapper) {
        this.maneuverType = maneuverType;
        this.mapper = mapper;
    }

    @Override
    public HasConfidenceAndIsScalable<ValueType, BaseType, Void> apply(final ManeuverClassification t) {
        return new HasConfidenceAndIsScalable<ValueType, BaseType, Void>(){
            private static final long serialVersionUID = -5617237614367649676L;

            public ScalableValue<ValueType, BaseType> getScalableValue() {
                return (ScalableValue)ManeuverClassificationToHasConfidenceAndIsScalableAdapter.this.mapper.apply(t);
            }

            public double getConfidence() {
                return t.getLikelihoodForManeuverType(ManeuverClassificationToHasConfidenceAndIsScalableAdapter.this.maneuverType);
            }

            public Void getRelativeTo() {
                return null;
            }

            public BaseType getObject() {
                return this.getScalableValue().divide(1.0);
            }
        };
    }
}

