/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.mining;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.polars.mining.GPSFixMovingWithPolarContext;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.datamining.components.FilterCriterion;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.logging.Logger;

public class PolarFixFilterCriteria
implements FilterCriterion<GPSFixMovingWithPolarContext> {
    private static final Logger logger = Logger.getLogger(PolarFixFilterCriteria.class.getName());
    private final double pctOfLeadingCompetitorsToInclude;

    public PolarFixFilterCriteria(double pctOfLeadingCompetitorsToInclude) {
        this.pctOfLeadingCompetitorsToInclude = pctOfLeadingCompetitorsToInclude;
    }

    public PolarFixFilterCriteria() {
        this.pctOfLeadingCompetitorsToInclude = 0.0;
    }

    public boolean matches(GPSFixMovingWithPolarContext element) {
        boolean isValid;
        boolean importantDataIsNotNull = this.importantDataIsNotNull(element);
        if (!importantDataIsNotNull) {
            return false;
        }
        boolean afterStartTime = this.isAfterStartTime(element);
        boolean beforeFinishTime = this.isBeforeFinishTime(element);
        boolean noDirectionChange = !this.hasDirectionChange(element);
        boolean isInLeadingCompetitors = true;
        if (this.pctOfLeadingCompetitorsToInclude > 0.0) {
            isInLeadingCompetitors = PolarFixFilterCriteria.isInLeadingCompetitors(element.getRace(), element.getCompetitor(), this.pctOfLeadingCompetitorsToInclude);
        }
        boolean bl = isValid = importantDataIsNotNull && afterStartTime && beforeFinishTime && noDirectionChange && isInLeadingCompetitors;
        if (Boolean.FALSE.booleanValue() && isValid) {
            this.checkForAbnormalFixesAndLog(element);
        }
        return isValid;
    }

    private void checkForAbnormalFixesAndLog(GPSFixMovingWithPolarContext element) {
        double twa = ((Bearing)element.getAbsoluteAngleToTheWind().getObject()).getDegrees();
        if (element.getLegType() == LegType.DOWNWIND) {
            if (Math.abs(twa) < 100.0) {
                logger.warning(String.format("Very wide downwind fix input to polar data container. Race: %s, Competitor: %s, Timepoint: %s, TWA: %s", element.getRace().getRace().getName(), element.getCompetitor().getName(), element.getFix().getTimePoint(), twa));
            }
        } else if (element.getLegType() == LegType.UPWIND) {
            if (Math.abs(twa) > 70.0) {
                logger.warning(String.format("Very wide upwind fix input to polar data container. Race: %s, Competitor: %s, Timepoint: %s, TWA: %s", element.getRace().getRace().getName(), element.getCompetitor().getName(), element.getFix().getTimePoint(), twa));
            } else if (Math.abs(twa) < 35.0) {
                logger.warning(String.format("Very narrow upwind fix input to polar data container. Race: %s, Competitor: %s, Timepoint: %s, TWA: %s", element.getRace().getRace().getName(), element.getCompetitor().getName(), element.getFix().getTimePoint(), twa));
            }
        }
    }

    private boolean importantDataIsNotNull(GPSFixMovingWithPolarContext element) {
        BearingWithConfidence<Void> angleToTheWind = element.getAbsoluteAngleToTheWind();
        WindWithConfidence<Util.Pair<Position, TimePoint>> windSpeed = element.getWind();
        SpeedWithBearingWithConfidence<TimePoint> boatSpeedWithConfidence = element.getBoatSpeed();
        boolean result = false;
        if (angleToTheWind != null && windSpeed != null && boatSpeedWithConfidence != null) {
            result = true;
        }
        return result;
    }

    public static boolean isInLeadingCompetitors(TrackedRace trackedRace, Competitor competitor, double numberOfLeadingCompetitorsToInclude) {
        boolean result = !trackedRace.isLive((TimePoint)new MillisecondsTimePoint(System.currentTimeMillis())) ? PolarFixFilterCriteria.isInLeadingCompetitorsForReplayRace(trackedRace, competitor, numberOfLeadingCompetitorsToInclude) : PolarFixFilterCriteria.isInLeadingCompetitorsForLiveRace(trackedRace, competitor, numberOfLeadingCompetitorsToInclude);
        return result;
    }

    private static boolean isInLeadingCompetitorsForLiveRace(TrackedRace trackedRace, Competitor competitor, double pctOfLeadingCompetitorsToInclude) {
        Waypoint wayPoint;
        boolean result = false;
        NavigableSet markPassingsOfCompetitor = trackedRace.getMarkPassings(competitor);
        if (!markPassingsOfCompetitor.isEmpty() && (wayPoint = ((MarkPassing)markPassingsOfCompetitor.last()).getWaypoint()) != null) {
            Iterator markPassingsAtCompetitorsLastWayPoint = trackedRace.getMarkPassingsInOrder(wayPoint).iterator();
            int i = 0;
            while (i < (int)Math.max(Math.round(pctOfLeadingCompetitorsToInclude * (double)PolarFixFilterCriteria.getNumberOfCompetitors(trackedRace)), 1L)) {
                if (markPassingsAtCompetitorsLastWayPoint.hasNext()) {
                    if (((MarkPassing)markPassingsAtCompetitorsLastWayPoint.next()).getCompetitor().equals(competitor)) {
                        result = true;
                        break;
                    }
                } else {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private static int getNumberOfCompetitors(TrackedRace trackedRace) {
        int result;
        Iterable competitors = trackedRace.getRace().getCompetitors();
        if (competitors instanceof Collection) {
            Collection competitorCollection = (Collection)competitors;
            result = competitorCollection.size();
        } else {
            int counter = 0;
            Iterator iterator = competitors.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++counter;
            }
            result = counter;
        }
        return result;
    }

    private static boolean isInLeadingCompetitorsForReplayRace(TrackedRace trackedRace, Competitor competitor, double pctOfLeadingCompetitorsToInclude) {
        boolean result = false;
        Waypoint lastWaypoint = trackedRace.getRace().getCourse().getLastWaypoint();
        if (lastWaypoint != null) {
            Iterator finishPassings = trackedRace.getMarkPassingsInOrder(lastWaypoint).iterator();
            int i = 0;
            while (i < (int)Math.max(Math.round(pctOfLeadingCompetitorsToInclude * (double)PolarFixFilterCriteria.getNumberOfCompetitors(trackedRace)), 1L)) {
                if (finishPassings.hasNext()) {
                    if (((MarkPassing)finishPassings.next()).getCompetitor().equals(competitor)) {
                        result = true;
                        break;
                    }
                } else {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private boolean hasDirectionChange(GPSFixMovingWithPolarContext element) {
        GPSFixTrack track = element.getRace().getTrack(element.getCompetitor());
        return track.hasDirectionChange(element.getFix().getTimePoint(), element.getRace().getRace().getBoatClass().getManeuverDegreeAngleThreshold());
    }

    private boolean isBeforeFinishTime(GPSFixMovingWithPolarContext element) {
        TimePoint timepointOfFix = element.getFix().getTimePoint();
        TimePoint finishTime = this.calculateFinishTime(element.getRace(), element.getCompetitor());
        boolean isBeforeFinish = finishTime == null || timepointOfFix.before(finishTime);
        return isBeforeFinish;
    }

    private TimePoint calculateFinishTime(TrackedRace race, Competitor competitor) {
        TimePoint passedFinishTimePoint;
        MarkPassing finishPassing;
        Course course;
        TimePoint finishTime = race.getEndOfRace();
        if (finishTime != null && (course = race.getRace().getCourse()).getLastWaypoint() != course.getFirstWaypoint() && (finishPassing = race.getMarkPassing(competitor, course.getLastWaypoint())) != null && (passedFinishTimePoint = finishPassing.getTimePoint()).before(finishTime)) {
            finishTime = passedFinishTimePoint;
        }
        return finishTime;
    }

    private boolean isAfterStartTime(GPSFixMovingWithPolarContext element) {
        boolean isAfterStart;
        TimePoint timepointOfFix = element.getFix().getTimePoint();
        try {
            TimePoint startTime = this.calculateStartTime(element.getRace(), element.getCompetitor());
            isAfterStart = timepointOfFix.after(startTime);
        }
        catch (CompetitorDidNotStartYetException exception) {
            isAfterStart = false;
        }
        return isAfterStart;
    }

    private TimePoint calculateStartTime(TrackedRace race, Competitor competitor) throws CompetitorDidNotStartYetException {
        MarkPassing startPassing = race.getMarkPassing(competitor, race.getRace().getCourse().getFirstWaypoint());
        if (startPassing == null) {
            throw new CompetitorDidNotStartYetException();
        }
        TimePoint raceStartTime = race.getStartOfRace();
        TimePoint passedStartTimePoint = startPassing.getTimePoint();
        TimePoint startTime = raceStartTime == null || passedStartTimePoint.after(raceStartTime) ? passedStartTimePoint : raceStartTime;
        return startTime;
    }

    public Class<GPSFixMovingWithPolarContext> getElementType() {
        return GPSFixMovingWithPolarContext.class;
    }

    private class CompetitorDidNotStartYetException
    extends Exception {
        private static final long serialVersionUID = 7906688735433666009L;

        private CompetitorDidNotStartYetException() {
        }
    }
}

