/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.mining;

import com.sap.sailing.polars.mining.BearingComparator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.data.ClusterBoundary;
import com.sap.sse.datamining.impl.data.ClusterWithLowerAndUpperBoundaries;
import com.sap.sse.datamining.impl.data.ComparatorClusterBoundary;
import com.sap.sse.datamining.impl.data.ComparisonStrategy;
import com.sap.sse.datamining.impl.data.FixClusterGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class BearingClusterGroup
extends FixClusterGroup<Bearing> {
    private static final long serialVersionUID = -3810975212669767738L;

    public BearingClusterGroup(int startAngle, int endAngle, int clusterSize) {
        super(BearingClusterGroup.createClusters(startAngle, endAngle, clusterSize));
    }

    private static Collection<Cluster<Bearing>> createClusters(int startAngle, int endAngle, int clusterSize) {
        int numberOfClusters = (endAngle - startAngle) / clusterSize;
        ArrayList<Cluster<Bearing>> clusters = new ArrayList<Cluster<Bearing>>();
        int i = 0;
        while (i < numberOfClusters) {
            clusters.add((Cluster<Bearing>)new ClusterWithLowerAndUpperBoundaries(BearingClusterGroup.createBoundary(startAngle + i * clusterSize, ComparisonStrategy.GREATER_THAN), BearingClusterGroup.createBoundary(startAngle + (i + 1) * clusterSize, ComparisonStrategy.LOWER_EQUALS_THAN)));
            ++i;
        }
        return clusters;
    }

    private static ClusterBoundary<Bearing> createBoundary(double angleInDeg, ComparisonStrategy strategy) {
        DegreeBearingImpl angle = new DegreeBearingImpl(angleInDeg);
        BearingComparator comparator = new BearingComparator();
        return new ComparatorClusterBoundary((Serializable)angle, strategy, (Comparator)comparator);
    }
}

